* Program: PrgToVcx.prg
* Classes: PrgToVcx
*   Bases: Based on Custom
*  Notice: The author releases all rights to the public domain
*        : subject to the Warranty Disclaimer below.
*  Author: Tom Rettig
*        : Rettig Micro Corporation
*        : 2532 Lincoln Boulevard, Suite 110
*        : Marina del Rey, CA  90291-5978
*        :  Telephone: 310-301-0911
*        :        Fax: 310-821-1162
*        : CompuServe: 75066,352
*        :           : in FOXUSER forum's 3rd-Party section or MAIL
* Version: PrgToVcx Version 1.0 Beta 2b, April 7, 1995
* Created: December 10, 1994 (Beta 1)
*  Update: January 7, 1995 (Beta 1b)
*  Update: April 7, 1995 (Beta 2b)
*  Action: Convert program class library (PRG) to visual class library (VCX).
*   Usage: SET PROCEDURE TO PrgToVcx
*        : oPtoV = CREATEOBJECT("PrgToVcx")
*        : oPtoV.Convert([cPrgName.prg [, cVcxName.vcx]])
*Requires: Visual FoxPro for Windows version 3.0 or later
*        : True.h named constant file (#included below)
*   Notes: - Will change as necessary for the VFP release version.
*        : - May be freely used, modified, and distributed in
*        : compiled and/or source code form.
*        : - The author appreciates acknowledgement in commercial
*        : products and publications that use or learn from this class.
*        : - Technical support is not officially provided.  The
*        : author is very interested in hearing about problems
*        : or enhancement requests you have, and will try to be
*        : helpful within reasonable limits.  Email or fax preferred.
*        : - Warranty Disclaimer: NO WARRANTY!!!
*        : THE AUTHOR RELEASES TO THE PUBLIC DOMAIN ALL CLAIMS TO ANY
*        : RIGHTS IN THIS PROGRAM AND FREELY PROVIDES IT AS IS WITHOUT
*        : WARRANTY OF ANY KIND, EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*        : LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*        : FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL THE AUTHOR, OR ANY
*        : OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THIS PROGRAM, BE
*        : LIABLE FOR ANY COMMERCIAL, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
*        : DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM
*        : INCLUDING, BUT NOT LIMITED TO, LOSS OF DATA OR DATA BEING
*        : RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR LOSSES
*        : SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE PROGRAM TO
*        : OPERATE WITH ANY OTHER PROGRAMS, EVEN IF YOU OR OTHER PARTIES
*        : HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

* ADDITIONAL NOTES:
* Only tested with Custom as the base class so far
* All subclasses and Parent classes (super classes) must be in
*    the same program file
* All #DEFINEs must be in the #INCLUDE file, any in program are ignored.
* Use *>* to add property and method descriptions.
* Note for <message> insert that properties and methods cannot have
*   the same name.
* Array initializations in the class body are moved to the Init method
*    because Custom classes have no Load event.
* STORE ... TO in the class body is ignored.  Use <property> = <value> instead.
*
* VCX contents:
*    BaseClass = "custom"
*    Protected lowercase list ?must be sorted?
*       In the case of an ADD OBJECT record, optionally contains
*       uppercase TRUE.
*    Properties Height and Width are first, Name is last, everything else
*       is inbetween.
*    Reserved1 = "Class"   && ///always? even on sub or contained classes?
*    Reserved2 = "1"       && number of objects in container
*    Reserved3 is a list of protected and exposed property and method names.
*      Lowercase name with * prefix if a method.
*      Optional 255 char descrip follows name.
*      Properties must be first, arrays and methods can be mixed.///?
*      Array dimensions must be stripped of spaces and one dimensional
*         arrays are shown as aName[1,0], an illegal DELCARE value.
*      Formats:
*         newproperty[<space><description>]<crlf>
*         ^newpropertyarray<dimensions>[<space><description>]<crlf>
*         *newmethod[<space><description>]<crlf>
*    Reserved4 is the icon name; ///always empty in custom classes?
*    Reserved5 is unknown; ///always empty in custom classes?
*    Reserved6 = "Pixels"  && Pixels or Foxels (proper)
*    Reserved7 = PROGRAM() + " converted from " +;
*                lcLibProgram + ", " + TTOC(DATETIME())  && 255 char max
*    Reserved8 is the #INCLUDE file  && lowercase, relative path to vcx
*       In the case of an ADD OBJECT record, Reserved8 optionally
*       contains uppercase NOINIT.
*    User contains the program library's comment header 

#INCLUDE TRUE.h

*-- Class Browser Import add-in.  Contributed by Ken Levy.
*   Execute the following line in the Command Window while the
*   Class Browser is active to install PrgToVcx.prg as an add-in:
*     _oBrowser.AddIn("PrgToVcx", "PrgToVcx")
LPARAMETERS oSource
LOCAL oPrgToVcx, lcClass

IF NOT TYPE("oSource") == "O"
   RETURN .F.  && early exit
ENDIF
oPrgToVcx = CREATEOBJECT("PrgToVcx")

*-- Set class filter.
lcClass = oSource.cClass
IF "." $ lcClass
   lcClass = ""
ENDIF

IF NOT oPrgToVcx.Convert( , oSource.cFileName, lcClass)
   RETURN .F.  && early exit
ENDIF

*-- Refresh Class Browser.
oSource.RefreshClassList()
oSource.RefreshMembers()
RETURN
*-- End Class Browser Import add-in


DEFINE CLASS PrgToVcx AS Custom

   PROCEDURE Convert(tcLibProgram, tcLibVisual, tcClass)
      LOCAL lcAlias,;
            lcArray,;
            lcBaseClass,;
            lcClass,;
            llClass,;
            lnCounter,;
            lnCounter2,;
            llExact,;
            lnHandle,;
            lcHeader,;
            llHeader,;
            llInclude,;
            lcLibProgram,;
            lcLibVisual,;
            laMembers[1],;
            lcName,;
            lnParen,;
            lnPosition,;
            lcProperty,;
            llProtect,;
            lnRecno,;
            lnSelect,;
            lcString,;
            lnTabSpaces,;
            llTalk,;
            lcTemp,;
            lcValue,;
            lcVcx
      llHeader = .T.  && until 1st class is found
      STORE "" TO lcHeader, lcClass, lcInclude
      lcLibProgram = IIF(EMPTY(tcLibProgram),;
                         GETFILE("prg"),;
                         ALLTRIM(tcLibProgram)+;
                            IIF("."$tcLibProgram, "", ".prg"))
      IF EMPTY(lcLibProgram)
         RETURN .F.  && early exit
      ENDIF
      lcLibVisual = IIF(EMPTY(tcLibVisual),;
                        LEFT(lcLibProgram, RAT(".", lcLibProgram))+"vcx",;
                        ALLTRIM(tcLibVisual)+;
                           IIF("."$tcLibVisual, "", ".vcx"))
      lnSelect = SELECT()
      llTalk = SET("TALK")=="ON"
      SET TALK OFF

      DO CASE
         CASE _WINDOWS
            lcPlatform = "WINDOWS"
         CASE _MAC
            lcPlatform = "MAC"
         CASE _DOS
            lcPlatform = "DOS"
         CASE _UNIX
            lcPlatform = "UNIX"
      ENDCASE

      lnHandle = FOPEN(lcLibProgram)
      IF lnHandle < 1
         ERROR "Opening " + SYS(cnVF_SYS_CROSSPATH, lcLibProgram)
         RETURN .F.  && early exit
      ENDIF

      * Only create VCX if it doesn't exist, otherwise we'll just
      * add into the existing VCX and delete the existing same class
      * record if any.
      IF NOT FILE(lcLibVisual)
         CREATE CLASSLIB (lcLibVisual)
      ENDIF
      IF NOT FILE(lcLibVisual)
         ERROR cnVF_ERR_FILE_NOTEXIST,;
               SYS(cnVF_SYS_CROSSPATH, lcLibVisual)
         =FCLOSE(lnHandle)
         RETURN .F.  && early exit
      ENDIF

      lcVcx = SYS(cnVF_SYS_UNIQUEID)
      SELECT 0
      USE (lcLibVisual) AGAIN ALIAS (lcVcx)
      IF NOT USED(lcVcx)  && may be exclusive or not
         ERROR "Opening " + SYS(cnVF_SYS_CROSSPATH, lcLibVisual)
         =FCLOSE(lnHandle)
         SELECT (lnSelect)
         RETURN .F.  && early exit
      ENDIF

      * No more early exits after here.
      SET MESSAGE TO "Reading " + SYS(cnVF_SYS_CROSSPATH, lcLibProgram)

      * Temporary cursor.
      SELECT 0
      lcAlias = SYS(cnVF_SYS_UNIQUEID)
      CREATE CURSOR (lcAlias);
         (cClass     C(32),;
          cMember    C(10),;
          lProtect   L,;
          lBase      L,;
          mName      M,;
          mValue     M,;
          mArray     M,;
          mInit      M,;
          mDescrip   M)
      INDEX ON LOWER(cClass + cMember + PADR(mName, 128)) TAG PrimaryKey
      * Member can be "Property", "Method", "Class", or "Object".

      * Read prg strings into cursor.
      lnTabSpaces = THIS.rnTabSpaces
      DO WHILE NOT FEOF(lnHandle)
         DO CASE
            * Program header.
            CASE llHeader  && shuts off after #INCLUDE or DEFINE CLASS
               lcString = STRTRAN(FGETS(lnHandle),;
                                  ccTAB, SPACE(lnTabSpaces))
               * Only one allowed.  Ignores any after the first.
               DO WHILE UPPER(LEFT(LTRIM(lcString), 5)) # "#INCL" AND;
                        NOT (UPPER(LEFT(LTRIM(lcString), 4)) == "DEFI" AND;
                             UPPER(LEFT(LTRIM(SUBSTR(LTRIM(lcString),;
                                                     AT(" ", LTRIM(lcString)))),;
                                        4)) == "CLAS")
                  lcHeader = lcHeader + lcString + ccCRLF
                  lcString = STRTRAN(FGETS(lnHandle),;
                                     ccTAB, SPACE(lnTabSpaces))
               ENDDO
               llHeader = .F.
               LOOP  && don't get a new string below

            * #INCLUDE file.
            CASE (NOT llInclude) AND UPPER(LEFT(LTRIM(lcString), 5)) == "#INCL"
               * Only one allowed.  Ignores any after the first.
               llInclude = .T.
               lcInclude = TRIM(SUBSTR(lcString, RAT(" ", lcString)+1))
               IF LEFT(lcInclude, 1) $ [",',]+"["   && remove quotes if any
                  lcInclude = SUBSTR(lcInclude, 2, LEN(lcInclude)-2)
               ENDIF

            * DEFINE CLASS.
            CASE UPPER(LEFT(LTRIM(lcString), 4)) == "DEFI" AND;
                 UPPER(LEFT(LTRIM(SUBSTR(LTRIM(lcString),;
                                         AT(" ", LTRIM(lcString)))),;
                            4)) == "CLAS"  && CLASS
               llClass = .T.

               * Remove semicolons.
               DO WHILE RIGHT(TRIM(lcString), 1) == ";"
                  lcString = LEFT(TRIM(lcString), LEN(TRIM(lcString))-1)+;
                             " " + LTRIM(STRTRAN(FGETS(lnHandle),;
                                         ccTAB, SPACE(lnTabSpaces)))
               ENDDO

               * Name.
               lcClass = LTRIM(SUBSTR(LTRIM(lcString),;
                                      AT(" ", LTRIM(lcString))))
               lcClass = LTRIM(SUBSTR(lcClass, AT(" ", lcClass)))
               lcClass = TRIM(LEFT(lcClass, AT(" ", lcClass)))
               lcClass = THIS.cDefined(@lcClass)

               * Check for parent class other than VFP base classes.
               *///will break if class name is "AS" because there's no RATC().
               lcName = ALLTRIM(SUBSTR(lcString, ATC(" AS ", lcString)+4))
               IF " " $ lcName
                  lcName = TRIM(LEFT(lcName, AT(" ", lcName)))
               ENDIF
               IF "&"+"&" $ lcName
                  lcName = TRIM(LEFT(lcName, AT("&"+"&", lcName)-1))
               ENDIF
               lcName = THIS.cDefined(@lcName)

               * Check for specific class to import.
               IF EMPTY(tcClass) OR;
                     LOWER(ALLTRIM(tcClass)) == LOWER(ALLTRIM(lcName))
                  * Write.  lBase value list must have leading and
                  * trailing commas.
                  llExact = SET("EXACT") == "ON"
                  SET EXACT ON  && for ASCAN()
                  INSERT INTO (lcAlias);
                              (cClass,  cMember,  mName,  mValue,;
                               lBase);
                       VALUES (lcClass, "Class",  lcName, lcName,;
                               ASCAN(THIS.raBaseClass, LOWER(lcName)) > 0)
                  IF NOT llExact
                     SET EXACT OFF
                  ENDIF
               ENDIF  && specific class to import

            * ENDDEFINE.
            CASE llClass AND UPPER(LEFT(LTRIM(lcString), 9)) == "ENDDEFINE"
               llClass = .F.

            * PROCEDURE or FUNCTION, exposed or PROTECTED.
            CASE llClass AND;
                 UPPER(LEFT(LTRIM(lcString), 4)) == "PROC" OR;
                 UPPER(LEFT(LTRIM(lcString), 4)) == "FUNC" OR;
                 (UPPER(LEFT(LTRIM(lcString), 4)) == "PROT" AND;
                  (UPPER(LEFT(LTRIM(SUBSTR(LTRIM(lcString),;
                                           AT(" ", LTRIM(lcString)))),;
                              4)) == "PROC" OR;
                   UPPER(LEFT(LTRIM(SUBSTR(LTRIM(lcString),;
                                           AT(" ", LTRIM(lcString)))),;
                              4)) == "FUNC"))

               * Remove semicolons.
               DO WHILE RIGHT(TRIM(lcString), 1) == ";"
                  lcString = LEFT(TRIM(lcString), LEN(TRIM(lcString))-1)+;
                             " " + LTRIM(STRTRAN(FGETS(lnHandle),;
                                                 ccTAB, SPACE(lnTabSpaces)))
               ENDDO

               * Name.
               llProtect = UPPER(LEFT(LTRIM(lcString), 4)) == "PROT"
               IF llProtect
                  lcName = ALLTRIM(SUBSTR(LTRIM(lcString),;
                                          AT(" ", LTRIM(lcString))))
                  lcName = ALLTRIM(SUBSTR(lcName, AT(" ", lcName)))
               ELSE
                  lcName = ALLTRIM(SUBSTR(LTRIM(lcString),;
                                          AT(" ", LTRIM(lcString))))
               ENDIF
               lcValue = ""
               IF "(" $ lcName
                  IF NOT "()" $ lcName
                     lcValue = "LPARAMETERS " + SUBSTR(lcName,;
                                                   AT("(", lcName)+1,;
                                                   AT(")", lcName)-;
                                                     AT("(", lcName)-1) + ccCRLF
                  ENDIF
                  lcName = LEFT(lcName, AT("(", lcName)-1)
               ENDIF
               SET MESSAGE TO "Reading " + lcClass + " " + lcName

               * Value.
               lcString = STRTRAN(FGETS(lnHandle),;
                                  ccTAB, SPACE(lnTabSpaces))
               DO WHILE NOT INLIST(UPPER(LEFT(LTRIM(lcString), 7)),;
                                   "ENDPROC", "ENDFUNC")  &&///requires ENDPROC/FUNC
                  lcValue   = lcValue + lcString + ccCRLF
                  lcString = STRTRAN(FGETS(lnHandle),;
                                     ccTAB, SPACE(lnTabSpaces))
               ENDDO

               * Write.
               INSERT INTO (lcAlias);
                           (cClass,  cMember,  mName,  mValue, lProtect);
                    VALUES (lcClass, "Method", lcName, lcValue, llProtect)

            * Property declarations, exposed/protected array property
            * or protected property.
            CASE llClass AND;
                 UPPER(LEFT(LTRIM(lcString), 4)) $ "PROT,DECL,DIME"

               SET MESSAGE TO "Reading " + lcClass + " " + "Property list"
               llProtect = UPPER(LEFT(LTRIM(lcString), 4)) == "PROT"

               * Remove semicolons.
               lcString = SUBSTR(LTRIM(lcString), AT(" ", LTRIM(lcString))+1)
               DO WHILE RIGHT(TRIM(lcString), 1) == ";"
                  lcString = LEFT(TRIM(lcString), LEN(TRIM(lcString))-1)+;
                             " " + LTRIM(STRTRAN(FGETS(lnHandle),;
                                                 ccTAB, SPACE(lnTabSpaces)))
               ENDDO

               DO WHILE .T.
                  lcArray = ""
                  * Name.
                  DO CASE
                     CASE EMPTY(lcString)
                        EXIT
                     CASE NOT "," $ lcString
                        DO CASE
                           CASE "[" $ lcString
                              lcName  = LEFT(  lcString, AT("[", lcString)-1)
                              lcArray = SUBSTR(lcString, AT("[", lcString))
                           CASE "(" $ lcString
                              lcName  = LEFT(  lcString, AT("(", lcString)-1)
                              lcArray = SUBSTR(lcString, AT("(", lcString))
                           OTHERWISE
                              lcName  = ALLTRIM(lcString)
                        ENDCASE
                        lnPosition = LEN(lcString)
                     CASE AT("[", lcString) > 0 AND;
                          AT("[", lcString) < AT(",", lcString)
                        lcName     = LEFT(  lcString, AT("[", lcString)-1)
                        lcArray    = SUBSTR(lcString, AT("[", lcString))
                        lcArray    = LEFT(lcArray, AT("]", lcArray))
                        lnPosition = AT("]", lcString)
                     CASE AT("(", lcString) > 0 AND;
                          AT("(", lcString) < AT(",", lcString)
                        lcName     = LEFT(lcString, AT("(", lcString)-1)
                        lcArray    = SUBSTR(lcString, AT("(", lcString))
                        lcArray    = LEFT(lcArray, AT(")", lcArray))
                        lnPosition = AT(")", lcString)
                     OTHERWISE
                        lcName     = LTRIM(LEFT(lcString, AT(",", lcString)-1))
                        lnPosition = AT(",", lcString)
                  ENDCASE

                  * Remove inline comments.
                  IF "&"+"&" $ lcName
                     lcName = TRIM(LEFT(lcName, AT("&"+"&", lcName)-1))
                  ENDIF
                  IF "&"+"&" $ lcArray
                     lcArray = TRIM(LEFT(lcArray, AT("&"+"&", lcArray)-1))
                  ENDIF

                  * Remove spaces and substitute defined array dimensions.
                  IF NOT EMPTY(lcArray)
                     lcArray = STRTRAN(lcArray, " ")
                     lcArray = THIS.cDefined(@lcArray)
                  ENDIF

                  * Write.
                  INSERT INTO (lcAlias);
                              (cClass,  cMember,    mName,;
                               lProtect,  mArray);
                       VALUES (lcClass, "Property", lcName,;
                               llProtect, lcArray)

                  * Parse string.
                  lcString = IIF(LEN(lcString) == lnPosition,;
                                 "",;
                                 ALLTRIM(SUBSTR(lcString, lnPosition+1)))
                  IF LEFT(lcString, 1) == ","
                     lcString = LTRIM(SUBSTR(lcString, 2))
                  ENDIF
               ENDDO  && WHILE .T. with EXIT

            * Property initialization, including arrays.
            *///doesn't cover STORE ... TO , , ,
            CASE llClass AND;
                 (BETWEEN(LOWER(LEFT(LTRIM(lcString), 1)), "a", "z") OR;
                  INLIST(LEFT(LTRIM(lcString), 1), "_")                ) AND;
                 " " $ ALLTRIM(lcString) AND;
                 LEFT(LTRIM(SUBSTR(LTRIM(lcString),;
                                   AT(" ", LTRIM(lcString))+1)),;
                      2) == "= "

               * Remove semicolons.
               DO WHILE RIGHT(TRIM(lcString), 1) == ";"
                  lcString = LEFT(TRIM(lcString), LEN(TRIM(lcString))-1)+;
                             " " + LTRIM(STRTRAN(FGETS(lnHandle),;
                                                 ccTAB, SPACE(lnTabSpaces)))
               ENDDO

               * Name and value.
               lnPosition = AT(" = ", lcString)
               lcName     = ALLTRIM(LEFT(lcString, lnPosition))
               SET MESSAGE TO "Reading " + lcClass + " " + lcName
               IF "[" $ lcName OR "(" $ lcName  && array element, move to init
                  IF SEEK(LOWER(PADR(lcClass,    FSIZE("cClass"))+;
                                PADR("Property", FSIZE("cMember"))+;
                                PADR(lcName,     128)),;
                          ALIAS(), "PrimaryKey")
                     REPLACE mInit;
                        WITH "THIS." + ALLTRIM(lcString) + ccCRLF;
                        ADDITIVE
                  ENDIF  && ignore if not previously declared an array
               ELSE  && property (may be whole array name)
                  lcValue = ALLTRIM(SUBSTR(lcString, lnPosition+2))
                  IF "&"+"&" $ lcValue  && remove inline comments
                     lcValue = TRIM(LEFT(lcValue, AT("&"+"&", lcValue)-1))
                  ENDIF
                  IF SEEK(LOWER(PADR(lcClass,    FSIZE("cClass"))+;
                                PADR("Property", FSIZE("cMember"))+;
                                PADR(lcName,     128)),;
                          ALIAS(), "PrimaryKey")
                     IF EMPTY(mArray)  && protected property
                        REPLACE mValue WITH lcValue
                     ELSE   && array, so move to init method
                        REPLACE mInit;
                           WITH "THIS." + ALLTRIM(lcString) + ccCRLF;
                           ADDITIVE
                     ENDIF
                  ELSE  && new, so not an array or protected property
                     INSERT INTO (lcAlias);
                                 (cClass,  cMember,    mName,;
                                  mValue, lProtect);
                          VALUES (lcClass, "Property", lcName,;
                                  lcValue, .F.)
                  ENDIF
               ENDIF  && not an array element

            *ADD OBJECT.
            CASE llClass AND;
                 UPPER(LEFT(LTRIM(lcString), 4)) == "ADD " AND;
                 UPPER(LEFT(LTRIM(SUBSTR(LTRIM(lcString),;
                                         AT(" ", LTRIM(lcString)))),;
                            4)) == "OBJE"

               * Remove semicolons.
               DO WHILE RIGHT(TRIM(lcString), 1) == ";"
                  lcString = LEFT(TRIM(lcString), LEN(TRIM(lcString))-1)+;
                             " " + LTRIM(STRTRAN(FGETS(lnHandle),;
                                                 ccTAB, SPACE(lnTabSpaces)))
               ENDDO

               lnPosition = ATC(" AS ", lcString)
               lcName = ALLTRIM(LEFT(lcString, lnPosition))
               IF " " $ lcName
                  lcName = LTRIM(SUBSTR(lcName, RAT(" ", lcName)))
               ENDIF
               SET MESSAGE TO "Reading " + lcClass + " " + lcName
               lcValue = ALLTRIM(SUBSTR(lcString, lnPosition+4))
               IF " " $ lcValue
                  lcValue = TRIM(LEFT(lcValue, AT(" ", lcValue)))
               ENDIF
               * Remove inline comments.
               IF "&"+"&" $ lcValue
                  lcValue = TRIM(LEFT(lcValue, AT("&"+"&", lcValue)-1))
               ENDIF
               lcArray = ""
               lnPosition  = ATC(" WITH ", lcString)
               IF lnPosition > 0
                  lcArray = ALLTRIM(SUBSTR(lcString, lnPosition+6))
                  * Remove inline comments.
                  IF "&"+"&" $ lcArray
                     lcArray = TRIM(LEFT(lcArray, AT("&"+"&", lcArray)-1))
                  ENDIF

                  * Replace commas with ccCRLF unless they are within
                  * parens as in some functions like RGB(0,0,0).
                  STORE 0 TO lnCounter2, lnParen
                  FOR lnCounter = 1 TO LEN(lcArray)
                     lcTemp = SUBSTR(lcArray, lnCounter, 1)
                     DO CASE
                        CASE lcTemp == "("
                           lnParen = lnParen + 1
                        CASE lcTemp == ")"
                           lnParen = MAX(0, lnParen - 1)
                        CASE lcTemp == "," AND lnParen == 0
                           lcArray = STUFF(lcArray, lnCounter,;
                                           1, ccCRLF)
                           lnCounter2 = lnCounter2 + 1
                     ENDCASE
                  ENDFOR
                  lcArray = lcArray + ccCRLF
                  lnCounter2 = lnCounter2 + 1

                  * Get rid of spaces around CRLFs and = signs.
                  DO WHILE " "+ccCRLF $ lcArray
                     lcArray = STRTRAN(lcArray, " "+ccCRLF, ccCRLF)
                  ENDDO
                  DO WHILE ccCRLF+" " $ lcArray
                     lcArray = STRTRAN(lcArray, ccCRLF+" ", ccCRLF)
                  ENDDO
                  DO WHILE "  =" $ lcArray
                     lcArray = STRTRAN(lcArray, "  =", " =")
                  ENDDO
                  DO WHILE "=  " $ lcArray
                     lcArray = STRTRAN(lcArray, "=  ", "= ")
                  ENDDO

                  * Now go back through and put parens around function
                  * values unless it already has them.
                  FOR lnCounter = 1 TO lnCounter2
                     lnPosition = AT(ccCRLF, lcArray, lnCounter)
                     IF RIGHT(LEFT(lcArray, lnPosition-1), 1) == ","
                        lnPosition = lnPosition - 1
                     ENDIF
                     IF RIGHT(LEFT(lcArray, lnPosition-1), 1) == ")"
                        lnParen = RAT(" = ", LEFT(lcArray, lnPosition-1))
                        IF NOT LEFT(SUBSTR(lcArray, lnParen+3), 1) == "("
                           lcArray = STUFF(lcArray, lnPosition-1, 0, ")")
                           lcArray = STUFF(lcArray, lnParen+3, 0, "(")
                        ENDIF
                     ENDIF
                  ENDFOR
               ENDIF  && WITH string

               INSERT INTO (lcAlias);
                           (cClass,   cMember, mName,  mValue,;
                            lProtect,;
                            mInit,;
                            mArray);
                    VALUES (lcClass, "Object", lcName, lcValue,;
                            ATC(" PROTECTED ", lcString) > 0,;
                            IIF(ATC(" NOINIT", lcString) == 0, "", "NOINIT"),;
                            lcArray)

            CASE llClass AND;
                 LEFT(LTRIM(lcString),;
                      LEN(ccVISUAL_DESCRIPTION)) == ccVISUAL_DESCRIPTION
               * Visual class description of properties and methods.
               * 255 character VFP limit.
               * Must follow the method or property and be
               *    inside the class definition.
               * The program must use the literal as defined and may
               *    not use the actual definition "ccVISUAL_DESCRIPTION"
               *    which is used by this method.

               * Remove semicolons.
               DO WHILE RIGHT(TRIM(lcString), 1) == ";"
                  lcString = LEFT(TRIM(lcString), LEN(TRIM(lcString))-1)+;
                             " " + LTRIM(STRTRAN(FGETS(lnHandle),;
                                                 ccTAB, SPACE(lnTabSpaces)))
               ENDDO
               lcName = ALLTRIM(SUBSTR(lcString,;
                                       AT(ccVISUAL_DESCRIPTION, lcString)+;
                                       LEN(ccVISUAL_DESCRIPTION)))
               lcValue = LEFT(LTRIM(SUBSTR(lcName, AT(",", lcName)+1)), 255)
               lcName = ALLTRIM(LEFT(lcName, AT(",", lcName)-1))
               * Write.  Note that properties and methods cannot have same name.
               IF SEEK(LOWER(PADR(lcClass,    FSIZE("cClass"))+;
                             PADR("Property", FSIZE("cMember"))+;
                             PADR(lcName,     128)),;
                       ALIAS(), "PrimaryKey") OR;
                  SEEK(LOWER(PADR(lcClass,    FSIZE("cClass"))+;
                             PADR("Method",   FSIZE("cMember"))+;
                             PADR(lcName,     128)),;
                       ALIAS(), "PrimaryKey")
                  REPLACE mDescrip WITH lcValue
               ENDIF
         ENDCASE
         lcString = STRTRAN(FGETS(lnHandle),;
                            ccTAB, SPACE(lnTabSpaces))
      ENDDO
      =FCLOSE(lnHandle)  && done reading the prg, all data is in lcAlias

      *******************************************************

      * Resolve BaseClass issues.
      SET MESSAGE TO "Resolving base classes in "+;
                     SYS(cnVF_SYS_CROSSPATH, lcLibVisual)
      INDEX ON LOWER(cClass + cMember) TAG BaseKey
      SCAN FOR cMember == PADR("Class", FSIZE("cMember"))
         IF NOT lBase
            lcClass = cClass
            lnRecno = RECNO()
            lcValue = ""
            * Search until we get to a base class.
            DO WHILE SEEK(LOWER(PADR(mName,   FSIZE("cClass"))+;
                                PADR("Class", FSIZE("cMember"))),;
                          ALIAS(), "BaseKey")
               IF lBase
                  lcValue = mValue
                  EXIT
               ENDIF
            ENDDO
            GO lnRecno
            REPLACE mValue WITH lcValue
         ENDIF
      ENDSCAN

      *******************************************************

      * We've got all the data, so use the class lib and brute force.
      STORE "" TO lcArray, lcBaseClass, lcClass, lcInit, lcProperty
      SET ORDER TO PrimaryKey
      SCAN  && in sorted order
         SET MESSAGE TO "Building " + TRIM(cClass)+;
                        " " + TRIM(cMember) +" "+ mName
         IF EMPTY(lcClass) OR;
               NOT EVALUATE(lcVcx+".ObjName") == LOWER(TRIM(cClass)) && new class

            IF NOT EMPTY(lcClass)  && write last class's saved variables
               =THIS.WriteClass(lcVcx, lcClass, lcBaseClass, lcProperty,;
                                lcArray, lcInit, PROGRAM())
               DIMENSION laMembers[1]
               STORE "" TO lcProperty, lcArray, lcBaseClass,;
                           lcInit, laMembers
            ENDIF

            * New class record.
            lcClass = LOWER(TRIM(cClass))

            * Delete any existing class definitions.
            SELECT (lcVcx)
            LOCATE FOR Platform = lcPlatform AND;
                       ObjName == lcClass AND;
                       NOT (EMPTY(Reserved2) OR DELETED())
            IF FOUND()
               FOR lnCounter = 1 TO VAL(Reserved2)
                  DELETE
                  SKIP
                  IF EOF()
                     EXIT
                  ENDIF
               ENDFOR
               IF Platform = "COMMENT" AND ObjName == lcClass
                  DELETE
               ENDIF
            ENDIF
            SELECT (lcAlias)

            * Insert new class definition.
            INSERT INTO (lcVcx);
                        (Platform, UniqueId, ObjName,;
                         Reserved1, Reserved2, Reserved6,;
                         Reserved7,;
                         Reserved8, User);
                 VALUES (lcPlatform, SYS(cnVF_SYS_UNIQUEID), lcClass,;
                         "Class", "1", "Pixels",;
                         PROGRAM() + " converted from "+;
                            SYS(cnVF_SYS_CROSSPATH, lcLibProgram) + ", "+;
                              TTOC(DATETIME()),;
                         LOWER(lcInclude), lcHeader)
         ENDIF  && new class

         DO CASE
            CASE TRIM(cMember) == "Class"
               lcBaseClass = LOWER(EVALUATE(lcAlias+".mValue"))
               =AMEMBERS(laMembers, CREATEOBJECT(lcBaseClass))
               REPLACE Class     WITH LOWER(EVALUATE(lcAlias+".mName")),;
                       BaseClass WITH lcBaseClass;
                    IN (lcVcx)
               IF NOT lBase
                  REPLACE ClassLoc WITH LOWER(SYS(cnVF_SYS_RELATIVEPATH,;
                                              DBF(lcVcx),;
                                              DBF(lcVcx)));
                       IN (lcVcx)
               ENDIF

            CASE TRIM(cMember) == "Property"
               IF EMPTY(mArray)
                  * Don't store in Reserved3 (lcProperty string) if
                  * it's a VFP built-in property.
                  llExact = SET("EXACT") == "ON"
                  SET EXACT ON  && for ASCAN()
                  IF ASCAN(laMembers, UPPER(mName)) == 0
                     * Put at end of property list before methods/arrays.
                     lcProperty = lcProperty+;
                                  LOWER(mName)+;
                                  IIF(EMPTY(mDescrip), "", " " + mDescrip)+;
                                  ccCRLF
                  ENDIF
                  IF NOT EMPTY(mValue)
                     lcValue = THIS.cDefined(mValue)
                     * Put in parens if a function.
                     IF AT("(", lcValue) > 1 AND AT(")", lcValue) > 0
                        lcValue = "(" + lcValue + ")"
                     ENDIF
                     REPLACE Properties;
                        WITH LOWER(EVALUATE(lcAlias+".mName"))+;
                             " = " + lcValue + ccCRLF;
                        ADDITIVE IN (lcVcx)
                  ENDIF
                  IF NOT llExact
                     SET EXACT OFF
                  ENDIF
               ELSE  && put in array list, lcArray
                  lcValue = mArray
                  IF NOT "," $ lcValue  && reformat one dimensional array
                     lcValue = LEFT(lcValue, LEN(lcValue)-1)+;
                              ",0"+;
                              RIGHT(lcValue, 1)
                  ENDIF
                  lcArray = lcArray+;
                            "^" + LOWER(mName)+;
                            lcValue+;
                            IIF(EMPTY(mDescrip), "",  " " + mDescrip)+;
                            ccCRLF
                  IF NOT EMPTY(mInit)
                     lcInit = lcInit + mInit
                  ENDIF
               ENDIF
               IF lProtect
                  REPLACE Protected;
                     WITH LOWER(EVALUATE(lcAlias+".mName")) + ccCRLF;
                     ADDITIVE IN (lcVcx)
               ENDIF

            *///if ".", Button.Click, can't do it unless we parse
            *   it and move to a method in the proper class record.
            CASE TRIM(cMember) == "Method" AND NOT "." $ mName
               REPLACE Reserved3;
                  WITH "*" + LOWER(EVALUATE(lcAlias+".mName"))+;
                             IIF(EMPTY(EVALUATE(lcAlias+".mDescrip")),;
                                 "",;
                                 " " + EVALUATE(lcAlias+".mDescrip"))+;
                             ccCRLF;
                  ADDITIVE IN (lcVcx)
               REPLACE Methods;
                  WITH "PROCEDURE "+LOWER(EVALUATE(lcAlias+".mName"))+ccCRLF+;
                       EVALUATE(lcAlias+".mValue")+ccCRLF+;
                       "ENDPROC"+ccCRLF;
                  ADDITIVE IN (lcVcx)
               IF lProtect
                  REPLACE Protected;
                     WITH LOWER(EVALUATE(lcAlias+".mName")) + ccCRLF;
                     ADDITIVE IN (lcVcx)
               ENDIF

            CASE TRIM(cMember) == "Object"

               lnRecno = RECNO()
               =SEEK(LOWER(cClass + PADR("Class", FSIZE("cMember"))),;
                     ALIAS(), "BaseKey")
               lcName = LOWER(mInit)
               GO lnRecno

               *///if ".", Formset.Form.Button, can't do it.
               *   needs further research.
               IF "." $ lcName
                  *///ignore?
               ELSE
                  REPLACE Reserved2;
                     WITH LTRIM(STR(VAL(Reserved2)+1));
                       IN (lcVcx)
                  lnRecno = RECNO(lcVcx)
                  INSERT INTO (lcVcx);
                              (Platform,;
                               UniqueId,;
                               Class,;
                               ClassLoc,;
                               BaseClass,;
                               ObjName,;
                               Parent,;
                               Protected,;
                               Properties,;
                               Reserved8);
                       VALUES (lcPlatform,;
                               SYS(cnVF_SYS_UNIQUEID),;
                               LOWER(EVALUATE(lcAlias+".mValue")),;
                               LOWER(SUBSTR(lcLibVisual, RAT("\", lcLibVisual)+1)),;
                               lcName,;
                               LOWER(EVALUATE(lcAlias+".mName")),;
                               lcClass,;
                               IIF(EVALUATE(lcAlias+".lProtect"),;
                                   "TRUE", ""),;
                               EVALUATE(lcAlias+".mArray"),;
                               IIF(EVALUATE(lcAlias+".mInit")=="NOINIT",;
                                "NOINIT", ""))
                  GO lnRecno IN (lcVcx)
               ENDIF  && "." in object name

            OTHERWISE
               ERROR "Unknown member type"
         ENDCASE
      ENDSCAN

      * Write last class.
      IF NOT EMPTY(lcClass)  && write last class's saved variables
         =THIS.WriteClass(lcVcx, lcClass, lcBaseClass, lcProperty,;
                          lcArray, lcInit, PROGRAM())
      ENDIF

      USE IN (lcAlias)  && cursor is deleted (comment out for testing)

      SET TALK ON
      IF ISEXCLUSIVE(lcVcx)
         SET MESSAGE TO "Packing memos in "+;
                        SYS(cnVF_SYS_CROSSPATH, lcLibVisual)
         SELECT (lcVcx)
         PACK MEMO
      ENDIF

      USE IN (lcVcx)
      SET MESSAGE TO "Compiling methods in "+;
                     SYS(cnVF_SYS_CROSSPATH, lcLibVisual)
      SELECT (lnSelect)

      * COMPILE FORM removes deleted records via PACK DBF.
      * It does not PACK MEMO.
      COMPILE FORM (lcLibVisual)

      SET MESSAGE TO
      WAIT WINDOW NOWAIT PROGRAM() + " completed."
      IF NOT llTalk
         SET TALK OFF
      ENDIF
      RETURN
   ENDPROC  && Convert


   PROTECTED PROCEDURE WriteClass(tcVcx, tcClass, tcBaseClass, tcProperty,;
                                  tcArray, tcInit, tcProgram)
      LOCAL lnPosition,;
            lnPosition2,;
            lcValue,;
            lcString,;
            lcInit

      REPLACE Properties;
         WITH Properties+;
              IIF(ATC("Name =", Properties) == 1 OR;
                  ATC(ccCRLF + "Name =", Properties) > 0,;
                  "",;
                  'Name = "' + tcClass + '"'+ccCRLF);
           IN (tcVcx)

      * Write the properties to Reserved3 before methods/arrays.
      REPLACE Reserved3;
         WITH tcProperty + tcArray + Reserved3;
           IN (tcVcx)

      * Write the Init method, or Load if it's a form or formset.
      IF NOT EMPTY(tcInit)
         lcInit = "*** " + tcProgram + " BEGIN move from class body" + ccCRLF+;
                  tcInit+;
                  "*** " + tcProgram + " END move from class body" + ccCRLF
         * Place at beginning of Init or Load method.
         lnPosition = AT("PROCEDURE "+;
                         IIF(LEFT(tcBaseClass, 4) == "form",;
                             "load", "init")+ccCRLF,;
                         EVALUATE(tcVcx+".Methods"))
         IF lnPosition == 0
            REPLACE Methods;
               WITH "PROCEDURE "+;
                    IIF(LEFT(tcBaseClass, 4) == "form",;
                        "load", "init")+ccCRLF+;
                    lcInit+;
                    "ENDPROC"+ccCRLF;
               ADDITIVE IN (tcVcx)
         ELSE
            lcString = EVALUATE(tcVcx+".Methods")
            lcValue   = SUBSTR(lcString,;
                              lnPosition,;
                              AT(ccCRLF+"ENDPROC",;
                                 SUBSTR(lcString, lnPosition))+;
                              LEN(ccCRLF+"ENDPROC"))
            lnPosition2 = AT("LPARAMETERS ", lcValue)
            IF EMPTY(lnPosition2)
               lnPosition2 = AT("PARAMETERS ", lcValue)
               IF NOT EMPTY(lnPosition2)
                  lnPosition2 = lnPosition2+;
                                AT(ccCRLF,;
                                   SUBSTR(lcValue, lnPosition2)) + 2
               ENDIF
            ELSE
               lnPosition2 = lnPosition2+;
                             AT(ccCRLF,;
                                SUBSTR(lcValue, lnPosition2)) + 2
            ENDIF
            IF EMPTY(lnPosition2)
               lnPosition2 = AT(ccCRLF, lcValue) + 2
            ENDIF
            lcValue = LEFT(lcValue, lnPosition2-1)+;
                      lcInit+;
                      SUBSTR(lcValue, lnPosition2)
            lcString = LEFT(lcString, lnPosition-1)+;
                       lcValue+;
                       SUBSTR(lcString, lnPosition+;
                                        AT(ccCRLF+"ENDPROC",;
                                           SUBSTR(lcString,;
                                                  lnPosition))+;
                                        LEN(ccCRLF+"ENDPROC"))
            REPLACE Methods WITH lcString IN (tcVcx)
         ENDIF
      ENDIF

      * Write the FONTINFO record.
      IF NOT EMPTY(tcClass)
         INSERT INTO (tcVcx);
                     (Platform,  UniqueId,   ObjName);
              VALUES ("COMMENT", "FONTINFO", tcClass)
      ENDIF
   ENDPROC  && WriteClass


   PROTECTED FUNCTION cDefined(tcString)
   * Enter additional defines and #INCLUDE your .h file here.
      LOCAL lcString
      lcString = tcString

      * EDC specific.
      lcString = STRTRAN(lcString, "cxCLASS_EDC", ccCLASS_EDC)
      lcString = STRTRAN(lcString, "cxCLASS_MSG", ccCLASS_MSG)
      lcString = STRTRAN(lcString, "ccCRLF", ccCRLF_DEF)
      lcString = STRTRAN(lcString, "ccMSG_INSERT1", '"'+ccMSG_INSERT1+'"')
      lcString = STRTRAN(lcString, "ccMSG_INSERT2", '"'+ccMSG_INSERT2+'"')
      lcString = STRTRAN(lcString, "ccMSG_INSERT3", '"'+ccMSG_INSERT3+'"')
      lcString = STRTRAN(lcString, "ccEDC_REG_ALTERNATE",;
                         ccEDC_REG_ALTERNATE)
      lcString = STRTRAN(lcString, "cnVF_FIELD_MAXCOUNT",;
                         LTRIM(STR(cnVF_FIELD_MAXCOUNT)))
      lcString = STRTRAN(lcString, "cnVF_FIELD_MAXNAMELEN",;
                         LTRIM(STR(cnVF_FIELD_MAXNAMELEN)))
      lcString = STRTRAN(lcString, "cnALT_COLUMNS",;
                         LTRIM(STR(cnALT_COLUMNS)))
      lcString = STRTRAN(lcString, "cnOBJ_COLUMNS",;
                         LTRIM(STR(cnOBJ_COLUMNS)))
      lcString = STRTRAN(lcString, "cnAERR_MAX",;
                         LTRIM(STR(cnAERR_MAX)))

      RETURN lcString
   ENDFUNC  && cDefined

   PROTECTED raBaseClass[32],;
             rnTabSpaces
   rnTabSpaces = 4
   raBaseClass[ 1] = "checkbox"
   raBaseClass[ 2] = "column"
   raBaseClass[ 3] = "combobox"
   raBaseClass[ 4] = "commandbutton"
   raBaseClass[ 5] = "commandgroup"
   raBaseClass[ 6] = "container"
   raBaseClass[ 7] = "control"
   raBaseClass[ 8] = "cursor"
   raBaseClass[ 9] = "custom"
   raBaseClass[10] = "dataenvironment"
   raBaseClass[11] = "editbox"
   raBaseClass[12] = "form"
   raBaseClass[13] = "formset"
   raBaseClass[14] = "grid"
   raBaseClass[15] = "header"
   raBaseClass[16] = "image"
   raBaseClass[17] = "label"
   raBaseClass[18] = "line"
   raBaseClass[19] = "listbox"
   raBaseClass[20] = "olecontrol"
   raBaseClass[21] = "oleboundcontrol"
   raBaseClass[22] = "optionbutton"
   raBaseClass[23] = "optiongroup"
   raBaseClass[24] = "page"
   raBaseClass[25] = "pageframe"
   raBaseClass[26] = "relation"
   raBaseClass[27] = "separator"
   raBaseClass[28] = "shape"
   raBaseClass[29] = "spinner"
   raBaseClass[30] = "textbox"
   raBaseClass[31] = "timer"
   raBaseClass[32] = "toolbar"

ENDDEFINE  && CLASS PrgToVcx
*** PrgToVcx.prg ********************************************
