* Program: EnvLib.prg
* Classes: ///many definitions, see below
*   Bases: ///All based on Custom
*  Notice: The author releases all rights to the public domain
*        : subject to the Warranty Disclaimer below.
*  Author: Tom Rettig
*        : Rettig Micro Corporation
*        : 2532 Lincoln Boulevard, Suite 110
*        : Marina del Rey, CA  90291-5978
*        :  Telephone: 310-301-0911
*        :        Fax: 310-821-1162
*        : CompuServe: 75066,352
*        :           : in FOXUSER forum's 3rd-Party section or MAIL
* Version: EnvLib Version 1.0 Beta 2b, April 7, 1995
* Created: December 10, 1994 (Beta 1)
*  Update: January 7, 1995 (Beta 1b)
*  Update: April 7, 1995 (Beta 2b)
*  Action: Save and restore SET, ON, and open table environments.
*   Usage: ///?See EnvDemo.prg for examples. ///make this a form?
*Requires: Visual FoxPro for Windows version 3.0 or later
*        : True.h named constant file (#included below)
*   Notes: - Will change as necessary for the VFP release version.
*        : - May be freely used, modified, and distributed in
*        : compiled and/or source code form.
*        : - The author appreciates acknowledgement in commercial
*        : products and publications that use or learn from this class.
*        : - Technical support is not officially provided.  The
*        : author is very interested in hearing about problems
*        : or enhancement requests you have, and will try to be
*        : helpful within reasonable limits.  Email or fax preferred.
*        : - Warranty Disclaimer: NO WARRANTY!!!
*        : THE AUTHOR RELEASES TO THE PUBLIC DOMAIN ALL CLAIMS TO ANY
*        : RIGHTS IN THIS PROGRAM AND FREELY PROVIDES IT AS IS WITHOUT
*        : WARRANTY OF ANY KIND, EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*        : LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*        : FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL THE AUTHOR, OR ANY
*        : OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THIS PROGRAM, BE
*        : LIABLE FOR ANY COMMERCIAL, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
*        : DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM
*        : INCLUDING, BUT NOT LIMITED TO, LOSS OF DATA OR DATA BEING
*        : RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR LOSSES
*        : SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE PROGRAM TO
*        : OPERATE WITH ANY OTHER PROGRAMS, EVEN IF YOU OR OTHER PARTIES
*        : HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

* Multiple set parameters are defined in True.h.
#INCLUDE "TRUE.h"


*************************************************************
* SET Parent Classes
*************************************************************

DEFINE CLASS Set AS Custom  && subclass only
   PROTECTED ruDefault,;
             ruOldSet,;
             ruNewSet,;
             rlNoReset

   FUNCTION GetOld
      RETURN THIS.ruOldSet
   ENDFUNC  && GetOld

   FUNCTION GetNew
      RETURN THIS.ruNewSet
   ENDFUNC  && GetNew

   FUNCTION GetDefault
      RETURN THIS.ruDefault
   ENDFUNC  && GetDefault

   PROTECTED PROCEDURE Init(tcSet, tuValue)
      THIS.ruOldSet = SET(tcSet)
      THIS.ruNewSet = NVL(tuValue, THIS.ruDefault)
   ENDPROC  && Init
ENDDEFINE  && CLASS Set AS Custom  && subclass only


DEFINE CLASS SetTwo AS Set   && subclass only
   PROTECTED ruDefaultTwo,;
             ruOldSetTwo,;
             ruNewSetTwo,;
             rcSet

   FUNCTION GetOldTwo
      RETURN THIS.ruOldSetTwo
   ENDFUNC  && GetOldTwo

   FUNCTION GetNewTwo
      RETURN THIS.ruNewSetTwo
   ENDFUNC  && GetNewTwo

   FUNCTION GetDefaultTwo
      RETURN THIS.ruDefaultTwo
   ENDFUNC  && GetDefaultTwo

   PROTECTED PROCEDURE Init(tcSet, tuValueOne,;
                            tuValueTwo, tnParams)
      DO CASE  && of which to set
         CASE EMPTY(tnParams)
            ERROR cnVF_ERR_PARAM_INVALID
            RETURN .F.  && early exit
         CASE tnParams == 1
            THIS.rcSet = ccSET_ONE
         CASE EMPTY(tuValueOne)  && never a valid value
            THIS.rcSet = ccSET_TWO
         OTHERWISE
            THIS.rcSet = ccSET_BOTH
      ENDCASE  && of which to set

      * Primary value as returned by SET("whatever").
      IF INLIST(THIS.rcSet, ccSET_ONE, ccSET_BOTH)
         =Set::Init(tcSet, tuValueOne)
      ENDIF

      * Secondary value as returned by SET("whatever", 1).
      IF INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
         THIS.ruOldSetTwo = SET(tcSet, 1)
         THIS.ruNewSetTwo = NVL(tuValueTwo, THIS.ruDefaultTwo)
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SetTwo AS Set   && subclass only


DEFINE CLASS SetOnOff AS Set   && subclass only
   PROTECTED PROCEDURE Init(tcSet, tcValue)
      DO CASE
         CASE ISNULL(tcValue)
            =Set::Init(tcSet, tcValue)
         CASE NOT INLIST(UPPER(ALLTRIM(tcValue)), "ON", "OFF")
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
         OTHERWISE
            =Set::Init(tcSet, UPPER(ALLTRIM(tcValue)))
      ENDCASE
   ENDPROC  && Init
ENDDEFINE  && CLASS SetOnOff AS Set  && subclass only


DEFINE CLASS SetOnOffTwo AS SetTwo   && subclass only
   PROTECTED PROCEDURE Init(tcSet,;
                            tcValueOne,;
                            tuValueTwo,;
                            tnParams)
      DO CASE
         CASE ISNULL(tcValueOne)
            =SetTwo::Init(tcSet,;
                          tcValueOne,;
                          tuValueTwo,;
                          tnParams)
         CASE NOT INLIST(UPPER(ALLTRIM(tcValueOne)), "ON", "OFF")
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
         OTHERWISE
            =SetTwo::Init(tcSet,;
                          UPPER(ALLTRIM(tcValueOne)),;
                          tuValueTwo,;
                          tnParams)
      ENDCASE
   ENDPROC  && Init
ENDDEFINE  && CLASS SetOnOffTwo AS SetTwo  && subclass only


*************************************************************
* SET Classes
*************************************************************

DEFINE CLASS SetAlternate AS SetOnOffTwo
   ruDefault    = "OFF"
   ruDefaultTwo = ""

   PROTECTED PROCEDURE Init(tcOnOff, tcTo, tcOption, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF

      DO CASE  && of primary set
         CASE NOT SetOnOffTwo::Init("ALTERNATE",;
                                    tcOnOff, tcTo,;
                                    PARAMETERS())
            RETURN .F.  && early exit
         CASE NOT INLIST(THIS.rcSet, ccSET_ONE, ccSET_BOTH)
            * Do nothing.
         CASE THIS.ruNewSet == "ON"
            SET ALTERNATE ON
         OTHERWISE
            SET ALTERNATE OFF
      ENDCASE  && of primary set

      DO CASE  && of secondary set
         CASE NOT INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
            * Do nothing.
         CASE EMPTY(THIS.ruNewSetTwo)
            SET ALTERNATE TO
         CASE (NOT EMPTY(tcOption)) AND;
              UPPER(ALLTRIM(tcOption)) == "ADDITIVE"
            SET ALTERNATE TO (THIS.ruNewSetTwo) ADDITIVE
         OTHERWISE
            SET ALTERNATE TO (THIS.ruNewSetTwo)
      ENDCASE  && of secondary set
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         DO CASE  && of primary set
            CASE NOT INLIST(THIS.rcSet, ccSET_ONE, ccSET_BOTH)
               * Do nothing.
            CASE THIS.ruOldSet == "ON"
               SET ALTERNATE ON
            OTHERWISE
               SET ALTERNATE OFF
         ENDCASE  && of primary set

         DO CASE  && of secondary set
            CASE NOT INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
               * Do nothing.
            CASE EMPTY(THIS.ruOldSetTwo)
               SET ALTERNATE TO
            OTHERWISE
               SET ALTERNATE TO (THIS.ruNewSetTwo)
         ENDCASE  && of secondary set
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetAlternate AS SetOnOffTwo


DEFINE CLASS SetClassLib AS Set
   ruDefault = ""

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      IF Set::Init("CLASSLIB", tcValue)
         LOCAL lcTemp
         lcTemp = THIS.ruNewSet
         SET CLASSLIB TO &lcTemp  && macro alert
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         LOCAL lcTemp
         lcTemp = THIS.ruOldSet
         SET CLASSLIB TO &lcTemp  && macro alert
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetClassLib AS Set


DEFINE CLASS SetCompatible AS SetOnOffTwo
   ruDefault    = "OFF"
   ruDefaultTwo = "PROMPT"

   PROTECTED PROCEDURE Init(tcOnOff, tcPrompt, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF

      LOCAL lcOnOff, lcPrompt
      lcOnOff  = IIF(ISNULL(tcOnOff), tcOnOff, UPPER(ALLTRIM(tcOnOff)))
      lcPrompt = IIF(ISNULL(tcPrompt), tcPrompt, UPPER(ALLTRIM(tcPrompt)))
      DO CASE
         CASE PARAMETERS() > 1 AND EMPTY(tcOnOff)
            lcOnOff = SET("COMPATIBLE")
         CASE lcOnOff == "FOXPLUS"
            lcOnOff = "OFF"
         CASE lcOnOff == "DB4"
            lcOnOff = "ON"
      ENDCASE

      DO CASE  && of primary set
         CASE NOT SetOnOffTwo::Init("COMPATIBLE",;
                                    lcOnOff, lcPrompt,;
                                    PARAMETERS())
            RETURN .F.  && early exit
         CASE NOT THIS.rcSet == ccSET_ONE
            * Do nothing.
         CASE THIS.ruNewSet == "ON"
            SET COMPATIBLE ON
         OTHERWISE
            SET COMPATIBLE OFF
      ENDCASE  && of primary set

      DO CASE  && of secondary set
         CASE NOT INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
            * Do nothing.
         CASE THIS.ruNewSetTwo == "PROMPT"
            IF THIS.ruNewSet == "ON"
               SET COMPATIBLE ON PROMPT
            ELSE
               SET COMPATIBLE OFF PROMPT
            ENDIF
         CASE THIS.ruNewSetTwo == "NOPROMPT"
            IF THIS.ruNewSet == "ON"
               SET COMPATIBLE ON NOPROMPT
            ELSE
               SET COMPATIBLE OFF NOPROMPT
            ENDIF
         OTHERWISE
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
      ENDCASE  && of secondary set
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         DO CASE  && of primary set
            CASE NOT THIS.rcSet == ccSET_ONE
               * Do nothing.
            CASE THIS.ruOldSet == "ON"
               SET COMPATIBLE ON
            OTHERWISE
               SET COMPATIBLE OFF
         ENDCASE  && of primary set

         DO CASE  && of secondary set
            CASE NOT INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
               * Do nothing.
            CASE THIS.ruOldSetTwo == "NOPROMPT"
               IF THIS.ruOldSet == "ON"
                  SET COMPATIBLE ON NOPROMPT
               ELSE
                  SET COMPATIBLE OFF NOPROMPT
               ENDIF
            OTHERWISE
               IF THIS.ruOldSet == "ON"
                  SET COMPATIBLE ON PROMPT
               ELSE
                  SET COMPATIBLE OFF PROMPT
               ENDIF
         ENDCASE  && of secondary set
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetCompatible AS SetOnOffTwo


DEFINE CLASS SetCurrency AS SetTwo
   ruDefault    = "LEFT"
   ruDefaultTwo = "$"

   PROTECTED PROCEDURE Init(tcLeftRight, tcTo, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF

      DO CASE  && of primary set
         CASE NOT SetTwo::Init("CURRENCY",;
                               IIF(ISNULL(tcLeftRight),;
                                   tcLeftRight,;
                                   UPPER(ALLTRIM(tcLeftRight))),;
                               tcTo,;
                               PARAMETERS())
         CASE NOT INLIST(THIS.rcSet, ccSET_ONE, ccSET_BOTH)
            * Do nothing.
         CASE NOT INLIST(THIS.ruNewSet, "LEFT", "RIGHT")
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "LEFT"
            SET CURRENCY LEFT
         OTHERWISE
            SET CURRENCY RIGHT
      ENDCASE  && of primary set

      * Secondary set.
      IF INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
         SET CURRENCY TO (THIS.ruNewSetTwo)
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         DO CASE  && of primary set
            CASE NOT INLIST(THIS.rcSet, ccSET_ONE, ccSET_BOTH)
               * Do nothing.
            CASE THIS.ruNewSet == "LEFT"
               SET CURRENCY LEFT
            OTHERWISE
               SET CURRENCY RIGHT
         ENDCASE  && of primary set

         * Secondary set.
         IF INLIST(THIS.rcSet, ccSET_TWO, ccSET_BOTH)
            SET CURRENCY TO (THIS.ruNewSetTwo)
         ENDIF
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetCurrency AS SetTwo


DEFINE CLASS SetDatabase AS Set
   ruDefault = ""

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT Set::Init("DATABASE", tcValue)
            RETURN .F.  && early exit
         CASE EMPTY(THIS.ruNewSet)
            SET DATABASE TO
         OTHERWISE
            SET DATABASE TO THIS.ruNewSet
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE EMPTY(THIS.ruOldSet)
            SET DATABASE TO
         OTHERWISE
            SET DATABASE TO THIS.ruOldSet
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetDatabase AS Set


DEFINE CLASS SetDataSession AS Set
   ruDefault = 1

   PROTECTED PROCEDURE Init(tnValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      IF Set::Init("DATASESSION", tnValue)
         IF NOT EMPTY(tnValue)
            SET DATASESSION TO THIS.ruNewSet
         ENDIF
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         SET DATASESSION TO THIS.ruOldSet
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetDataSession AS Set


DEFINE CLASS SetDecimals AS Set
   ruDefault = 2

   PROTECTED PROCEDURE Init(tnValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      IF Set::Init("DECIMALS", tnValue)
         SET DECIMALS TO THIS.ruNewSet
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         SET DECIMALS TO THIS.ruOldSet
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetDecimals AS Set


DEFINE CLASS SetDefault AS Set
   ruDefault = ""

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      IF Set::Init("DEFAULT", tcValue)
         SET DEFAULT TO (THIS.ruNewSet)
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         SET DEFAULT TO (THIS.ruOldSet)
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetDefault AS Set


DEFINE CLASS SetDeleted AS SetOnOff
   ruDefault = "OFF"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT SetOnOff::Init("DELETED", tcValue)
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "ON"
            SET DELETED ON
         OTHERWISE
            SET DELETED OFF
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "ON"
            SET DELETED ON
         OTHERWISE
            SET DELETED OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetDeleted AS SetOnOff


DEFINE CLASS SetExact AS SetOnOff
   ruDefault = "OFF"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT SetOnOff::Init("EXACT", tcValue)
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "ON"
            SET EXACT ON
         OTHERWISE
            SET EXACT OFF
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "ON"
            SET EXACT ON
         OTHERWISE
            SET EXACT OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetExact AS SetOnOff


DEFINE CLASS SetFullPath AS SetOnOff
   ruDefault = "ON"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT SetOnOff::Init("FULLPATH", tcValue)
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "ON"
            SET FULLPATH ON
         OTHERWISE
            SET FULLPATH OFF
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "ON"
            SET FULLPATH ON
         OTHERWISE
            SET FULLPATH OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetFullPath AS SetOnOff


DEFINE CLASS SetMemoWidth AS Set
   ruDefault = 50

   PROTECTED PROCEDURE Init(tnValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      * VFP sets a maximum of 256 when given a higher number.
      IF Set::Init("MEMOWIDTH", MIN(256, NVL(tnValue, THIS.ruDefault)))
         SET MEMOWIDTH TO THIS.ruNewSet
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         SET MEMOWIDTH TO THIS.ruOldSet
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetMemoWidth AS Set


DEFINE CLASS SetMultiLocks AS SetOnOff
   ruDefault = "OFF"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT SetOnOff::Init("MULTILOCKS", tcValue)
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "ON"
            SET MULTILOCKS ON
         OTHERWISE
            SET MULTILOCKS OFF
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "ON"
            SET MULTILOCKS ON
         OTHERWISE
            SET MULTILOCKS OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetMultiLocks AS SetOnOff


DEFINE CLASS SetProcedure AS Set
   ruDefault = ""

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      IF Set::Init("PROCEDURE", tcValue)
         IF EMPTY(THIS.ruNewSet)
            SET PROCEDURE TO
         ELSE
            LOCAL lcTemp
            lcTemp = THIS.ruNewSet
            SET PROCEDURE TO &lcTemp ADDITIVE  && macro alert
         ENDIF
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         LOCAL lcTemp
         lcTemp = THIS.ruOldSet
         SET PROCEDURE TO &lcTemp  && macro alert
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetProcedure AS Set


DEFINE CLASS SetReprocess AS Set
* If the old set is to <n> SECONDS, it will be reset as just <n>
* because DISPLAY STATUS is the only way in VFP to detect when set
* to SECONDS.

   ruDefault = 0

   PROTECTED rcType

   PROTECTED PROCEDURE Init(tuValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      THIS.rcType = TYPE("tuValue")
      DO CASE
         CASE ISNULL(tuValue)
            =Set::Init("REPROCESS", tuValue)
         CASE (NOT THIS.rcType $ "CN") OR;
              (NOT Set::Init("REPROCESS",;
                             IIF(THIS.rcType=="C",;
                                 UPPER(ALLTRIM(tuValue)),;
                                 tuValue)))
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
         CASE THIS.rcType == "C"
            DO CASE
               CASE THIS.ruNewSet == "AUTOMATIC"
                  SET REPROCESS TO AUTOMATIC
               CASE RIGHT(THIS.ruNewSet,7) == "SECONDS"
                  SET REPROCESS TO VAL(THIS.ruNewSet) SECONDS
               OTHERWISE
                  ERROR cnVF_ERR_SETARGINVALID
                  RETURN .F.  && early exit
            ENDCASE
         OTHERWISE
            SET REPROCESS TO THIS.ruNewSet
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF NOT THIS.rlNoReset
         SET REPROCESS TO THIS.ruOldSet
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetReprocess AS Set


DEFINE CLASS SetSafety AS SetOnOff
   ruDefault = "ON"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT SetOnOff::Init("SAFETY", tcValue)
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "ON"
            SET SAFETY ON
         OTHERWISE
            SET SAFETY OFF
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "ON"
            SET SAFETY ON
         OTHERWISE
            SET SAFETY OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetSafety AS SetOnOff


DEFINE CLASS SetSysMenu AS Set
* Handles only ON, OFF, and AUTOMATIC.  Does not handle SET TO.

   ruDefault = "AUTOMATIC"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE ISNULL(tcValue)
            =Set::Init("SYSMENU", tcValue)
         CASE NOT INLIST(UPPER(ALLTRIM(tcValue)),;
                         "ON", "OFF", "AUTOMATIC")
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
         OTHERWISE
            LOCAL lcValue
            lcValue = UPPER(ALLTRIM(tcValue))
            =Set::Init("SYSMENU", lcValue)
            DO CASE
               CASE lcValue == "AUTOMATIC"
                  SET SYSMENU AUTOMATIC
               CASE lcValue == "ON"
                  SET SYSMENU ON
               CASE lcValue == "OFF"
                  SET SYSMENU OFF
            ENDCASE
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "AUTOMATIC"
            SET SYSMENU AUTOMATIC
         CASE THIS.ruOldSet == "ON"
            SET SYSMENU ON
         CASE THIS.ruOldSet == "OFF"
            SET SYSMENU OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetSysMenu AS Set


DEFINE CLASS SetTalk AS SetOnOff
   ruDefault = "ON"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT SetOnOff::Init("TALK", tcValue)
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "ON"
            SET TALK ON
         OTHERWISE
            SET TALK OFF
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "ON"
            SET TALK ON
         OTHERWISE
            SET TALK OFF
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetTalk AS SetOnOff


DEFINE CLASS SetUdfParms AS Set
   ruDefault = "VALUE"

   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      DO CASE
         CASE NOT Set::Init("UDFPARMS",;
                            IIF(ISNULL(tcValue),;
                                tcValue, UPPER(ALLTRIM(tcValue))))
            RETURN .F.  && early exit
         CASE THIS.ruNewSet == "VALUE"
            SET UDFPARMS VALUE
         CASE THIS.ruNewSet == "REFERENCE"
            SET UDFPARMS REFERENCE
         OTHERWISE
            ERROR cnVF_ERR_SETARGINVALID
            RETURN .F.  && early exit
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE THIS.ruOldSet == "VALUE"
            SET UDFPARMS VALUE
         OTHERWISE
            SET UDFPARMS REFERENCE
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SetUdfParms AS Set


*************************************************************
* SET Default Classes
*************************************************************

DEFINE CLASS VfpDefaultSet AS Custom
* Visual FoxPro Defaults.
   PROTECTED PROCEDURE Init(tlNoReset)
      =THIS.AddObject("SetAlternate", "SetAlternate", .NULL., .NULL., tlNoReset)
      =THIS.AddObject("SetCompatible", "SetCompatible", .NULL., .NULL., tlNoReset)
      =THIS.AddObject("SetCurrency", "SetCurrency", .NULL., .NULL., tlNoReset)
      =THIS.AddObject("SetDatabase", "SetDatabase", .NULL., tlNoReset)
      =THIS.AddObject("SetDataSession", "SetDataSession", .NULL., tlNoReset)
      =THIS.AddObject("SetDecimals", "SetDecimals", .NULL., tlNoReset)
      =THIS.AddObject("SetDefault", "SetDefault", .NULL., tlNoReset)
      =THIS.AddObject("SetDeleted", "SetDeleted", .NULL., tlNoReset)
      =THIS.AddObject("SetExact", "SetExact", .NULL., tlNoReset)
      =THIS.AddObject("SetFullPath", "SetFullPath", .NULL., tlNoReset)
      =THIS.AddObject("SetMemowidth", "SetMemowidth", .NULL., tlNoReset)
      =THIS.AddObject("SetMultiLocks", "SetMultiLocks", .NULL., tlNoReset)
      =THIS.AddObject("SetProcedure", "SetProcedure", .NULL., tlNoReset)
      =THIS.AddObject("SetReprocess", "SetReprocess", .NULL., tlNoReset)
      =THIS.AddObject("SetSafety", "SetSafety", .NULL., tlNoReset)
      =THIS.AddObject("SetSysMenu", "SetSysMenu", .NULL., tlNoReset)
      =THIS.AddObject("SetTalk", "SetTalk", .NULL., tlNoReset)
      =THIS.AddObject("SetUdfParms", "SetUdfParms", .NULL., tlNoReset)
      * Must be last if this is a VCX.  ///could be smarter and keep
      * itself in memory or ignore this if we're a VCX.
      =THIS.AddObject("SetClassLib", "SetClassLib", .NULL., tlNoReset)
      *///?RETURN .F.
   ENDPROC  && Init
ENDDEFINE  && CLASS VfpDefaultSet AS Custom


*************************************************************
* ON Parent Classes
*************************************************************

DEFINE CLASS On AS Custom  && subclass only
   PROTECTED rcOldOn,;
             rcNewOn,;
             rlNoReset

   FUNCTION GetOld
      RETURN THIS.rcOldOn
   ENDFUNC  && GetOld

   FUNCTION GetNew
      RETURN THIS.rcNewOn
   ENDFUNC  && GetNew

   PROTECTED PROCEDURE Init(tcOn, tcValue)
      THIS.ruOldOn = ON(tcOn)
      THIS.ruNewOn = NVL(tcValue, "")
   ENDPROC  && Init
ENDDEFINE  && CLASS On AS Custom  && subclass only


*************************************************************
* ON Classes
*************************************************************

DEFINE CLASS OnError AS On
   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      =On::Init("ERROR", tcValue)
      IF EMPTY(THIS.ruNewOn)
         ON ERROR
      ELSE
         LOCAL lcError
         lcError = THIS.rcNewOn
         ON ERROR &lcError  && macro alert
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE EMPTY(THIS.ruNewOn)
            ON ERROR
         OTHERWISE
            LOCAL lcError
            lcError = THIS.rcNewOn
            ON ERROR &lcError  && macro alert
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS OnError AS On


DEFINE CLASS OnKey AS On
   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      =On::Init("KEY", tcValue)
      IF EMPTY(THIS.ruNewOn)
         ON KEY
      ELSE
         LOCAL lcKey
         lcKey = THIS.rcNewOn
         ON KEY &lcKey  && macro alert
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE EMPTY(THIS.ruOldOn)
            ON KEY
         OTHERWISE
            LOCAL lcKey
            lcKey = THIS.rcOldOn
            ON KEY &lcKey  && macro alert
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS OnKey AS On


DEFINE CLASS OnKeyLabel AS On
   PROTECTED rcLabel

   FUNCTION GetLabel
      RETURN THIS.rcLabel
   ENDFUNC  && GetLabel

   PROTECTED PROCEDURE Init(tcLabel, tcValue, tlNoReset)
   * Override parent class.
      THIS.rcLabel = tcLabel
      THIS.ruOldOn = ON("KEY", tcLabel)
      THIS.ruNewOn = NVL(tcValue, "")
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      IF EMPTY(THIS.ruNewOn)
         ON KEY LABEL (THIS.rcLabel)
      ELSE
         LOCAL lcKey
         lcKey = THIS.rcNewOn
         ON KEY LABEL (THIS.rcLabel) &lcKey  && macro alert
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE EMPTY(THIS.ruOldOn)
            ON KEY LABEL (THIS.rcLabel)
         OTHERWISE
            LOCAL lcKey
            lcKey = THIS.rcOldOn
            ON KEY LABEL (THIS.rcLabel) &lcKey  && macro alert
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS OnKeyLabel AS On


DEFINE CLASS OnShutDown AS On
   PROTECTED PROCEDURE Init(tcValue, tlNoReset)
      IF tlNoReset
         THIS.rlNoReset = .T.
      ENDIF
      =On::Init("SHUTDOWN", tcValue)
      IF EMPTY(THIS.ruNewOn)
         ON SHUTDOWN
      ELSE
         LOCAL lcShutDown
         lcShutDown = THIS.rcNewOn
         ON SHUTDOWN &lcShutDown  && macro alert
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE THIS.rlNoReset
            * Do nothing.
         CASE EMPTY(THIS.ruNewOn)
            ON SHUTDOWN
         OTHERWISE
            LOCAL lcShutDown
            lcShutDown = THIS.rcNewOn
            ON SHUTDOWN &lcShutDown  && macro alert
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS OnShutDown AS On


*************************************************************
* Save/Restore Parent Classes
*************************************************************

DEFINE CLASS SaveArea AS Custom  && subclass only
   PROTECTED rnSelect

   FUNCTION GetSelect
      RETURN THIS.rnSelect
   ENDFUNC  && GetSelect

   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      DO CASE
         CASE EMPTY(tuArea) OR ISNULL(tuArea)
            THIS.rnSelect = SELECT(0)
         CASE TYPE("tuArea") == "N"
            THIS.rnSelect = MAX(0, tuArea)
         OTHERWISE  && assumes character or error will prevent init
            THIS.rnSelect = SELECT(tuArea)
      ENDCASE
      IF EMPTY(THIS.rnSelect)
         ERROR cnVF_ERR_TABLE_NUMINVALID
         RETURN .F.
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SaveArea AS Custom  && subclass only


DEFINE CLASS SaveUsedArea AS SaveArea  && subclass only
   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      DO CASE
         CASE NOT SaveArea::Init(tuArea)
            RETURN .F.  && early exit
         CASE NOT USED(THIS.rnSelect)
            ERROR cnVF_ERR_TABLE_NOTOPEN
            RETURN .F.  && early exit
      ENDCASE
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      RETURN USED(THIS.rnSelect)
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveUsedArea AS SaveArea  && subclass only


*************************************************************
* Save/Restore Classes
*************************************************************

DEFINE CLASS SaveSelect AS SaveArea
   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      RETURN SaveArea::Init(tuArea)
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      SELECT (THIS.rnSelect)
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveSelect AS SaveArea


DEFINE CLASS SetSelect AS SaveSelect
   PROTECTED PROCEDURE Init(tuNewArea)  && character or numeric
      IF SaveSelect::Init()  && current area
         SELECT (tuNewArea)
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SetSelect AS SaveSelect


DEFINE CLASS SaveBuffering AS SaveUsedArea
   PROTECTED rnBuffering

   FUNCTION GetOld
      RETURN THIS.rnBuffering
   ENDFUNC  && GetOld

   PROTECTED PROCEDURE Init(tuArea)
      IF SaveUsedArea::Init(tuArea)
         THIS.rnBuffering = CURSORGETPROP("Buffering", THIS.rnSelect)
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF SaveUsedArea::Destroy()
         =CURSORSETPROP("Buffering", THIS.rnBuffering, THIS.rnSelect)
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveBuffering AS SaveUsedArea


DEFINE CLASS SetBuffering AS SaveBuffering
   PROTECTED rnDefault
   rnDefault = 1

   PROTECTED PROCEDURE GetDefault
      RETURN THIS.rnDefault
   ENDPROC  && GetDefault

   PROTECTED PROCEDURE Init(tnBuffering, tuNewArea)
      IF SaveBuffering::Init(tuNewArea)
         =CURSORSETPROP("Buffering",;
                        NVL(tnBuffering, THIS.rnDefault),;
                        THIS.rnSelect)
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SetBuffering AS SaveBuffering


DEFINE CLASS SaveRecno AS SaveUsedArea
   PROTECTED rnRecno

   FUNCTION GetOld
      RETURN THIS.rnRecno
   ENDFUNC  && GetOld

   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      IF SaveUsedArea::Init(tuArea)
         THIS.rnRecno = IIF(EOF(THIS.rnSelect),;
                            .NULL., RECNO(THIS.rnSelect))
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE NOT SaveUsedArea::Destroy()
            * Do nothing.
         CASE ISNULL(THIS.rnRecno)  && EOF()
            =THIS.AddObject("SetSelect", "SetSelect", THIS.rnSelect)
            LOCATE FOR .F.  && EOF()
         CASE THIS.rnRecno <= RECCOUNT(THIS.rnSelect)
            GO THIS.rnRecno IN (THIS.rnSelect)
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveRecno AS SaveUsedArea


DEFINE CLASS SaveRecnoDeleted AS SaveRecno
* Should have index tag on DELETED().
   PROTECTED PROCEDURE Destroy
      IF SaveRecno::Destroy() AND DELETED(THIS.rnSelect)
         =THIS.AddObject("SetSelect", "SetSelect", THIS.rnSelect)
         LOCATE FOR NOT DELETED()
         IF NOT FOUND()
            GO THIS.rnRecno
         ENDIF
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveRecnoDeleted AS SaveRecno


DEFINE CLASS SaveRecnoFiltered AS SaveRecno
* Should have index tags on filter expression elements.
   PROTECTED PROCEDURE Destroy
      IF SaveRecno::Destroy() AND;
            NOT (EMPTY(FILTER(THIS.rnSelect)) OR;
                 EVALUATE(FILTER(THIS.rnSelect)))
         =THIS.AddObject("SetSelect", "SetSelect", THIS.rnSelect)
         LOCATE
         IF NOT FOUND()
            GO THIS.rnRecno
         ENDIF
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveRecnoFiltered AS SaveRecno

*///here
DEFINE CLASS SaveRecnoValid AS SaveRecnoFiltered
* Should have index tags on filter expression elements.
   PROTECTED PROCEDURE Destroy
      =THIS.AddObject("SetDeleted", "SetDeleted", "ON")
      =SaveRecnoFiltered::Destroy()
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveRecnoValid AS SaveRecnoFiltered


DEFINE CLASS SaveOrder AS SaveUsedArea
* Only handles CDX tags, not individual IDX.
   PROTECTED rcOrder, rlDescending

   FUNCTION GetOld
      RETURN THIS.rcOrder
   ENDFUNC  && GetOld

   FUNCTION GetDescending
      RETURN THIS.rlDescending
   ENDFUNC  && GetDescending

   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      IF SaveUsedArea::Init(tuArea)
         LOCAL lnSelect
         lnSelect          = THIS.rnSelect
         THIS.rcOrder      = ORDER(lnSelect)
         IF NOT EMPTY(THIS.rcOrder)
            THIS.rlDescending = DESCENDING(TAGNO(ORDER(lnSelect),;
                                                 CDX(1, lnSelect),;
                                                 lnSelect),;
                                           lnSelect)
         ENDIF
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      DO CASE
         CASE NOT SaveUsedArea::Destroy()
            * Do nothing.
         CASE EMPTY(THIS.rcOrder)
            SET ORDER TO 0 IN (THIS.rnSelect)
         CASE THIS.rlDescending
            SET ORDER TO (THIS.rcOrder) IN (THIS.rnSelect);
                         DESCENDING
         OTHERWISE
            SET ORDER TO (THIS.rcOrder) IN (THIS.rnSelect);
                         ASCENDING
      ENDCASE
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveOrder AS SaveUsedArea


DEFINE CLASS SetOrder AS SaveOrder
   PROTECTED PROCEDURE Init(tuOrder, tuNewArea, tlDescending)
      DO CASE
         CASE NOT SaveOrder::Init(tuNewArea)
            RETURN .F.  && early exit
         CASE EMPTY(tuOrder) OR ISNULL(tuOrder)
            SET ORDER TO 0 IN (THIS.rnSelect)
         CASE tlDescending
            SET ORDER TO (tuOrder) IN (THIS.rnSelect);
                         DESCENDING
         OTHERWISE
            SET ORDER TO (tuOrder) IN (THIS.rnSelect)
      ENDCASE
   ENDPROC  && Init
ENDDEFINE  && CLASS SetOrder AS SaveOrder


DEFINE CLASS SaveFilter AS SaveUsedArea
   PROTECTED rcFilter

   FUNCTION GetOld
      RETURN THIS.rcFilter
   ENDFUNC  && GetOld

   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      IF SaveUsedArea::Init(tuArea)
         THIS.rcFilter = FILTER(THIS.rnSelect)
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF SaveUsedArea::Destroy()
         =THIS.AddObject("SetSelect", "SetSelect", THIS.rnSelect)
         IF EMPTY(THIS.rcFilter)
            SET FILTER TO
         ELSE
            LOCAL lcFilter
            lcFilter = THIS.rcFilter
            SET FILTER TO &lcFilter  && macro alert
         ENDIF
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveFilter AS SaveUsedArea


DEFINE CLASS SetFilter AS SaveFilter
   PROTECTED PROCEDURE Init(tcFilter, tuNewArea, tcAdditive)
   * tcAdditive ::= "AND" | "OR"
      IF SaveFilter::Init(tuNewArea)
         LOCAL loSelect
         loSelect = CREATEOBJECT("SetSelect", THIS.rnSelect)
         DO CASE
            CASE EMPTY(tcFilter) OR ISNULL(tcFilter)
               SET FILTER TO
            CASE EMPTY(tcAdditive)
               SET FILTER TO &tcFilter  && macro alert
            OTHERWISE
               LOCAL lcFilter
               lcFilter = "(" + FILTER() + ") " + tcAdditive+;
                          " (" + tcFilter + ")"
               SET FILTER TO &lcFilter  && macro alert
         ENDCASE
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SetFilter AS SaveFilter


DEFINE CLASS SaveRelation AS SaveUsedArea
* Also handles SET SKIP.
   PROTECTED rcRelation,;
             rcSkip

   FUNCTION GetOld
      RETURN THIS.rcRelation
   ENDFUNC  && GetOld

   PROTECTED PROCEDURE Init(tuArea)  && character or numeric
      IF SaveUsedArea::Init(tuArea)
         LOCAL loSelect
         loSelect = CREATEOBJECT("SetSelect", THIS.rnSelect)
         THIS.rcRelation = SET("RELATION")
         THIS.rcSkip     = SET("SKIP")
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
      IF SaveUsedArea::Destroy()
         LOCAL loSelect
         loSelect = CREATEOBJECT("SetSelect", THIS.rnSelect)
         IF EMPTY(THIS.rcRelation)
            SET RELATION TO
         ELSE
            LOCAL lcTemp
            lcTemp = THIS.rcRelation
            SET RELATION TO &lcTemp  && macro alert
            IF NOT EMPTY(THIS.rcSkip)
               lcTemp = THIS.rcSkip
               SET SKIP TO &lcTemp   && macro alert
            ENDIF
         ENDIF
      ENDIF
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveRelation AS SaveUsedArea


DEFINE CLASS SetRelation AS SaveRelation
   PROTECTED PROCEDURE Init(tcRelation, tuNewArea)
      IF SaveRelation::Init(tuNewArea)
         LOCAL loSelect
         loSelect = CREATEOBJECT("SetSelect", THIS.rnSelect)
         IF EMPTY(tcRelation) OR ISNULL(tcRelation)
            SET RELATION TO
         ELSE
            SET RELATION TO &tcRelation  && macro alert
         ENDIF
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SetRelation AS SaveRelation


DEFINE CLASS SaveTable AS SaveUsedArea
   PROTECTED rcAlias,;
             rcFile,;
             rcLock

   PROTECTED PROCEDURE Init(tuArea, tlNoDependencies)
      IF SaveUsedArea::Init(tuArea)
         LOCAL loFullPath, loSelect
         loSelect   = CREATEOBJECT("SetSelect", THIS.rnSelect)
         loFullPath = CREATEOBJECT("SetFullPath", "ON")
         =THIS.AddObject("SaveBuffering", "SaveBuffering")
         =THIS.AddObject("SaveRecno", "SaveRecno")
         =THIS.AddObject("SetDataSession", "SetDataSession")
         IF NOT tlNoDependencies
            * Order and filter could have references to other tables.
            =THIS.AddObject("SaveOrder", "SaveOrder")
            =THIS.AddObject("SaveFilter", "SaveFilter")
            =THIS.AddObject("SaveRelation", "SaveRelation")
         ENDIF
         THIS.rcAlias = ALIAS()
         THIS.rcFile  = DBF()
         THIS.rcLock  = SYS(2011)  &&///#define
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init

   PROTECTED PROCEDURE Destroy
   * Override parent class which checks for an open table.
      LOCAL loSelect
      loSelect = CREATEOBJECT("SetSelect", THIS.rnSelect)
      IF NOT ALIAS() == THIS.rcAlias
         =THIS.RemoveObject("SetDataSession", "SetDataSession")
         IF USED(THIS.rcAlias)  && close if open in another area
            USE IN (THIS.rcAlias)
         ENDIF
         IF THIS.rcLock == "Exclusive"
            USE (THIS.rcFile) ALIAS (THIS.rcAlias) AGAIN EXCLUSIVE
         ELSE
            USE (THIS.rcFile) ALIAS (THIS.rcAlias) AGAIN SHARED
            DO CASE
               CASE THIS.rcLock == "File Locked"
                  =FLOCK()
               CASE THIS.rcLock == "Record Locked"
                  =THIS.RemoveObject("SaveRecno", "SaveRecno")
                  =RLOCK()
               OTHERWISE  && should never happen
                  *ERROR ///
            ENDCASE
         ENDIF
      ENDIF  && NOT ALIAS() == THIS.rcAlias
   ENDPROC  && Destroy
ENDDEFINE  && CLASS SaveTable AS SaveUsedArea


DEFINE CLASS SaveAllTables AS Custom
   ADD OBJECT PROTECTED SaveSelect AS SaveSelect

   PROTECTED PROCEDURE Init
      LOCAL lnCounter, laUsed[1]
      IF AUSED(laUsed) > 0
         * AUSED sorts from most recently opened to least recently opened.
         * Destruction is reversed; first constructed are last destructed,
         * so save the dependencies before the tables so all tables are
         * open when any potential dependencies are restored.
         FOR lnCounter = 1 TO ALEN(laUsed, 1)
            =THIS.AddObject("SaveRel" + LTRIM(STR(lnCounter)),;
                            "SaveRelation",;
                            laUsed[lnCounter, 2])
            =THIS.AddObject("SaveFil" + LTRIM(STR(lnCounter)),;
                            "SaveFilter",;
                            laUsed[lnCounter, 2])
         ENDFOR
         * Relations are dependent on order.
         FOR lnCounter = 1 TO ALEN(laUsed, 1)
            =THIS.AddObject("SaveOrd" + LTRIM(STR(lnCounter)),;
                            "SaveOrder",;
                            laUsed[lnCounter, 2])
         ENDFOR
         * All dependencies are dependent on tables.
         FOR lnCounter = 1 TO ALEN(laUsed, 1)
            =THIS.AddObject("SaveTab" + LTRIM(STR(lnCounter)),;
                            "SaveTable",;
                            laUsed[lnCounter, 2],;
                            .T.)  && tables will be restored first
         ENDFOR
      ELSE
         RETURN .F.
      ENDIF
   ENDPROC  && Init
ENDDEFINE  && CLASS SaveAllTables AS Custom

*** EnvLib.prg **********************************************
#if .f.
Doc:
- Pass .NULL. to set default value.
- Based on a beta forum Tip Of The Day by Drew Speedie.

Notes:
- Mac: Cmd+Option+click = ON KEY LABEL RIGHTMOUSE, use for Enter in Browse

*///ER: Ignore [] in param parser so we can identify optional params.

oO = CREATEOBJECT("///", /// [, ///])
oO = CREATEOBJECT("SetExact", "On")
oO = CREATEOBJECT("SetMemoWidth", 100)
oO = CREATEOBJECT("SetAlternate", "On")
oO = CREATEOBJECT("SetAlternate", "On")
oO = CREATEOBJECT("SetAlternate", , "TestAlt")  &&///beta 3

* Test ON/OFF.
t1 = SECONDS()
oO = CREATEOBJECT("SetExact", "On no")
RELEASE oO
t2 = SECONDS()

t3 = SECONDS()
LOCAL lcSetOn
lcSetOn = SET("EXACT")
SET EXACT ON
SET EXACT &lcSetOn
t4 = SECONDS()

* Test ON/OFF with TO.
SET SAFETY OFF
t1 = SECONDS()
oO = CREATEOBJECT("SetAlternate", "On", "temp.tmp")
RELEASE oO
t2 = SECONDS()

t3 = SECONDS()
LOCAL lcSetOn, lcSetTo
lcSetOn = SET("ALTERNATE")
lcSetTo = SET("ALTERNATE",1)
SET ALTERNATE TO temp.txt
SET ALTERNATE ON
SET ALTERNATE TO &lcSetTo
SET ALTERNATE &lcSetOn
t4 = SECONDS()
SET SAFETY ON

* Test memowidth.
t1 = SECONDS()
oO = CREATEOBJECT("SetMemowidth", 123)
RELEASE oO
t2 = SECONDS()

t3 = SECONDS()
LOCAL lnSetTo
lnSetTo = SET("MEMOWIDTH")
SET MEMOWIDTH TO lnSetTo
t4 = SECONDS()

* Test set alternate.
t1 = SECONDS()
oO = CREATEOBJECT("SetAlternate", "On", "TestAlt")
RELEASE oO
t2 = SECONDS()

t3 = SECONDS()
t4 = SECONDS()

?
? "object", t2-t1
? "code  ", t4-t3
#endif


