* Program: EdcLib.prg
* Classes: EDC (Extended Database Container)
*        : Message (wrapper for MESSAGEBOX())
*   Bases: All based on Custom
*  Notice: The author releases all rights to the public domain
*        : subject to the Warranty Disclaimer below.
*  Author: Tom Rettig
*        : Rettig Micro Corporation
*        : 2532 Lincoln Boulevard, Suite 110
*        : Marina del Rey, CA  90291-5978
*        :  Telephone: 310-301-0911
*        :        Fax: 310-821-1162
*        : CompuServe: 75066,352
*        :           : in FOXUSER forum's 3rd-Party section or MAIL
* Version: EDC Version 1.0 Beta 2b, April 7, 1995 (#defined in True.h)
* Created: December 10, 1994 (Beta 1)
*  Update: January 7, 1995 (Beta 1b)
*  Update: April 7, 1995 (Beta 2b)
*  Action: Store user-defined properties at any VFP logical view
*        :    like database containers (.DBC files).
*   Usage: See EdcDemo.prg for examples. ///make this a form?
*Requires: Visual FoxPro for Windows version 3.0 or later
*        : True.h named constant file (#included below)
*   Notes: - Will change as necessary for the VFP release version.
*        : - May be freely used, modified, and distributed in
*        : compiled and/or source code form.
*        : - The author appreciates acknowledgement in commercial
*        : products and publications that use or learn from this class.
*        : - Technical support is not officially provided.  The
*        : author is very interested in hearing about problems
*        : or enhancement requests you have, and will try to be
*        : helpful within reasonable limits.  Email or fax preferred.
*        : - Warranty Disclaimer: NO WARRANTY!!!
*        : THE AUTHOR RELEASES TO THE PUBLIC DOMAIN ALL CLAIMS TO ANY
*        : RIGHTS IN THIS PROGRAM AND FREELY PROVIDES IT AS IS WITHOUT
*        : WARRANTY OF ANY KIND, EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*        : LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*        : FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL THE AUTHOR, OR ANY
*        : OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THIS PROGRAM, BE
*        : LIABLE FOR ANY COMMERCIAL, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
*        : DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM
*        : INCLUDING, BUT NOT LIMITED TO, LOSS OF DATA OR DATA BEING
*        : RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR LOSSES
*        : SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE PROGRAM TO
*        : OPERATE WITH ANY OTHER PROGRAMS, EVEN IF YOU OR OTHER PARTIES
*        : HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

* Include our header file (which also includes FoxPro.h ///VFP.h?).
#INCLUDE "TRUE.h"

*************************************************************
* Class definitions
*************************************************************

DEFINE CLASS cxCLASS_EDC AS Custom

   **********************************************************
   * Class Objects
   **********************************************************

   * Message handler.  Separate class defined below.
   ADD OBJECT PROTECTED Message AS Message


   **********************************************************
   * Exposed Properties
   * - Are set on event or method execution.
   * - Changing their value does not affect our methods.
   **********************************************************

   * Property header.
   * Set to the extended property's header by uGetProp()
   *    and uSetProp() methods.
   * Not reset on errors or not found.
   cPropHead = ""

   * Set by AERROR() in Error event.  Adds three elements
   * for the method name, line number, and source code line.
   DECLARE aObjectError[cnAERR_MAX]

   * Performance testing.
   * If rlExecTime is true, many exposed methods' execution
   *    time is stored here in elapsed seconds.
   * To change the value of rlExecTime, use the method lSetExecTime().
   * Not reset on errors or not found.
   nExecTime = 0


   **********************************************************
   * Exposed Methods
   **********************************************************

   FUNCTION lOpen(tcEdcField, tcFreeEdc)
   * Action: Open the EDC table, and optionally the associated DBC.
   * Return: True if successful, otherwise false.
   * Update: Version 1.0
   *  Notes: Prompts to create the EDC if it doesn't exist.
   *       : Prompts to add the extended field to the EDC
   *       :    if it doesn't exist.
   *       : To open more than once, instantiate another object
   *       :    from this class.
   *       : tcFreeEdc is optional.  Pass the free EDC table name
   *       :    (path optional) to open without an attached DBC.

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL llChildObject,;
            lnCounter,;
            lnCounter2,;
            lcEdcAlias,;
            lcEdcField,;
            llEdcFree,;
            lcFullPath,;
            llFullPath,;
            laMethods[1],;
            lcMethodClass,;
            lcMethodClassLib,;
            lcMethodInit,;
            loMethodObject,;
            lcMethodOpen,;
            lcMethodGet,;
            lcMethodSet,;
            lcRelativePath,;
            llReleaseClass,;
            llReturn
            
      llFullPath = SET("FULLPATH")=="ON"

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tcEdcField) OR EMPTY(tcEdcField) OR;
              NOT TYPE("tcEdcField")=="C"
            ERROR cnVF_ERR_PARAM_INVALID
         CASE PARAMETERS() == 2 AND;
              (ISNULL(tcFreeEdc) OR EMPTY(tcFreeEdc) OR;
               NOT TYPE("tcFreeEdc")=="C")
            ERROR cnVF_ERR_PARAM_INVALID
         CASE LEN(ALLTRIM(tcEdcField)) > cnVF_FIELD_MAXNAMELEN
            ERROR THIS.rcErrorFieldNameLen
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE PARAMETERS() == 2
            lcRelativePath = ALLTRIM(tcFreeEdc)
            * Add extension if none is passed.
            IF NOT ("." $ lcRelativePath AND;
                    LEN(lcRelativePath) -;
                       RAT(".", lcRelativePath) < 4)  && max extension size 3
               lcRelativePath = lcRelativePath + "." + rcEdcFileExt
            ENDIF
            THIS.rcEdcFullPath = lcRelativePath
            llEdcFree = .T.
         CASE ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
            lcRelativePath = THIS.cOpenDbc()
            IF NOT EMPTY(lcRelativePath)
               THIS.rcEdcFullPath = LEFT(lcRelativePath,;
                                         RAT(".", lcRelativePath))+;
                                    THIS.rcEdcFileExt
            ENDIF
         OTHERWISE
            *///=THIS.Close() instead of error???
            ERROR cnVF_ERR_DB_ISOPEN
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         RETURN llReturn  && early exit
      ENDIF

      * Open or create main registry EDC.
      llReturn = THIS.lOpenEdc(tcEdcField)

      IF llReturn
         * Set a true full path if tcFreeEdc was passed.
         IF llEdcFree
            SET FULLPATH ON
            THIS.rcEdcFullPath = DBF(THIS.rcEdcAlias)
            IF NOT llFullPath
               SET FULLPATH OFF
            ENDIF
         ELSE  && set the bound DBC
            THIS.rcBoundAlias    = THIS.rcDbcAlias
            THIS.rcBoundFullPath = THIS.rcDbcFullPath
         ENDIF

         * This main EDC is also the EDC registry.
         THIS.rcRegFullPath = THIS.rcEdcFullPath
         THIS.rcRegAlias    = THIS.rcEdcAlias

         * Save current EDC for opening alternates.
         lcEdcAlias = THIS.rcEdcAlias
         lcEdcField = THIS.rcEdcField
         lcFullPath = THIS.rcEdcFullPath

         * Open alternate method objects.
         llChildObject = TYPE("THIS.PARENT") == "O"
         THIS.rcEdcAlias = THIS.rcRegAlias
         FOR lnCounter = cnEDC_FIXEDFIELDS+1 TO FCOUNT(THIS.rcRegAlias)

            THIS.aObjectError[cnVF_AERR_NUMBER] = 0
            THIS.rcEdcField = FIELD(lnCounter, THIS.rcRegAlias)

            * Check for alternate class methods used.
            IF THIS.uGetProp(ccEDC_OBJ_REGISTRY,;
                             ccEDC_OBJ_UNIQUETYPE,;
                             ccEDC_REG_METHODALL,;
                             @laMethods) > 0               
               IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
                  LOOP
               ENDIF
               FOR lnCounter2 = 1 TO ALEN(laMethods, 1)
                  lcMethod = LOWER(laMethods[lnCounter2, 1])
                  DO CASE
                     CASE lcMethod == LOWER(ccEDC_REG_METHODLIB)
                        IF EMPTY(laMethods[lnCounter2, 2])
                           EXIT
                        ELSE
                           lcMethodLib = LOWER(laMethods[lnCounter2, 2])
                           * Add extension if none is passed.
                           IF NOT ("." $ lcMethodLib AND;
                                   LEN(lcMethodLib) -;
                                   RAT(".", lcMethodLib) < 4)  && max extension size 3
                              * Default to visual class library.
                              lcMethodLib = lcMethodLib + ".vcx"
                           ENDIF
                        ENDIF
                     CASE lcMethod == LOWER(ccEDC_REG_METHODCLASS)
                        IF EMPTY(laMethods[lnCounter2, 2])
                           EXIT
                        ELSE
                           lcMethodClass = laMethods[lnCounter2, 2]
                        ENDIF
                     CASE lcMethod == LOWER(ccEDC_REG_METHODGET)
                        lcMethodGet = laMethods[lnCounter2, 2]
                     CASE lcMethod == LOWER(ccEDC_REG_METHODSET)
                        lcMethodSet = laMethods[lnCounter2, 2]
                     CASE lcMethod == LOWER(ccEDC_REG_METHODOPEN)
                        lcMethodOpen = laMethods[lnCounter2, 2]
                     CASE lcMethod == LOWER(ccEDC_REG_METHODINIT)
                        lcMethodInit = laMethods[lnCounter2, 2]
                  ENDCASE
               ENDFOR  && method properties
               IF lnCounter2 <= ALEN(laMethods, 1) OR;
                     (EMPTY(lcMethodGet) AND EMPTY(lcMethodSet))
                  LOOP
               ENDIF

               SET FULLPATH ON
               IF llChildObject AND;
                     (lcMethodLib == THIS.PARENT.ClassLibrary OR;
                      lcMethodLib == SUBSTR(THIS.PARENT.ClassLibrary,;
                                        RAT("\",;
                                            THIS.PARENT.ClassLibrary)+1))
                  loMethodObject = THIS.PARENT
               ELSE
                  IF RIGHT(lcMethodLib, 4) == ".vcx"
                     lcRelativePath = SET("CLASSLIB")
                     SET CLASSLIB TO (lcMethodLib) ADDITIVE
                     llReleaseClass = NOT lcRelativePath == SET("CLASSLIB")
                  ELSE  && program
                     lcRelativePath = SET("PROCEDURE")
                     SET PROCEDURE TO (lcMethodLib) ADDITIVE
                     llReleaseClass = NOT lcRelativePath == SET("PROCEDURE")
                  ENDIF
                  IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
                     LOOP
                  ENDIF

                  IF EMPTY(lcMethodInit)
                     =THIS.AddObject(FIELD(lnCounter, THIS.rcRegAlias),;
                                     lcMethodClass)
                  ELSE
                     =THIS.AddObject(FIELD(lnCounter, THIS.rcRegAlias),;
                                     lcMethodClass,;
                                     THIS.cSetArg(lcMethodInit,;
                                          IIF(ISNULL(THIS.rcDbcFullPath),;
                                              "", THIS.rcDbcFullPath+"!")))
                  ENDIF

                  IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
                     loMethodObject =;
                        EVALUATE("THIS."+FIELD(lnCounter, THIS.rcRegAlias))
                  ELSE
                     LOOP
                  ENDIF
               ENDIF  && setting object

               IF NOT EMPTY(lcMethodOpen)
                  lcMethodOpen = THIS.cSetArg(lcMethodOpen,;
                                      IIF(ISNULL(THIS.rcDbcFullPath),;
                                          "", THIS.rcDbcFullPath+"!"))
                  =loMethodObject.&lcMethodOpen
                  * Can't error check because our error handler doesn't
                  * fire if an error occurs in another object.
               ENDIF

               * Add a row to raObject if necessary.
               IF NOT ISNULL(THIS.raObject[1])
                  DIMENSION THIS.raObject[ALEN(THIS.raObject, 1)+1,;
                                          ALEN(THIS.raObject, 2)   ]
               ENDIF

               THIS.raObject[ALEN(THIS.raObject, 1), cnOBJ_OWNER] =;
                  ccMSG_INSERT1 + FIELD(lnCounter, THIS.rcRegAlias) +;
                  ccMSG_INSERT1  && to insure uniqueness for ASCAN()
               THIS.raObject[ALEN(THIS.raObject, 1), cnOBJ_OBJECT] =;
                  loMethodObject
               THIS.raObject[ALEN(THIS.raObject, 1), cnOBJ_RELEASE] =;
                  IIF(llReleaseClass, lcMethodLib, "")
               THIS.raObject[ALEN(THIS.raObject, 1), cnOBJ_GETMETHOD] =;
                  lcMethodGet
               THIS.raObject[ALEN(THIS.raObject, 1), cnOBJ_SETMETHOD] =;
                  lcMethodSet
            ENDIF  && THIS.uGetProp()
         ENDFOR  && open alternate methods

         * Open alternate EDCs.
         FOR lnCounter = cnEDC_FIXEDFIELDS+1 TO FCOUNT(THIS.rcRegAlias)
            * Open alternate EDCs.  Fullpath shouldn't matter.
            THIS.rcEdcAlias = THIS.rcRegAlias
            THIS.rcEdcField = FIELD(lnCounter, THIS.rcRegAlias)
            lcRelativePath  = THIS.uGetProp(ccEDC_OBJ_REGISTRY,;
                                            ccEDC_OBJ_UNIQUETYPE,;
                                            ccEDC_REG_ALTERNATE)
            IF NOT EMPTY(lcRelativePath)
               * Convert relative path to full path.
               THIS.rcEdcFullPath =;
                    IIF(":\" $ lcRelativePath,;
                        "",;
                        LEFT(THIS.rcRegFullPath,;
                             RAT("\", THIS.rcRegFullPath)-;
                                 IIF(LEFT(lcRelativePath,1)=="\", 1, 0)))+;
                    lcRelativePath
               IF THIS.rcEdcField == lcEdcField
                  llReturn = THIS.lOpenEdc(tcEdcField)
                  IF llReturn  && set alternate as main EDC
                     lcEdcAlias = THIS.rcEdcAlias
                     lcFullPath = THIS.rcEdcFullPath
                  ELSE  && abort if we can't open the main EDC alternate
                     EXIT
                  ENDIF
               ELSE
                  IF NOT ISNULL(THIS.raAlternate[1])
                     DIMENSION THIS.raAlternate[;
                                  ALEN(THIS.raAlternate, 1)+1,;
                                  ALEN(THIS.raAlternate, 2)]
                  ENDIF
                  * lOpenEdc() sets THIS.rcEdcAlias and THIS.rcEdcFullPath.
                  IF THIS.lOpenEdc(THIS.rcEdcField)
                     * Pad field name for ASCAN() search in SetSameName().
                     THIS.raAlternate[ALEN(THIS.raAlternate,1),;
                                      cnALT_FIELD] =;
                        PADR(THIS.rcEdcField, cnVF_FIELD_MAXNAMELEN)
                     THIS.raAlternate[ALEN(THIS.raAlternate,1),;
                                      cnALT_ALIAS] = THIS.rcEdcAlias
                  ENDIF  && open alternate EDC
               ENDIF  && main or update alternate EDC
            ENDIF  && alternate EDC
         ENDFOR  && all fields
         THIS.rcEdcAlias    = lcEdcAlias
         THIS.rcEdcField    = lcEdcField
         THIS.rcEdcFullPath = lcFullPath
      ENDIF  && llReturn

      IF NOT llReturn
         =THIS.Close()
      ENDIF
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN llReturn
   ENDFUNC && lOpen ********************************************


   PROCEDURE Close()
   * Action: Close our use of the DBC and EDC.
   * Update: Version 1.0
      LOCAL lnCounter
      IF (NOT ISNULL(THIS.rcDbcAlias)) AND USED(THIS.rcDbcAlias)
         USE IN (THIS.rcDbcAlias)
      ENDIF
      IF (NOT ISNULL(THIS.rcBoundAlias)) AND USED(THIS.rcBoundAlias)
         USE IN (THIS.rcBoundAlias)
      ENDIF
      IF (NOT ISNULL(THIS.rcEdcAlias)) AND USED(THIS.rcEdcAlias)
         USE IN (THIS.rcEdcAlias)
      ENDIF
      IF (NOT ISNULL(THIS.rcRegAlias)) AND USED(THIS.rcRegAlias)
         USE IN (THIS.rcRegAlias)
      ENDIF
      * Alternate EDCs.
      IF NOT ISNULL(THIS.raAlternate[1, cnALT_ALIAS])
         FOR lnCounter = 1 TO ALEN(THIS.raAlternate, 1)
            IF USED(THIS.raAlternate[lnCounter, cnALT_ALIAS])
               USE IN (THIS.raAlternate[lnCounter, cnALT_ALIAS])
            ENDIF
         ENDFOR
      ENDIF
      * Alternate method objects.
      IF NOT ISNULL(THIS.raObject[1, cnOBJ_OWNER])
         FOR lnCounter = 1 TO ALEN(THIS.raObject, 1)
            IF NOT EMPTY(THIS.raObject[lnCounter, cnOBJ_RELEASE])
               =THIS.RemoveObject(;
                     SUBSTR(THIS.raObject[lnCounter, cnOBJ_OWNER],;
                            2,;
                            LEN(THIS.raObject[lnCounter, cnOBJ_OWNER])-2))
               IF RIGHT(THIS.raObject[lnCounter,;
                                      cnOBJ_RELEASE], 4) == ".vcx"
                  RELEASE CLASS (THIS.raObject[lnCounter,;
                                               cnOBJ_RELEASE])
               ELSE
                  RELEASE PROCEDURE (THIS.raObject[lnCounter,;
                                                   cnOBJ_RELEASE])
               ENDIF
            ENDIF  && release class library
         ENDFOR
      ENDIF
      DIMENSION THIS.raObject[1, cnALT_COLUMNS],;
                THIS.raObject[1, cnOBJ_COLUMNS]
      STORE .NULL. TO THIS.rcDbcAlias,    THIS.rcDbcFullPath,;
                      THIS.rcBoundAlias,  THIS.rcBoundFullPath,;
                      THIS.rcRegAlias,    THIS.rcRegFullPath,;
                      THIS.rcEdcAlias,    THIS.rcEdcFullPath,;
                      THIS.rcEdcField,    THIS.raAlternate,;
                      THIS.raObject
   ENDPROC && Close ********************************************


   FUNCTION cVersion()
   * Action: Get this class's #DEFINE version number.
   * Update: Version 1.0
      RETURN ccEDC_VERSION
   ENDFUNC && cVersion *****************************************


   FUNCTION cEdc()
   * Action: Get full path spec of the EDC table.
   * Update: Version 1.0
   *  Notes: Path is in the VFP format and it is up to
   *       :    the calling program to use SYS(2027), ///or
   *       :    to protect from spaces in the fullpath.
   *       : Always the same as the DBC fullpath.
      RETURN NVL(THIS.rcEdcFullPath, "")
   ENDFUNC && cEDC *********************************************


   FUNCTION cEdcAlias()
   * Action: Get our alias name for the EDC table.
   * Update: Version 1.0
      RETURN NVL(THIS.rcEdcAlias, "")
   ENDFUNC && cEdcAlias ****************************************


   FUNCTION cDbcAlias()
   * Action: Get our alias name for the DBC table.
   * Update: Version 1.0
      RETURN NVL(THIS.rcDbcAlias, "")
   ENDFUNC && cDbcAlias ****************************************


   FUNCTION lCurrent()
   * Action: Compare last DBC update time with the EDC time.
   * Return: True if the EDC datetime is greater than or equal
   *       :    the DBC datetime.
   *       : Returns .NULL. if not open error.
   * Update: Version 1.0
   *  Notes: Does not check the memo or index file.
      LOCAL llReturn
      DO CASE
         CASE ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
            ERROR cnVF_ERR_DB_NOTOPEN
            llReturn = .NULL.
         CASE ISNULL(THIS.rcEdcAlias) OR NOT USED(THIS.rcEdcAlias)
            ERROR THIS.rcErrorEdcNotOpen
            llReturn = .NULL.
         OTHERWISE
            FLUSH  && in case either changed
            llReturn = CTOT(DTOC(FDATE(THIS.rcEdcFullPath))+;
                                 FTIME(THIS.rcEdcFullPath)) >=;
                       CTOT(DTOC(FDATE(THIS.rcDbcFullPath))+;
                                 FTIME(THIS.rcDbcFullPath))
      ENDCASE
      RETURN llReturn
   ENDFUNC && lCurrent *****************************************


   FUNCTION lGetShowErrors()
   * Action: Get setting of the rlShowErrors property.
   * Update: Version 1.0
      RETURN THIS.rlShowErrors
   ENDFUNC && lGetShowErrors ***********************************


   PROCEDURE SetShowErrors(tlShowErrors)
   * Action: Set the rlShowErrors property.
   * Update: Version 1.0
      DO CASE  && of parameter checking (not subject to rlTestParameters)
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tlShowErrors) OR NOT TYPE("tlShowErrors")=="L"
            ERROR cnVF_ERR_PARAM_INVALID
         OTHERWISE
            THIS.rlShowErrors = tlShowErrors
      ENDCASE  && of parameter checking
   ENDPROC && SetShowErrors ************************************


   FUNCTION lGetShowMessages()
   * Action: Get setting of the rlShowMessages property.
   * Update: Version 1.0
      RETURN THIS.rlShowMessages
   ENDFUNC && lGetShowMessages *********************************


   PROCEDURE SetShowMessages(tlShowMessages)
   * Action: Set the rlShowMessages property.
   * Update: Version 1.0
      DO CASE  && of parameter checking (not subject to rlTestParameters)
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tlShowMessages) OR NOT TYPE("tlShowMessages")=="L"
            ERROR cnVF_ERR_PARAM_INVALID
         OTHERWISE
            THIS.rlShowMessages = tlShowMessages
      ENDCASE  && of parameter checking
   ENDPROC && SetShowMessages **********************************


   FUNCTION lGetTestParameters()
   * Action: Get setting of the rlTestParameters property.
   * Update: Version 1.0
      RETURN THIS.rlTestParameters
   ENDFUNC && lGetTestParameters *******************************


   PROCEDURE SetTestParameters(tlTestParameters)
   * Action: Set the rlTestParameters property.
   * Update: Version 1.0
      DO CASE  && of parameter checking (not subject to rlTestParameters)
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tlTestParameters) OR NOT TYPE("tlTestParameters")=="L"
            ERROR cnVF_ERR_PARAM_INVALID
         OTHERWISE
            THIS.rlTestParameters = tlTestParameters
      ENDCASE  && of parameter checking
   ENDPROC && SetTestParameters ********************************


   FUNCTION lGetExecTime()
   * Action: Get setting of the rlExecTime property.
   * Update: Version 1.0
      RETURN THIS.rlExecTime
   ENDFUNC && lGetExecTime *************************************


   PROCEDURE SetExecTime(tlExecTime)
   * Action: Set the rlExecTime property.
   * Update: Version 1.0
   *  Notes: Also resets nExecTime to zero.
      DO CASE  && of parameter checking (not subject to rlTestParameters)
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tlExecTime) OR NOT TYPE("tlExecTime")=="L"
            ERROR cnVF_ERR_PARAM_INVALID
         OTHERWISE
            THIS.rlExecTime = tlExecTime
            THIS.nExecTime  = 0
      ENDCASE  && of parameter checking
   ENDPROC && SetExecTime **************************************


   FUNCTION lGetPropLock()
   * Action: Get setting of the rlPropLock property.
   * Update: Version 1.0
      RETURN THIS.rlPropLock
   ENDFUNC && lGetPropLock *************************************


   PROCEDURE SetPropLock(tlPropLock)
   * Action: Set the rlPropLock property.
   * Update: Version 1.0
      DO CASE  && of parameter checking (not subject to rlTestParameters)
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tlPropLock) OR NOT TYPE("tlPropLock")=="L"
            ERROR cnVF_ERR_PARAM_INVALID
         OTHERWISE
            THIS.rlPropLock = tlPropLock
      ENDCASE  && of parameter checking
   ENDPROC && SetPropLock **************************************


   PROCEDURE SetPropHead(tcPropHead)
   * Action: Set the rcPropHead property prior to calling uSetProp()
   *       :    to set both the header and property in one call.
   * Update: Version 1.0
   *  Notes: uSetProp() resets rcPropHead to empty, unless the first
   *       :    character (normally used for type and ignored in
   *       :    rcPropHead) is set to ccHEAD_ON, in which case the
   *       :    rcPropHead retains its setting until released.
   *       : tcPropHead is optional and must either be empty or the
   *       :    same length as cnHEAD_SWITCHSIZE.
   *       : Pass an empty space " " in any character that you want
   *       :    to retain the current value.
      LOCAL lnCounter
      DO CASE  && of parameter checking (not subject to rlTestParameters)
         CASE EMPTY(tcPropHead) OR ISNULL(tcPropHead)
            THIS.rcPropHead = ""
         CASE NOT (TYPE("tcPropHead") == "C" AND;
                   LEN(tcPropHead)    == cnHEAD_SWITCHSIZE)
            ERROR cnVF_ERR_PARAM_INVALID
         OTHERWISE
            FOR lnCounter = cnHEAD_READLOCK TO cnHEAD_RESERVED1
               IF NOT INLIST(SUBSTR(tcProphead, lnCounter, 1),;
                             " ", ccHEAD_OFF, ccHEAD_ON)
                  ERROR cnVF_ERR_PARAM_INVALID
                  RETURN  && early exit
               ENDIF
            ENDFOR
            THIS.rcPropHead = tcPropHead
      ENDCASE  && of parameter checking
   ENDPROC && SetPropHead **************************************


   FUNCTION lRemoveField(tcEdcField)
   * Action: Remove an extended field from the EDC.
   * Return: True if successful, otherwise false.
   * Update: Version 1.0
   *  Notes: To protect from removal, change ccEDC_REG_REMOVELOCK
   *       :    to .T. in the field's registry.
   *       :    E.g., uSetProp(ccEDC_OBJ_REGISTRY, ccEDC_OBJ_UNIQUETYPE,;
   *       :                   ccEDC_REG_REMOVELOCK, .T.)
   *       : You can also lock the property header to prevent
   *       :    changing or removing the property.  This method
   *       :    does not check for read lock in the property header.
   *       : All constants are defined in TRUE.h.

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lcEdcField,;
            lcEdcThisField,;
            llExtended,;
            llReturn,;
            lnSelect,;
            lcString
            
      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 1
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE ISNULL(tcEdcField) OR EMPTY(tcEdcField) OR;
              NOT TYPE("tcEdcField")=="C"
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE ISNULL(THIS.rcEdcAlias) OR NOT USED(THIS.rcEdcAlias)
            ERROR THIS.rcErrorEdcNotOpen
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         RETURN llReturn  && early exit
      ENDIF

      lcEdcField = UPPER(ALLTRIM(tcEdcField))
      lnSelect   = SELECT()

      SELECT (THIS.rcEdcAlias)
      FOR lnCounter = cnEDC_FIXEDFIELDS+1 TO FCOUNT()
         IF FIELD(lnCounter) == lcEdcField
            llExtended = .T.
            EXIT
         ENDIF
      ENDFOR

      * Check for field lock property in the registry.
      IF llExtended
         lcEdcThisField  = THIS.rcEdcField
         THIS.rcEdcField = lcEdcField
         IF THIS.uGetProp(ccEDC_OBJ_REGISTRY, ccEDC_OBJ_UNIQUETYPE,;
                          ccEDC_REG_REMOVELOCK)
            lcString = .NULL.
         ENDIF
         THIS.rcEdcField = lcEdcThisField
      ENDIF  && llExtended

      DO CASE  && of extended field options
         CASE NOT llExtended
            ERROR cnVF_ERR_FIELD_NOTFOUND

         CASE ISNULL(lcString)  && field is locked from removal
            ERROR STRTRAN(THIS.rcErrorFieldLock,;
                          ccMSG_INSERT1,;
                          ALLTRIM(tcEdcField))

         CASE THIS.Message.nShow(IDYES,;
                         STRTRAN(STRTRAN(THIS.rcMsgRemoveField,;
                                         ccMSG_INSERT1,;
                                         ALLTRIM(tcEdcField)),;
                                 ccMSG_INSERT2,;
                                 SYS(cnVF_SYS_CROSSPATH,;
                                     THIS.rcEdcFullPath)),;
                         MB_YESNO+MB_ICONQUESTION+MB_DEFBUTTON2,;
                         THIS.rcMsgBoxTitle) == IDYES
            IF NOT ISEXCLUSIVE()
               USE (THIS.rcEdcFullPath) EXCLUSIVE ALIAS (THIS.rcEdcAlias)
            ENDIF
            IF ISEXCLUSIVE()
               THIS.aObjectError[cnVF_AERR_NUMBER] = 0
               ALTER TABLE (THIS.rcEdcFullPath);
                  DROP COLUMN &lcEdcField  && macro alert
               llReturn = THIS.aObjectError[cnVF_AERR_NUMBER] == 0
               DO CASE
                  CASE NOT llReturn
                     * Do nothing.
                  CASE lcEdcField == THIS.rcEdcField
                     =THIS.Close()
                  CASE SET("EXCLUSIVE")=="OFF"
                     USE (THIS.rcEdcFullPath) AGAIN ALIAS (THIS.rcEdcAlias)
               ENDCASE
            ELSE
               ERROR cnVF_ERR_EXCLUSIVE
            ENDIF
      ENDCASE  && of extended field options

      SELECT (lnSelect)
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN llReturn
   ENDFUNC && lRemoveField *************************************


   FUNCTION lPack(tcPackMethod)
   * Action: Pack the entire EDC table or just the memo fields.
   * Return: True if successful, otherwise false.
   * Update: Version 1.0
   *  Notes: tcPackMethod is optional and case insensitive.
   *       :    Pass "memo" or do not pass anything to PACK MEMO.
   *       :    Pass "pack" to remove deleted records with PACK.
   *       :    Pass "copy" to remove deleted records with COPY and RENAME.

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL llReturn,;
            lnSelect,;
            lcTempFile

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE PARAMETERS()==0 OR NOT THIS.rlTestParameters
            * Do nothing.
         CASE ISNULL(tcPackMethod) OR NOT TYPE("tcPackMethod")=="C"
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE ISNULL(THIS.rcEdcAlias) OR NOT USED(THIS.rcEdcAlias)
            ERROR THIS.rcErrorEdcNotOpen
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         RETURN llReturn  && early exit
      ENDIF

      lnSelect = SELECT()
      SELECT (THIS.rcEdcAlias)
      IF NOT ISEXCLUSIVE()
         USE (THIS.rcEdcFullPath) EXCLUSIVE ALIAS (THIS.rcEdcAlias)
      ENDIF

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of pack methods
         CASE NOT ISEXCLUSIVE()
            ERROR cnVF_ERR_EXCLUSIVE
         CASE EMPTY(tcPackMethod) OR;
              UPPER(ALLTRIM(tcPackMethod)) == ccMEMO
            PACK MEMO
         CASE UPPER(ALLTRIM(tcPackMethod)) == ccPACK
            PACK
         CASE UPPER(ALLTRIM(tcPackMethod)) == ccCOPY
            lcTempFile = LEFT(THIS.rcEdcFullPath,;
                              RAT("\", THIS.rcEdcFullPath))+;
                         SYS(cnVF_SYS_UNIQUEID) + ".dbf"
            COPY TO (lcTempFile) WITH CDX FOR NOT DELETED()
            IF FILE(lcTempFile) AND llReturn AND;
                  THIS.aObjectError[cnVF_AERR_NUMBER] == 0
               USE
               ERASE (THIS.rcEdcFullPath)
               ERASE (LEFT(THIS.rcEdcFullPath,;
                           RAT(".", THIS.rcEdcFullPath)) + "fpt")
               ERASE (LEFT(THIS.rcEdcFullPath,;
                           RAT(".", THIS.rcEdcFullPath)) + "cdx")
               RENAME (lcTempFile) TO (THIS.rcEdcFullPath)
               RENAME (LEFT(lcTempFile, RAT(".", lcTempFile)) + "fpt");
                   TO (LEFT(THIS.rcEdcFullPath,;
                       RAT(".", THIS.rcEdcFullPath)) + "fpt")
               RENAME (LEFT(lcTempFile, RAT(".", lcTempFile)) + "cdx");
                   TO (LEFT(THIS.rcEdcFullPath,;
                       RAT(".", THIS.rcEdcFullPath)) + "cdx")
               USE (THIS.rcEdcFullPath) ALIAS (THIS.rcEdcAlias)
            ENDIF
      ENDCASE  && of pack methods
      llReturn = THIS.aObjectError[cnVF_AERR_NUMBER] == 0

      IF SET("EXCLUSIVE")=="OFF" AND ISEXCLUSIVE()
         USE (THIS.rcEdcFullPath) AGAIN ALIAS (THIS.rcEdcAlias)
      ENDIF

      SELECT (lnSelect)
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN llReturn
   ENDFUNC && lPack ********************************************


   FUNCTION lValidate()
   * Action: Validate the extended file by comparing with the DBC.
   * Return: True if successful, otherwise false.
   * Update: Version 1.0
   *  Notes: ///delete records if unique ID not in DBC?
   *       : ///SQL DELETE? (not if locks entire table as SQL UPDATE does)
   *       : ///pack? =THIS.lPack()

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL llReturn

      ERROR cnVF_ERR_FUNC_NOTIMP   &&///

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN llReturn
   ENDFUNC && lValidate ****************************************


   FUNCTION lDbcFindObject(tcObjectName, tcObjectType)
   * Action: Search the DBC for an object.
   * Return: True if found, otherwise false.
   * Update: Version 1.0
   *  Notes: This is just an exposed method for access to the
   *       :    protected method, lSearchDbc().

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL llReturn,;
            lcObjectName

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 2
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE (NOT (TYPE("tcObjectName")=="C" OR;
                    TYPE("tcObjectType")=="C")   )        OR;
              ISNULL(tcObjectName) OR EMPTY(tcObjectName) OR;
              ISNULL(tcObjectType) OR EMPTY(tcObjectType)
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE "!" $ tcObjectName  && database name passed
            lcObjectName = ALLTRIM(LEFT(tcObjectName,;
                                        AT("!", tcObjectName)-1))
            IF NOT EMPTY(THIS.cOpenDbc(lcObjectName))
               lcObjectName = ALLTRIM(SUBSTR(tcObjectName,;
                                             AT("!", tcObjectName)+1))
               llReturn = THIS.lSearchDbc(@lcObjectName, @tcObjectType)
               IF NOT ISNULL(THIS.rcBoundAlias)
                  * Restore the bound DBC.
                  THIS.rcDbcAlias    = THIS.rcBoundAlias
                  THIS.rcDbcFullPath = THIS.rcBoundFullPath
               ENDIF
            ENDIF
         CASE ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
            IF NOT EMPTY(THIS.cOpenDbc())
               llReturn = THIS.lSearchDbc(@tcObjectName, @tcObjectType)
            ENDIF
         OTHERWISE
            llReturn = THIS.lSearchDbc(@tcObjectName, @tcObjectType)
      ENDCASE  && of setup

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN llReturn
   ENDFUNC && lDbcFindObject ***********************************


   FUNCTION cDbcGetProp(tcObjectName, tcObjectType, tcPropertyType)
   * Action: Get a property from the DBC.
   * Return: Property string if found, otherwise character .NULL.
   * Update: Version 1.0
   *  Notes: This provides direct access to the DBC's properties
   *       :    for any goodies to which VFP doesn't grant access.
   *       : Use cAnalyzeDbcProp() to get a readable list of
   *       :    properties and their binary code prefixes, or use
   *       :    the known defined codes from TRUE.h.
   *       :///Add defined prop type for RiInfo? (waiting for beta 3)

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lcObjectName,;
            lcReturn,;
            lnSize,;
            lnStart
      lcReturn = ""

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 3
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE (NOT (TYPE("tcObjectName")=="C" OR;
                    TYPE("tcObjectType")=="C" OR;
                    TYPE("tcPropertyType")=="C"))         OR;
              ISNULL(tcObjectName) OR EMPTY(tcObjectName) OR;
              ISNULL(tcObjectType) OR EMPTY(tcObjectType) OR;
              ISNULL(tcPropertyType)
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE "!" $ tcObjectName  && database name passed
            lcObjectName = ALLTRIM(LEFT(tcObjectName,;
                                        AT("!", tcObjectName)-1))
            IF EMPTY(THIS.cOpenDbc(lcObjectName))
               lcObjectName = ""
            ELSE
               lcObjectName = ALLTRIM(SUBSTR(tcObjectName,;
                                             AT("!", tcObjectName)+1))
               llReturn = THIS.lSearchDbc(@lcObjectName, @tcObjectType)
            ENDIF
         CASE ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
            IF NOT EMPTY(THIS.cOpenDbc())
               =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
            ENDIF
         OTHERWISE
            =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
            * Restore the bound DBC.
            THIS.rcDbcAlias    = THIS.rcBoundAlias
            THIS.rcDbcFullPath = THIS.rcBoundFullPath
         ENDIF
         lcReturn = .NULL.
         RETURN lcReturn  && early exit
      ENDIF

      * Get the property.
      lcReturn = THIS.cGetOneDbcProp(@tcPropertyType)

      DO CASE  && of formatting properties
         CASE EMPTY(lcReturn)
            ERROR cnVF_ERR_PROP_NOTFOUND,;
                  THIS.rcTypeName + IIF(ASC(tcPropertyType) < 32,;
                                        "", " "+tcPropertyType+" ")
            lcReturn = .NULL.

         * Index tag.  Exception because it has to look at its parent
         * to find out if it's a primary key tag and substitute a
         * defined word for the binary value.
         CASE PADR(PROPER(LTRIM(tcObjectType)),;
                   cnVF_OBJ_TYPESIZE) == ccVF_OBJ_INDEX AND;
              tcPropertyType == ccVF_IND_TAGTYPE
            IF lcReturn == ccVF_IND_CANDIDATE
               * Save the tag name to compare with primary key
               * tag that is stored in table, not index.
               lcReturn = TRIM(EVALUATE(THIS.rcDbcAlias+".ObjectName"))
               GO EVALUATE(THIS.rcDbcAlias+".ParentID");
                  IN THIS.rcDbcAlias
               lcReturn = IIF(THIS.cGetOneDbcProp(ccVF_TAB_PRIMARYTAG) ==;
                                 lcReturn,;
                              ccPRIMARY, ccCANDIDATE)
            ELSE  && regular
               lcReturn = ccREGULAR
            ENDIF
      ENDCASE  && of formatting properties

      IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
         * Restore the bound DBC.
         THIS.rcDbcAlias    = THIS.rcBoundAlias
         THIS.rcDbcFullPath = THIS.rcBoundFullPath
      ENDIF
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN lcReturn
   ENDFUNC && cDbcGetProp **************************************


   FUNCTION lDbcSetProp(tcObjectName, tcObjectType,;
                        tcPropertyType, tcPropertyValue)
   * Action: Set a property in the DBC.
   * Return: True ifProperty string if found, otherwise false.
   * Update: Version 1.0
   *  Notes: This provides direct access to the DBC's properties
   *       :    for any goodies to which VFP doesn't grant access.
   *       : Use cAnalyzeDbcProp() to get a readable list of
   *       :    properties and their binary code prefixes, or use
   *       :    the known defined codes from TRUE.h.
   *       :///Add defined prop type for RiInfo? (waiting for beta 3)

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lcObjectName,;
            llReturn

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 4
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE (NOT (TYPE("tcObjectName")=="C" OR;
                    TYPE("tcObjectType")=="C" OR;
                    TYPE("tcPropertyType")=="C" OR;
                    TYPE("tcPropertyValue")=="C"))        OR;
              ISNULL(tcObjectName) OR EMPTY(tcObjectName) OR;
              ISNULL(tcObjectType) OR EMPTY(tcObjectType) OR;
              ISNULL(tcPropertyType) OR ISNULL(tcPropertyValue)
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE "!" $ tcObjectName  && database name passed
            lcObjectName = ALLTRIM(LEFT(tcObjectName,;
                                        AT("!", tcObjectName)-1))
            IF EMPTY(THIS.cOpenDbc(lcObjectName))
               lcObjectName = ""
            ELSE
               lcObjectName = ALLTRIM(SUBSTR(tcObjectName,;
                                             AT("!", tcObjectName)+1))
               llReturn = THIS.lSearchDbc(@lcObjectName, @tcObjectType)
            ENDIF
         CASE ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
            IF NOT EMPTY(THIS.cOpenDbc())
               =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
            ENDIF
         OTHERWISE
            =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
            * Restore the bound DBC.
            THIS.rcDbcAlias    = THIS.rcBoundAlias
            THIS.rcDbcFullPath = THIS.rcBoundFullPath
         ENDIF
         RETURN llReturn  && early exit
      ENDIF

      llReturn = THIS.lSetOneDbcProp(@tcPropertyType, @tcPropertyValue)

      IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
         * Restore the bound DBC.
         THIS.rcDbcAlias    = THIS.rcBoundAlias
         THIS.rcDbcFullPath = THIS.rcBoundFullPath
      ENDIF
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN llReturn
   ENDFUNC && lDbcSetProp **************************************


   FUNCTION nGetRelation(tcTableName, taReturnArray)
   * Action: Get specific relational info about one table and
   *       :    all its child relations from raRelations property.
   *       :    ///option to get parents? needs 3rd param tcAction.
   * Return: Number of rows in taReturnArray. ///option to return a cursor?
   * Update: Version 1.0
   *  Notes: taReturnArray is required and must be passed by reference.
   *       :///match uGetProp: Pass "ALL" in tcTableName to return all ...

      ERROR cnVF_ERR_FUNC_NOTIMP   &&///waiting for later beta
      RETURN 0                     &&///early exit

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lnCounter,;
            lnReturn,;
            lcTableName
      lnReturn = 0
      lcTableName = UPPER(ALLTRIM(tcTableName)) &&///beta 2: UPPER/LOWER/other?

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 2
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE (NOT (TYPE("tcTableName")  =="C" OR;
                    TYPE("taReturnArray[1]")=="U")) OR;
              ISNULL(tcTableName) OR EMPTY(tcTableName)
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE ISNULL(THIS.rcEdcAlias) OR NOT USED(THIS.rcEdcAlias)
            ERROR THIS.rcErrorEdcNotOpen
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         RETURN lnReturn
      ENDIF

      * Update raRelation if the DBC changed since our last update.
      *///beta 2: performance test storing the array
      IF THIS.rtRelation <;
         CTOT(DTOC(FDATE(LEFT(THIS.rcEdcFullPath,;
                              RAT(".", THIS.rcEdcFullPath))+"dbc"))+;
                   FTIME(LEFT(THIS.rcEdcFullPath,;
                         RAT(".", THIS.rcEdcFullPath))+"dbc"))
         =ADBOBJECTS(THIS.raRelation, "RELATION")
         *///sort it?
         THIS.rtRelation = DATETIME()
      ENDIF

      *///Under Construction!
      IF .f.  &&///ALL, just DIM and ACOPY()
      ELSE  && loop through raRelations for cascading child tables
         DIMENSION taReturnArray[1, cnVF_REL_MAXCOLS]
         taReturnArray[1] = .NULL.
         FOR lnCounter = 1 TO ALEN(THIS.raRelation, 1)
            IF lcTableName ==;
                  THIS.raRelation[lnCounter, cnVF_REL_PARENTTABLE]
               IF NOT ISNULL(taReturnArray[1])
                  DIMENSION taReturnArray[ALEN(taReturnArray ,1)+1,;
                                          cnVF_REL_MAXCOLS]
               ENDIF
               taReturnArray[ALEN(taReturnArray ,1),;
                                             cnVF_REL_PARENTTABLE] =;
                  THIS.raRelation[lnCounter, cnVF_REL_PARENTTABLE]
            ENDIF
         ENDFOR
      ENDIF

      lnReturn = ALEN(taReturnArray, 1)

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN lnReturn
   ENDFUNC && nGetRelation *************************************


   FUNCTION uGetProp(tcObjectName, tcObjectType,;
                     tcPropertyName, taReturnArray)
   * Action: Get an extended property.
   * Return: Property value if successful, otherwise logical .NULL.
   *       : Returns numeric number of properties found when "ALL"
   *       :    or wildcard properties are requested.
   * Update: Version 1.0
   *  Notes: Return type can be any valid FoxPro data type.
   *       : taReturnArray is required only when tcPropertyName
   *       :    is passed "ALL" or contains the wildcard character.
   *       :    Otherwise it is unused.  Must be passed by reference.
   *       : Fills the passed array in taReturnArray for "ALL"
   *       :    or wildcard properties.  taReturnArray has 3 columns:
   *       :    1 = name, 2 = value, 3 = header.  Return value is
   *       :    numeric, the number of rows in the array.
   *       : You can use the wildcard character "*" (asterisk) to
   *       :    get a group of like-named properties.  E.g.,
   *       :    pass tcPropertyName "Filter*" to get properties
   *       :    like FilterStartUp, FilterUser, and FilterWindow.
   *       :    Anything after the wildcard character is ignored.
   *       : Lock header to protect from reading.  Header locks
   *       :    do not prevent reading or changing the header.
   *       : Puts property header in the exposed property, cPropHead.
   *       : Header structure is documented in uSetProp() notes.

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lcObjectName,;
            lnPosition,;
            lcProperty,;
            luReturn,;
            lcString,;
            llUserDefined,;
            lcWildName

      * Default return value is unknown if not found or error.
      luReturn = .NULL.

      * If an alternate method is present, translate the arguments,
      * call the method, and return it's value.
      lnPosition = ASCAN(THIS.raObject,;
                         ccMSG_INSERT1 + THIS.rcEdcField + ccMSG_INSERT1) 
      IF lnPosition > 0
         lnPosition = ASUBSCRIPT(THIS.raObject, lnPosition, 1)
         IF NOT EMPTY(THIS.raObject[lnPosition, cnOBJ_GETMETHOD])
            lcString =;
               THIS.cSetArg(THIS.raObject[lnPosition, cnOBJ_GETMETHOD],;
                            @tcObjectName,;
                            @tcObjectType,;
                            @tcPropertyName)
            * Execute the alternate method instead of ours.  Early exit.
            RETURN THIS.raObject[lnPosition,;
                                 cnOBJ_OBJECT].&lcString  && macro alert
         ENDIF
      ENDIF

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 3 OR;
              ((UPPER(ALLTRIM(tcPropertyName)) == ccALL;
                OR ccWILDCARD $ tcPropertyName);
               AND PARAMETERS() < 4)
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE (NOT (TYPE("tcObjectName")  =="C" OR;
                    TYPE("tcObjectType")  =="C" OR;
                    TYPE("tcPropertyName")=="C")   )        OR;
              ISNULL(tcObjectName)   OR EMPTY(tcObjectName) OR;
              ISNULL(tcObjectType)   OR EMPTY(tcObjectType) OR;
              ISNULL(tcPropertyName) OR EMPTY(tcPropertyName)
            ERROR cnVF_ERR_PARAM_INVALID
         CASE PARAMETERS() == 4
              IF UPPER(ALLTRIM(tcPropertyName))==ccALL OR;
                    ccWILDCARD $ tcPropertyName
                 IF TYPE("taReturnArray[1]")=="U"  && not an array
                    ERROR cnVF_ERR_PARAM_INVALID
                 ENDIF
              ELSE
                 ERROR cnVF_ERR_PARAM_TOOMANY
              ENDIF
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE ISNULL(THIS.rcEdcAlias) OR NOT USED(THIS.rcEdcAlias)
            ERROR THIS.rcErrorEdcNotOpen
         CASE INLIST(PADR(PROPER(LTRIM(tcObjectType)), cnVF_OBJ_TYPESIZE),;
                     cxVF_OBJ_LISTALL)
            IF "!" $ tcObjectName  && database name passed
               lcObjectName = ALLTRIM(LEFT(tcObjectName,;
                                           AT("!", tcObjectName)-1))
               IF EMPTY(THIS.cOpenDbc(lcObjectName))
                  lcObjectName = ""
               ELSE
                  lcObjectName = ALLTRIM(SUBSTR(tcObjectName,;
                                                AT("!", tcObjectName)+1))
                  =THIS.lSearchDbc(@lcObjectName, @tcObjectType)
               ENDIF
            ENDIF
            IF ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
               IF NOT EMPTY(THIS.cOpenDbc())
                  =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
               ENDIF
            ELSE
               =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
            ENDIF
         CASE INLIST(PADR(LOWER(ALLTRIM(tcObjectType)),;
                          THIS.rnObjectTypeSize),;
                     LOWER(ccEDC_OBJ_UNIQUETYPE))  && list must be LOWERed
            llUserDefined = .NULL.
         CASE THIS.rlTestParameters
            DO CASE
               CASE LEN(ALLTRIM(tcObjectType)) > THIS.rnObjectTypeSize
                  ERROR cnVF_ERR_OBJ_TYPE
               CASE LEN(ALLTRIM(tcObjectName)) > THIS.rnObjectNameSize
                  ERROR cnVF_ERR_OBJ_NAME
               OTHERWISE  && user defined object
                  llUserDefined = .T.
            ENDCASE
         OTHERWISE  && user defined object
            llUserDefined = .T.
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
            * Restore the bound DBC.
            THIS.rcDbcAlias    = THIS.rcBoundAlias
            THIS.rcDbcFullPath = THIS.rcBoundFullPath
         ENDIF
         RETURN luReturn  && early exit
      ENDIF

      * Get or set object's unique id.
      DO CASE
         CASE ISNULL(llUserDefined)  && EDC system defined
            lcString = PADR(PROPER(LTRIM(tcObjectName)),;
                            FSIZE(ccEDC_ID, THIS.rcEdcAlias))
         CASE llUserDefined
            lcString = PADR(LOWER(LTRIM(tcObjectType)),;
                            THIS.rnObjectTypeSize)+;
                       PADR(LOWER(LTRIM(tcObjectName)),;
                            THIS.rnObjectNameSize)
         OTHERWISE  && EDC generated
            lcString = THIS.cSetUniqueID()  && does not change existing ID
      ENDCASE

      * Search the EDC and get property.
      DO CASE  && of getting properties
         CASE EMPTY(lcString) OR;
              NOT SEEK(lcString, THIS.rcEdcAlias,;
                       IIF(llUserDefined, ccEDC_OBJ, ccEDC_ID))
            ERROR cnVF_ERR_PROP_NOTFOUND, ALLTRIM(tcPropertyName)

         CASE UPPER(ALLTRIM(tcPropertyName)) == ccALL OR;
              ccWILDCARD $ tcPropertyName
 
            IF THIS.rlPropLock  && lock the record
               THIS.rlPropLock = LOCK()
            ENDIF

            lcWildName =;
               LOWER(LEFT(LTRIM(tcPropertyName),;
                          AT(ccWILDCARD, LTRIM(tcPropertyName))-1))

            * Get entire property field into memory.
            lcProperty = EVALUATE(THIS.rcEdcAlias + "."+THIS.rcEdcField)

            * Get position of first line mark.
            lnPosition = AT(THIS.rcLineMark, lcProperty)

            STORE 0 TO lnCounter, luReturn
            DO WHILE lnPosition > 0
               lnCounter = lnCounter+1
               lcString = SUBSTR(lcProperty,;
                                 lnPosition+LEN(THIS.rcLineMark),;
                                 AT(THIS.rcLineMark,;
                                    SUBSTR(lcProperty,;
                                           lnPosition+LEN(THIS.rcLineMark),;
                                           THIS.rnMaxPropLen+;
                                           THIS.rnMaxStrLen+;
                                           LEN(THIS.rcPropMark)))-1)
               THIS.cPropHead = SUBSTR(lcString,;
                                       AT(THIS.rcPropMark,lcString)+;
                                       LEN(THIS.rcPropMark),;
                                       cnHEAD_SIZE)
               IF THIS.rcPropMark $ lcString;
                     AND SUBSTR(THIS.cPropHead,;
                                cnHEAD_READLOCK,1) == ccHEAD_OFF;
                     AND ((NOT ccWILDCARD $ tcPropertyName) OR;
                          LOWER(LEFT(lcString,;
                                     LEN(lcWildName))) == lcWildName)
                  luReturn = luReturn+1
                  DIMENSION taReturnArray[luReturn,;
                                          MAX(3, ALEN(taReturnArray, 2))]
                  taReturnArray[luReturn, 1] =;
                     LEFT(lcString, AT(THIS.rcPropMark,lcString)-1)
                  taReturnArray[luReturn, 2] =;
                     THIS.uConvertProp(IIF(LEN(lcString)==;
                                              AT(THIS.rcPropMark,;
                                                 lcString)-1 +;
                                              LEN(THIS.rcPropMark)+;
                                              cnHEAD_SIZE,;
                                           "",;
                                           SUBSTR(lcString,;
                                              AT(THIS.rcPropMark,;
                                                 lcString)+;
                                              LEN(THIS.rcPropMark)+;
                                              cnHEAD_SIZE)))
                  taReturnArray[luReturn, 3] =;
                     THIS.cPropHead
               ENDIF

               * Get next line mark position and check that
               * it's not the last one.
               lnPosition = lnPosition + LEN(lcString)+;
                            LEN(THIS.rcLineMark)
               IF lnPosition == (LEN(lcProperty) -;
                                 LEN(THIS.rcLineMark)) + 1
                  EXIT
               ENDIF
            ENDDO  && WHILE lnPosition > 0

            IF luReturn > 0
               =ASORT(taReturnArray)
            ENDIF

         OTHERWISE  && one property
            * Get entire property field into memory.
            lcProperty = EVALUATE(THIS.rcEdcAlias + "."+THIS.rcEdcField)

            * Get position of property header.
            lnPosition = ATC(THIS.rcLineMark + ALLTRIM(tcPropertyName)+;
                             THIS.rcPropMark, lcProperty)
            IF lnPosition == 0  && property not found
               ERROR cnVF_ERR_PROP_NOTFOUND, ALLTRIM(tcPropertyName)
            ELSE
               IF THIS.rlPropLock  && lock the record
                  THIS.rlPropLock = LOCK()
               ENDIF

               * Get full property string and set cPropHead.
               luReturn = SUBSTR(lcProperty,;
                                 lnPosition+LEN(THIS.rcLineMark),;
                                 AT(THIS.rcLineMark,;
                                    SUBSTR(lcProperty,;
                                           lnPosition+LEN(THIS.rcLineMark),;
                                           THIS.rnMaxPropLen+;
                                              THIS.rnMaxStrLen+;
                                              LEN(THIS.rcPropMark)))-1)
               THIS.cPropHead = SUBSTR(luReturn,;
                                       LEN(ALLTRIM(tcPropertyName))+;
                                          LEN(THIS.rcPropMark) + 1,;
                                       cnHEAD_SIZE)

               * Read unless locked from reading.
               IF SUBSTR(THIS.cPropHead,cnHEAD_READLOCK,1)==ccHEAD_ON
                  ERROR cnVF_ERR_PROP_PROTECTED, ALLTRIM(tcPropertyName)
                  luReturn = .NULL.
               ELSE  && get the type-converted property value
                  luReturn =;
                     THIS.uConvertProp(IIF(LEN(luReturn)==;
                                              AT(THIS.rcPropMark,;
                                                 luReturn)-1 +;
                                              LEN(THIS.rcPropMark)+;
                                              cnHEAD_SIZE,;
                                           "",;
                                           SUBSTR(luReturn,;
                                              AT(THIS.rcPropMark,luReturn)+;
                                              LEN(THIS.rcPropMark)+;
                                              cnHEAD_SIZE)))
               ENDIF
            ENDIF
      ENDCASE  && of getting properties

      IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
         * Restore the bound DBC.
         THIS.rcDbcAlias    = THIS.rcBoundAlias
         THIS.rcDbcFullPath = THIS.rcBoundFullPath
      ENDIF
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN luReturn
   ENDFUNC && uGetProp *****************************************


   FUNCTION uSetProp(tcObjectName, tcObjectType,;
                     tcPropertyName, tuPropertyValue, tnAction)
   * Action: Set an extended property.
   * Return: True if successful, otherwise false.
   * Update: Version 1.0
   *  Notes: If the property exists, it is assigned the new value,
   *       :    otherwise it is added to the extended field.
   *       : Stores property in the format:
   *       :    LineMark + Name + PropMark + Header + Value + LineMark
   *       : Property header is 36 bytes with one byte each for:
   *       :    DataType  + NullValue +
   *       :    ReadLock  + WriteLock + RemoveLock + Update +
   *       :    Reserved1 + Reserved2 + Reserved3 + Reserved4 +
   *       :    User1 + User2 + User3 + User4 +
   *       :    PADR(TTOC(DATETIME()), 22)
   *       : tnAction is optional.
   *       :    To remove a property, pass -1 (cnPROP_REMOVE in TRUE.h).
   *       :    To set the header, pass the header byte 3, 4, or 5
   *       :       (cnHEAD_READLOCK, cnHEAD_WRITELOCK, or cnHEAD_REMOVELOCK)
   *       :       and pass the header setting (ccHEAD_ON or ccHEAD_OFF)
   *       :       in tuPropertyValue.
   *       : You cannot set both the the header and value in one call.
   *       : If you create a new property by setting the header,
   *       :    the property type is logical and the value is null.
   *       : Lock header to protect from removing or writing.
   *       :    Header locks do not prevent changing or reading the header.
   *       : Puts property header in the exposed property, cPropHead.
   *       : Pass "ALL" in tcPropertyName and pass an array by reference
   *       :    in tuPropertyValue to set all the properties in the array.
   *       :    the passed array has 3 columns: 1 = cName, 2 = uValue,
   *       :    and 3 = cHeader.  The return value is numeric, the number
   *       :    of properties set.  If the property is successfully
   *       :    changed, the header byte cnHEAD_RESERVED1 will be on.

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lnCounter,;
            lnCounter2,;
            laMap[1],;
            lcObjectName,;
            lnParameters,;
            lnPosition,;
            lcProperty,;
            luReturn,;
            lcString,;
            llUserDefined
      lnParameters = PARAMETERS()

      * If an alternate method is present, translate the arguments,
      * call the method, and return.
      lnPosition = ASCAN(THIS.raObject,;
                         ccMSG_INSERT1 + THIS.rcEdcField +;
                         ccMSG_INSERT1) 
      IF lnPosition > 0
         lnPosition = ASUBSCRIPT(THIS.raObject, lnPosition, 1)
         IF NOT EMPTY(THIS.raObject[lnPosition, cnOBJ_SETMETHOD])
            lcString =;
               THIS.cSetArg(THIS.raObject[lnPosition, cnOBJ_SETMETHOD],;
                            @tcObjectName,   @tcObjectType,;
                            @tcPropertyName, @tuPropertyValue)
            * Execute the alternate method instead of ours.  Early exit.
            RETURN THIS.raObject[lnPosition,;
                                 cnOBJ_OBJECT].&lcString  && macro alert
         ENDIF
      ENDIF

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE lnParameters < 4
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE (NOT (TYPE("tcObjectName")  =="C" OR;
                    TYPE("tcObjectType")  =="C" OR;
                    TYPE("tcPropertyName")=="C")   )        OR;
              ISNULL(tcObjectName)   OR EMPTY(tcObjectName) OR;
              ISNULL(tcObjectType)   OR EMPTY(tcObjectType) OR;
              ISNULL(tcPropertyName) OR EMPTY(tcPropertyName)
            ERROR cnVF_ERR_PARAM_INVALID
         CASE THIS.rcLineMark $ tcPropertyName
            ERROR THIS.rcErrorNameLineMark
         CASE THIS.rcPropMark $ tcPropertyName
            ERROR THIS.rcErrorNamePropMark
         CASE LEN(ALLTRIM(tcPropertyName)) > THIS.rnMaxPropLen
            ERROR STRTRAN(THIS.rcErrorPropNameLen, ccMSG_INSERT1,;
                          ALLTRIM(tcPropertyName))
         CASE UPPER(ALLTRIM(tcPropertyName)) == ccALL
            IF TYPE("tuPropertyValue[1]")=="U"  && not an array
               ERROR cnVF_ERR_PARAM_INVALID
            ELSE
               IF ALEN(tuPropertyValue, 2) < 3
                  ERROR cnVF_ERR_ARRAYDIM
               ENDIF
            ENDIF
         CASE ccWILDCARD $ tcPropertyName
            ERROR cnVF_ERR_NAME_ISUSED,;
                  THIS.rcReserveName + ': "' + ccWILDCARD + '"'
         CASE lnParameters == 5 AND;
              ((ISNULL(tnAction) OR NOT TYPE("tnAction")=="N") OR;
               (NOT (BETWEEN(tnAction, cnHEAD_READLOCK, cnHEAD_SWITCHSIZE) OR;
                     INLIST(tnAction, cnPROP_REMOVE))) OR;
               (BETWEEN(tnAction, cnHEAD_READLOCK, cnHEAD_SWITCHSIZE) AND;
                ((NOT TYPE("tuPropertyValue")=="C") OR;
                 ISNULL(tuPropertyValue) OR;
                 (NOT LEN(tuPropertyValue)==1) OR;
                 (tnAction <= cnHEAD_RESERVED1 AND;
                  NOT INLIST(tuPropertyValue, ccHEAD_ON, ccHEAD_OFF)))))
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE ISNULL(THIS.rcEdcAlias) OR NOT USED(THIS.rcEdcAlias)
            ERROR THIS.rcErrorEdcNotOpen
         CASE INLIST(PADR(PROPER(LTRIM(tcObjectType)), cnVF_OBJ_TYPESIZE),;
                     cxVF_OBJ_LISTALL)
            IF "!" $ tcObjectName  && database name passed
               lcObjectName = ALLTRIM(LEFT(tcObjectName,;
                                           AT("!", tcObjectName)-1))
               IF EMPTY(THIS.cOpenDbc(lcObjectName))
                  lcObjectName = ""
               ELSE
                  lcObjectName = ALLTRIM(SUBSTR(tcObjectName,;
                                                AT("!", tcObjectName)+1))
                  =THIS.lSearchDbc(@lcObjectName, @tcObjectType)
               ENDIF
            ENDIF
            IF ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
               IF NOT EMPTY(THIS.cOpenDbc())
                  =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
               ENDIF
            ELSE
               =THIS.lSearchDbc(@tcObjectName, @tcObjectType)
            ENDIF
         CASE INLIST(PADR(LOWER(ALLTRIM(tcObjectType)),;
                          THIS.rnObjectTypeSize),;
                     LOWER(ccEDC_OBJ_UNIQUETYPE))  && list must be LOWER()
            llUserDefined = .NULL.
         CASE ATC(ALLTRIM(tcObjectName), ccEDC_REG_LISTALL) > 0
         * It's a required registry property.
            IF lnParameters == 5 AND tnAction == cnPROP_REMOVE
               * Don't allow removal.
               ERROR cnVF_ERR_PROP_READONLY, ALLTRIM(tcPropertyName)
            ELSE  && type check the value (ignore rlTestParameters)
               lcString = TYPE("tuPropertyValue")
               IF (lcString == "C" AND;
                   ATC(ALLTRIM(tcObjectName), ccEDC_REG_LISTTYPEC) == 0) OR;
                  (lcString == "L" AND;
                   ATC(ALLTRIM(tcObjectName), ccEDC_REG_LISTTYPEL) == 0) OR;
                  (lcString == "T" AND;
                   ATC(ALLTRIM(tcObjectName), ccEDC_REG_LISTTYPET) == 0)
                 ERROR cnVF_ERR_PARAM_INVALID
               ENDIF
            ENDIF
         CASE THIS.rlTestParameters
            DO CASE
               CASE LEN(ALLTRIM(tcObjectType)) > THIS.rnObjectTypeSize
                  ERROR cnVF_ERR_OBJ_TYPE
               CASE LEN(ALLTRIM(tcObjectName)) > THIS.rnObjectNameSize
                  ERROR cnVF_ERR_OBJ_NAME
               OTHERWISE  && user defined object
                  llUserDefined = .T.
            ENDCASE
         OTHERWISE  && user defined object
            llUserDefined = .T.
      ENDCASE  && of setup
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
            * Restore the bound DBC.
            THIS.rcDbcAlias    = THIS.rcBoundAlias
            THIS.rcDbcFullPath = THIS.rcBoundFullPath
         ENDIF
         RETURN luReturn  && early exit
      ENDIF

      * Get or set object's unique id.
      DO CASE
         CASE ISNULL(llUserDefined)  && EDC system defined
            lcString = PROPER(LTRIM(tcObjectName))
         CASE llUserDefined  && real user defined
            lcString = PADR(LOWER(LTRIM(tcObjectType)),;
                            THIS.rnObjectTypeSize)+;
                       PADR(LOWER(LTRIM(tcObjectName)),;
                            THIS.rnObjectNameSize)
         OTHERWISE  && EDC generated
            lcString = THIS.cSetUniqueID()  && does not change existing ID
      ENDCASE

      * Search the EDC, and insert a record if necessary.
      IF NOT (SEEK(lcString, THIS.rcEdcAlias,;
                   IIF(llUserDefined, ccEDC_OBJ, ccEDC_ID)) OR;
              (lnParameters == 5 AND tnAction == cnPROP_REMOVE))
         IF llUserDefined
            INSERT INTO (THIS.rcEdcAlias);
                        (cxEDC_ID,               cxEDC_OBJ);
                 VALUES (SYS(cnVF_SYS_UNIQUEID), TRIM(lcString))
         ELSE  && system defined or random unique
            INSERT INTO (THIS.rcEdcAlias);
                        (cxEDC_ID);
                 VALUES (lcString)
         ENDIF
      ENDIF

      IF LOCK(THIS.rcEdcAlias)
         * Set the property or properties.
         IF UPPER(ALLTRIM(tcPropertyName)) == "ALL"
            luReturn = 0
            FOR lnCounter = 1 TO ALEN(tuPropertyValue, 1)
               IF THIS.lEdcSetProp(tuPropertyValue[lnCounter, 1],;
                                   tuPropertyValue[lnCounter, 2],;
                                   @tnAction,;
                                   @lnParameters)
                  tuPropertyValue[lnCounter, 3] =;
                      STUFF(THIS.cPropHead, cnHEAD_RESERVED1, 1, ccHEAD_ON)
                  luReturn = luReturn + 1
               ENDIF
            ENDFOR
         ELSE
            luReturn = THIS.lEdcSetProp(@tcPropertyName,;
                                        @tuPropertyValue,;
                                        @tnAction,;
                                        @lnParameters)
         ENDIF  && one property or all

         IF NOT EMPTY(luReturn)
            * Update any like-named extensions if cnHEAD_UPDATE
            * is on and not setting header or removing property.
            IF UPPER(ALLTRIM(tcPropertyName)) == "ALL"
               FOR lnCounter = 1 TO ALEN(tuPropertyValue, 1)
                  IF SUBSTR(tuPropertyValue[lnCounter, 3],;
                            cnHEAD_UPDATE, 1) == ccHEAD_ON
                     =THIS.SetSameName(@tcObjectName,;
                                       @tcObjectType,;
                                       tuPropertyValue[lnCounter, 1],;
                                       tuPropertyValue[lnCounter, 2],;
                                       @tnAction,;
                                       @lnParameters,;
                                       @lcString,;
                                       IIF(llUserDefined,;
                                           ccEDC_OBJ, ccEDC_ID),;
                                       IIF(llUserDefined,;
                                           EVALUATE(THIS.rcEdcAlias+;
                                                    "."+ccEDC_ID),;
                                           lcString))
                     * Repeat for any mapped properties.
                     IF THIS.uGetProp(@tcObjectName,;
                                      @tcObjectType,;
                                      TRIM(tcPropertyName) + ccEDC_MAPALL,;
                                      @laMap) > 0
                        FOR lnCounter2 = 1 TO ALEN(laMap, 1)
                           =THIS.SetSameName(@tcObjectName,;
                                             @tcObjectType,;
                                             laMap[lnCounter2, 2],;
                                             tuPropertyValue[lnCounter, 2],;
                                             @tnAction,;
                                             @lnParameters,;
                                             @lcString,;
                                             IIF(llUserDefined,;
                                                 ccEDC_OBJ, ccEDC_ID),;
                                             IIF(llUserDefined,;
                                                 EVALUATE(THIS.rcEdcAlias+;
                                                    "."+ccEDC_ID),;
                                                 lcString))
                        ENDFOR
                     ENDIF  && mapped properties
                  ENDIF  && update header on
               ENDFOR  && all fields
            ELSE  && one property
               IF SUBSTR(THIS.cPropHead,;
                         cnHEAD_UPDATE, 1) == ccHEAD_ON AND;
                     NOT lnParameters == 5
                  =THIS.SetSameName(@tcObjectName,;
                                    @tcObjectType,;
                                    @tcPropertyName,;
                                    @tuPropertyValue,;
                                    @tnAction,;
                                    @lnParameters,;
                                    @lcString,;
                                    IIF(llUserDefined,;
                                        ccEDC_OBJ, ccEDC_ID),;
                                    IIF(llUserDefined,;
                                        EVALUATE(THIS.rcEdcAlias+;
                                                 "."+ccEDC_ID),;
                                        lcString))
                  * Repeat for any mapped properties.
                  IF THIS.uGetProp(@tcObjectName,;
                                   @tcObjectType,;
                                   TRIM(tcPropertyName) + ccEDC_MAPALL,;
                                   @laMap) > 0
                     FOR lnCounter2 = 1 TO ALEN(laMap, 1)
                        =THIS.SetSameName(@tcObjectName,;
                                          @tcObjectType,;
                                          laMap[lnCounter2, 2],;
                                          @tuPropertyValue,;
                                          @tnAction,;
                                          @lnParameters,;
                                          @lcString,;
                                          IIF(llUserDefined,;
                                              ccEDC_OBJ, ccEDC_ID),;
                                          IIF(llUserDefined,;
                                              EVALUATE(THIS.rcEdcAlias+;
                                                       "."+ccEDC_ID),;
                                              lcString))
                     ENDFOR
                  ENDIF  && mapped properties
               ENDIF  && update header on
            ENDIF  && one property or all
         ENDIF  && NOT EMPTY(luReturn)
      ENDIF  && LOCK(THIS.rcEdcAlias)
      UNLOCK RECORD RECNO(THIS.rcEdcAlias) IN THIS.rcEdcAlias

      IF NOT (EMPTY(lcObjectName) OR ISNULL(THIS.rcBoundAlias))
         * Restore the bound DBC.
         THIS.rcDbcAlias    = THIS.rcBoundAlias
         THIS.rcDbcFullPath = THIS.rcBoundFullPath
      ENDIF
      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN luReturn
   ENDFUNC && uSetProp *****************************************


   FUNCTION uIncProp(tcObjectName, tcObjectType,;
                     tcPropertyName, tnIncValue)
   * Action: Increment an extended numeric, currency, date or
   *       :    datetime type property.
   * Return: The incremented property value if successful,
   *       :    otherwise logical .NULL.
   * Update: Version 1.0
   *  Notes: tnIncValue is optional.
   *       :    If not passed, the extended property is incremented by 1.
   *       :    To decrement, pass a negative number.
   *       : This wrapper method calls uGetProp(), increments,
   *       :    and calls uSetProp().

      LOCAL llExecTime
      IF THIS.rlExecTime
         llExecTime = .T.
         * Shut off timer so calling exposed functions won't change.
         THIS.rlExecTime = .F.
         THIS.nExecTime  = SECONDS()
      ENDIF

      LOCAL lnIncValue,;
            llPropLock,;
            luReturn
      lnIncValue = IIF(PARAMETERS()==4, tnIncValue, 1)

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
      * Other parameters are checked by uGetProp() and uSetProp().
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() < 3
            ERROR cnVF_ERR_PARAM_TOOFEW
         CASE PARAMETERS() == 4 AND;
              (ISNULL("tnIncValue") OR NOT TYPE("tnIncValue")=="N")
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         THIS.rlExecTime = llExecTime
         RETURN luReturn  && early exit
      ENDIF

      * Use pessimistic locking to prevent any change to the
      * incremented property in the very short time we have it.
      llPropLock = THIS.rlPropLock
      THIS.rlPropLock = .T.  && lock EDC record in uGetProp()

      * Get property and check type.
      luReturn = THIS.uGetProp(@tcObjectName, @tcObjectType,;
                               @tcPropertyName)
      DO CASE  && of property errors
         CASE NOT (THIS.aObjectError[cnVF_AERR_NUMBER] == 0 OR;
                   THIS.rlPropLock)
            * Error, not found, or not locked.
            luReturn = .NULL.
         CASE NOT TYPE("luReturn") $ "NYDT"
            * Not numeric, currency, date, or datetime.
            ERROR cnVF_ERR_PROP_DATATYPE
            luReturn = .NULL.
      ENDCASE  && of property errors
      THIS.rlPropLock = llPropLock

      IF ISNULL(luReturn) OR EMPTY(lnIncValue)
         UNLOCK RECORD RECNO(THIS.rcEdcAlias) IN THIS.rcEdcAlias
      ELSE  && increment and set the property
         luReturn = luReturn + lnIncValue
         IF NOT THIS.uSetProp(@tcObjectName, @tcObjectType,;
                              @tcPropertyName, @luReturn)  && unlocks EDC
            luReturn = .NULL.
         ENDIF
      ENDIF

      IF llExecTime
         THIS.nExecTime  = SECONDS() - THIS.nExecTime
         THIS.rlExecTime = .T.
      ENDIF
      RETURN luReturn
   ENDFUNC && uIncProp *****************************************


   FUNCTION cAnalyzeDbcProp(tcCursorName, tcCursorType, tcAction)
   * Action: Create a cursor or table with one memo field that
   *       :    contains a readable string of the DBC property
   *       :    field including its binary codes.
   * Return: Name of the created cursor or table.
   * Update: Version 1.0 (beta 2a)
   *  Notes: All parameters are optional.  If no cursor name is
   *       :    passed, a unique alias name is used.
   *       : To create a table instead of a cursor, pass "table"
   *       :    in tcCursorType.
   *       : To view the DBC and cursor in a related browse,
   *       :    pass "browse" in tcAction.  To include empty
   *       :    property records, pass "browse all" in tcAction.
   *       : The cursor contains the same number of records as
   *       :    the DBC, and each one has the same record number
   *       :    as the DBC.
   *       : Deleted records are included and marked deleted.

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS()
      ENDIF

      LOCAL lcAlias,;
            lnCounter,;
            llDeleted,;
            lcLast,;
            lcOrder,;
            llTemp,;
            lnSelect,;
            lnStart,;
            lcString
      lcAlias = ""  && return value

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of parameter checking
         CASE NOT THIS.rlTestParameters
            * Do nothing.
         CASE PARAMETERS() >= 1 AND;
              (ISNULL(tcCursorName) OR NOT TYPE("tcCursorName")=="C")
            ERROR cnVF_ERR_PARAM_INVALID
         CASE PARAMETERS() >= 2 AND;
              (ISNULL(tcCursorType) OR NOT TYPE("tcCursorType")=="C")
            ERROR cnVF_ERR_PARAM_INVALID
         CASE PARAMETERS() == 3 AND;
              (ISNULL(tcAction) OR NOT TYPE("tcAction")=="C")
            ERROR cnVF_ERR_PARAM_INVALID
      ENDCASE  && of parameter checking
      DO CASE  && of setup
         CASE NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE ISNULL(THIS.rcDbcAlias) OR NOT USED(THIS.rcDbcAlias)
            =THIS.cOpenDbc()
      ENDCASE  && of setup
      IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         DO CASE  && of alias names
            CASE EMPTY(tcCursorName)
               lcAlias = SYS(cnVF_SYS_UNIQUEID)
            CASE USED(ALLTRIM(tcCursorName))
               lcAlias = ALLTRIM(tcCursorName)
               USE IN (lcAlias)
            OTHERWISE
               lcAlias = ALLTRIM(tcCursorName)
         ENDCASE  && of alias names
      ELSE
         RETURN lcAlias  && early exit
      ENDIF

      * Create cursor or table.
      lnSelect = SELECT()
      SELECT 0
      IF (NOT EMPTY(tcCursorType)) AND;
            LOWER(ALLTRIM(tcCursorType)) == "table"
         llTemp = SET("SAFETY")=="ON"
         IF FILE(LEFT(THIS.rcDbcFullPath,;
                      RAT("\", THIS.rcDbcFullPath)) + lcAlias+".dbf")
            IF THIS.Message.nShow(IDYES,;
                         STRTRAN(THIS.rcMsgOverwriteFile,;
                                  ccMSG_INSERT1,;
                                  SYS(cnVF_SYS_CROSSPATH,;
                                      LEFT(THIS.rcDbcFullPath,;
                                           RAT("\",;
                                               THIS.rcDbcFullPath))+;
                                      lcAlias+".dbf")),;
                          MB_YESNO+MB_ICONQUESTION+MB_DEFBUTTON2,;
                          THIS.rcMsgBoxTitle) == IDNO
               SELECT (lnSelect)
               RETURN ""  && early exit
            ENDIF
            SET SAFETY OFF
         ENDIF
         THIS.aObjectError[cnVF_AERR_NUMBER] = 0
         CREATE TABLE (LEFT(THIS.rcDbcFullPath,;
                            RAT("\", THIS.rcDbcFullPath))+lcAlias) FREE;
                      (cxANALYZE_FIELD M)
         IF llTemp
            SET SAFETY ON
         ENDIF
         IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            SELECT (lnSelect)
            RETURN ""  && early exit
         ENDIF
      ELSE
         CREATE CURSOR (lcAlias) (cxANALYZE_FIELD M)
      ENDIF  && table or cursor

      llDeleted = SET("DELETED")=="ON"
      SET DELETED OFF
      SELECT (THIS.rcDbcAlias)
      lcOrder = ORDER()
      SET ORDER TO
      THIS.aObjectError[cnVF_AERR_NUMBER] = 0

      SCAN  && DBC
         lcString = ""
         lnStart = 1
         DO WHILE lnStart < LEN(Property)
            lnSize = ASC(SUBSTR(Property, lnStart,   1))+;
                    (ASC(SUBSTR(Property, lnStart+1, 1))*256)+;
                    (ASC(SUBSTR(Property, lnStart+2, 1))*256^2)+;
                    (ASC(SUBSTR(Property, lnStart+3, 1))*256^3)
            lcString = lcString+;
                       STR(ASC(SUBSTR(Property, lnStart,   1)), 3)+;
                       STR(ASC(SUBSTR(Property, lnStart+1, 1)), 3)+;
                       STR(ASC(SUBSTR(Property, lnStart+2, 1)), 3)+;
                       STR(ASC(SUBSTR(Property, lnStart+3, 1)), 3)+;
                       STR(ASC(SUBSTR(Property, lnStart+4, 1)), 3)+;
                       STR(ASC(SUBSTR(Property, lnStart+5, 1)), 3)+;
                       STR(ASC(SUBSTR(Property, lnStart+6, 1)), 3)
            IF BETWEEN(ASC(SUBSTR(Property, lnStart+7, 1)), 33, 126)
               lcString = lcString+;
                          SUBSTR(Property, lnStart+7, lnSize-8)
            ELSE
               FOR lnCounter = lnStart+7 TO (lnStart+7)+(lnSize-8)-1
                  lcString = lcString+;
                         STR(ASC(SUBSTR(Property, lnCounter, 1)),3)
               ENDFOR
            ENDIF
            lcString = lcString+;
                       STR(ASC(SUBSTR(Property, lnStart+lnSize-1, 1)), 3)+;
                       ccCRLF
            lnStart = lnStart + lnSize
         ENDDO WHILE lnStart < LEN(Property)

         INSERT INTO (lcAlias) VALUES (lcString)
         IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            EXIT
         ENDIF
         IF DELETED(THIS.rcDbcAlias)
            DELETE IN (lcAlias)
         ENDIF
      ENDSCAN  && DBC

      DO CASE  && of actions
         CASE EMPTY(tcAction) OR;
              NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            * Do nothing.
         CASE LOWER(LEFT(LTRIM(tcAction),6)) == "browse"
            GO 1  && natural order
            SET RELATION TO RECNO() INTO (lcAlias)
            llTemp = SET("MULTILOCKS")=="ON"
            SET MULTILOCKS ON
            lnCounter = CURSORGETPROP("buffering")
            =CURSORSETPROP("buffering", DB_BUFOPTRECORD)
            BROWSE FIELDS ObjectID,;
                          ParentID,;
                          ObjectType,;
                          ObjectName,;
                          Property,;
                          &lcAlias..cxANALYZE_FIELD;
                   VALID:F IIF("2" $ GETFLDSTATE(-1),;
                               TABLEREVERT()==1, .T.);
                   NODELETE NOAPPEND LAST;
                   FOR LOWER(RIGHT(TRIM(tcAction),3)) == "all" OR;
                       NOT EMPTY(Property)
            SET RELATION TO
            =CURSORSETPROP("buffering", lnCounter, THIS.rcDbcAlias)
            IF NOT llTemp
               SET MULTILOCKS OFF
            ENDIF
      ENDCASE  && of actions

      * Clean up.
      IF NOT EMPTY(lcOrder)
         SET ORDER TO (lcOrder)
      ENDIF
      IF llDeleted
         SET DELETED ON
      ENDIF
      SELECT (lnSelect)

      IF THIS.rlExecTime
         THIS.nExecTime = SECONDS() - THIS.nExecTime
      ENDIF
      RETURN lcAlias
   ENDFUNC && cAnalyzeDbcProp **********************************


   **********************************************************
   * Protected Properties
   **********************************************************
   * These are initialized in the class body instead of the Init
   * event so that a subclass can access them with the :: class
   * resolution operator.

   * Default behavior.  Use exposed methods to access.
   PROTECTED rlExecTime,;
             rlPropLock,;
             rlShowErrors,;
             rlShowMessages,;
             rlTestParameters
   * rlExecTime         = .F.  && true puts exposed methods' execution;
                               &&    time in nExecTime property
   * rlPropLock         = .F.  && true locks the EDC record when property;
                               &&    is read.  Stores result of LOCK().
   rlShowErrors         = .T.  && show errors (false shows error as message)
   rlShowMessages       = .T.  && show all messages and prompts
   rlTestParameters     = .T.  && test all exposed methods' parameters

   * Files.  Use exposed methods to access.  Dynamic internal use only.
   PROTECTED raAlternate[1, cnALT_COLUMNS],;
             rcDbcAlias,;
             rcDbcFullPath,;
             rcBoundAlias,;
             rcBoundFullPath,;
             rcEdcAlias,;
             rcEdcField,;
             rcEdcFullPath,;
             raObject[1, cnOBJ_COLUMNS],;
             rcRegAlias,;
             rcRegFullPath
   rcDbcAlias       = .NULL.  && lOpen() sets to unique internal name
   rcDbcFullPath    = .NULL.  && lOpen() sets to DBC's full path spec
   rcBoundAlias     = .NULL.  && lOpen() sets to bound DBC's alias
   rcBoundFullPath  = .NULL.  && lOpen() sets to bound DBC's full path spec
   rcEdcAlias       = .NULL.  && lOpen() sets to unique internal name
   rcEdcField       = .NULL.  && lOpen() sets to uppercase passed name
   rcEdcFullPath    = .NULL.  && lOpen() sets to EDC's full path spec
   rcRegAlias       = .NULL.  && lOpen() sets to EDC's alias if alternate EDC
   rcRegFullPath    = .NULL.  && lOpen() sets to EDC's path if alternate EDC
   raAlternate      = .NULL.  && lOpen() fills with alternate EDC's to be updated
   raObject         = .NULL.  && lOpen() fills with alternate methods for updating

   * EDC file extension.  Subclass to change.
   PROTECTED rcEdcFileExt
   rcEdcFileExt         = "EDC"

   * ADBOBJECTS("RELATION") array and update time,
   * so we don't have to fetch it unless it changes.
   *///beta 3: performance test this and keep only if we're faster.
   PROTECTED raRelation[1],;
             rtRelation
   rtRelation           = CTOT("")

   * Names.  Subclass to change.
   PROTECTED rcLineName,;
             rcMapName,;
             rcMethodName,;
             rcReserveName,;
             rcSourceName,;
             rcTypeName
   rcLineName           = "Line"
   rcMapName            = "Map"
   rcMethodName         = "Method"
   rcReserveName        = "reserved character or keyword"
   rcSourceName         = "Source"
   rcTypeName           = "type"

   * Extended property delimiters and limits.  Subclass to change.
   PROTECTED rcLineMark,;
             rcPropMark,;
             rcPropHead,;
             rnMaxPropLen,;
             rnMaxStrLen
   rcLineMark           = ccCRLF+"~"+ccCRLF  && separates properties
   rcPropMark           = " ~~ "  && separates property name from value header
   rnMaxPropLen         =  128    && no real limit, set anywhere
   rnMaxStrLen          = 4096    && no real limit, set anywhere

*///example structure for visual descriptions
*>* rnMaxStrLen,;
Maximum property string length.  No real limit, set anywhere.

   * Extended object limits.  Subclass to change.
   * Note that rnObjectNameSize + rnObjectTypeSize cannot exceed
   * the VFP limit of 240 on index key length.
   PROTECTED rnObjectNameSize,;
             rnObjectTypeSize
   rnObjectNameSize     =  128    && max 240 with rnObjectTypeSize
   rnObjectTypeSize     =   10    && max 240 with rnObjectNameSize

   * Unique ID prefix string.  Subclass to change.
   PROTECTED rcUniqueIdentifier
   rcUniqueIdentifier   = "DO NOT REMOVE THIS LINE! EDC ID: "

   * Messages (non-error).  Subclass to change.
   PROTECTED rcMsgAddField,;
             rcMsgBoxTitle,;
             rcMsgCreateEdc,;
             rcMsgOverwriteFile,;
             rcMsgRemoveField
   rcMsgAddField        = "Extended database file " + ccMSG_INSERT1 +;
                          " does not have a "       + ccMSG_INSERT2 +;
                          " field.  Add it?"
   rcMsgBoxTitle        = "Extended Database Container"
   rcMsgCreateEdc       = "Extended database file " + ccMSG_INSERT1 +;
                          " does not exist.  Create it?"
   rcMsgOverwriteFile   = ccMSG_INSERT1 + " already exists, "+;
                          "overwrite it?"
   rcMsgRemoveField     = 'Remove the field "' + ccMSG_INSERT1 +;
                          '" from the file '   + ccMSG_INSERT2 +;
                          "?  All its extended properties will be lost."

   * Error messages.  Subclass to change.
   PROTECTED rcErrorEdcInvalid,;
             rcErrorEdcNotOpen,;
             rcErrorFieldLock,;
             rcErrorFieldMax,;
             rcErrorFieldNameLen,;
             rcErrorMarkConflict,;
             rcErrorNameLineMark,;
             rcErrorNamePropMark,;
             rcErrorPropNameLen,;
             rcErrorTitle,;
             rcErrorValueLineMark
   rcErrorEdcInvalid    = ccMSG_INSERT1 + " is not a valid EDC file."
   rcErrorEdcNotOpen    = "Use lOpen() to open the extended database."
   rcErrorFieldLock     = "Field " + ccMSG_INSERT1 + " is locked."
   rcErrorFieldMax      = "The maximum allowable number of fields, "+;
                          LTRIM(STR(cnVF_FIELD_MAXCOUNT))+;
                          ", has been reached.  You can remove one "+;
                          "with lRemoveField() or set the registry "+;
                          "property, ccEDC_REG_ALTERNATE, to create "+;
                          "another EDC file."
   rcErrorFieldNameLen  = "Extended field name cannot exceed "+;
                          LTRIM(STR(cnVF_FIELD_MAXNAMELEN)) + " characters."
   rcErrorMarkConflict  = "The property and separator marks conflict.  "+;
                          "Neither can contain the other."
   rcErrorNameLineMark  = "Property name cannot contain "+;
                          "the line separator mark."
   rcErrorNamePropMark  = "Property name cannot contain "+;
                          "the property separator mark."
   rcErrorPropNameLen   = "Property name " + ccMSG_INSERT1 + " is too long."
   rcErrorTitle         = "Extended Database Container Error"
   rcErrorValueLineMark = "Property value string cannot contain "+;
                          "the line separator mark."


   **********************************************************
   * Protected event methods
   **********************************************************

   PROTECTED PROCEDURE Error(tnError, tcMethod, tnLine)
   * Action: Process errors triggered by instances of this class.
   * Update: Version 1.0
   *  Notes: If this event is subclassed, the subclass MUST
   *       :    call this event or update THIS.aObjectError because
   *       :    other methods test THIS.aObjectError[cnVF_AERR_NUMBER]
   *       :    to see if an error occurred.

      * Set instance error array and add elements for the
      * method name, line number, and source code.
      =AERROR(THIS.aObjectError)  && sets first six elements
      DIMENSION THIS.aObjectError[cnAERR_MAX]
      THIS.aObjectError[cnAERR_METHOD] = tcMethod
      THIS.aObjectError[cnAERR_LINE  ] = tnLine
      THIS.aObjectError[cnAERR_SOURCE] = MESSAGE(1)

      DO CASE  && of showing errors
         CASE NOT THIS.rlShowErrors
            * Show error as a message.
            =THIS.Message.nShow(0,;
                                THIS.aObjectError[cnVF_AERR_MESSAGE]+;
                                   CHR(13)+CHR(13)+;
                                THIS.rcMethodName + ": "+;
                                   LOWER(LEFT(tcMethod,1))+;
                                   PROPER(SUBSTR(tcMethod,2))+CHR(13)+;
                                THIS.rcLineName + ": "+;
                                   LTRIM(STR(tnLine))+CHR(13)+;
                                THIS.rcSourceName+": "+;
                                   MESSAGE(1),;
                             MB_OK+MB_ICONEXCLAMATION,;
                             THIS.rcErrorTitle)

         CASE TYPE("THIS.PARENT") == "O"
            * Turn it over to our parent's error event.
            * We have no way to tell if our parent really has an
            *    error method defined.  If not, passing this error
            *    won't show at all.
            =THIS.PARENT.Error(tnError, tcMethod, tnLine)

         CASE NOT (EMPTY(ON("ERROR")) OR TYPE(ON("ERROR"))=="U")
            * Trigger the ON ERROR expression.
            * This works only when ON ERROR is an expression like
            *    ON ERROR =MyErrorHandler().
            =EVALUATE(ON("ERROR"))

         OTHERWISE
            * Trigger the raw VFP error event.
            * This works without ON ERROR, or when ON ERROR is
            *    a command like ON ERROR DO MyErrorHandler.
            * For details, test the exposed property, aObjectError[].
            ERROR tnError,;
                  NVL(THIS.aObjectError[cnVF_AERR_OBJECT], "")
      ENDCASE  && of showing errors
   ENDPROC && Error ********************************************
*///example structure for visual descriptions
*>* Error,;
Handles object errors.  See also aObjectError, lShowErrors.


   PROTECTED FUNCTION Init()
   * Action: Check that protected properties do not conflict
   *       :    from subclassing errors.
   * Update: Version 1.0
   *  Notes: Data types are not checked.
      LOCAL llReturn
      DO CASE  && of checking protected properties
         CASE THIS.rcLineMark $ THIS.rcPropMark OR;
              THIS.rcPropMark $ THIS.rcLineMark
            ERROR THIS.rcErrorMarkConflict
         OTHERWISE
            llReturn = .T.
      ENDCASE  && of checking protected properties
      RETURN llReturn
   ENDFUNC && Init *********************************************


   PROTECTED PROCEDURE Destroy()
   * Action: Close object's files when the object is destroyed.
   * Update: Version 1.0
      =THIS.Close()
   ENDPROC && Destroy ******************************************


   **********************************************************
   * Protected non-event methods
   **********************************************************

   PROTECTED FUNCTION uConvertProp(tcString)
   * Action: Convert extended property string by type and value.
   * Return: Converted property value if successful,
   *       :    otherwise logical null.
   * Update: Version 1.0
   *  Notes: Tests the property, cPropHead, for info.

      LOCAL llNullFlag,;
            lcPropertyType,;
            luReturn

      * Get the data type, null flag, and property value string.
      lcPropertyType = LEFT(THIS.cPropHead, cnHEAD_TYPE)
      llNullFlag = SUBSTR(THIS.cPropHead, cnHEAD_NULL, 1) == ccHEAD_ON

      DO CASE  && of property type conversions
*///if types are defined in FoxPro.h, use those instead.
         CASE lcPropertyType == "C"  && character
            IF llNullFlag
               luReturn = ""
               luReturn = .NULL.
            ELSE
               luReturn = tcString
            ENDIF
         CASE lcPropertyType == "D"  && date
            IF llNullFlag
               luReturn = DATE()
               luReturn = .NULL.
            ELSE
               luReturn = CTOD(tcString)
            ENDIF
         CASE lcPropertyType == "T"  && datetime
            IF llNullFlag
               luReturn = DATETIME()
               luReturn = .NULL.
            ELSE
               luReturn = CTOT(tcString)
            ENDIF
         CASE lcPropertyType == "L"  && logical
            IF llNullFlag
               luReturn = .NULL.
            ELSE
               luReturn = EVALUATE(tcString)
            ENDIF
         CASE lcPropertyType == "N"  && numeric
            * Double, Integer, and Float have distinction in tables only.
            * VFP treats them as numeric internally and in variables.
            IF llNullFlag
               luReturn = 0
               luReturn = .NULL.
            ELSE
               luReturn = EVALUATE(tcString)
            ENDIF
         CASE lcPropertyType == "Y"  && currency
            IF llNullFlag
               luReturn = $0
               luReturn = .NULL.
            ELSE
               luReturn = NTOM(EVALUATE(tcString))
            ENDIF
         OTHERWISE  && unknown property type
            ERROR cnVF_ERR_PROP_DATATYPE
            luReturn = .NULL.
      ENDCASE  && of property type conversions
      RETURN luReturn
   ENDFUNC && uConvertProp *************************************


   PROTECTED FUNCTION cGetUniqueID()
   * Action: Get EDC's unique object ID from the DBC.
   * Return: Unique ID if there is one, otherwise an empty string.
   * Update: Version 1.0
   *  Notes: Expects to be on the correct DBC record.
      LOCAL lnPosition
      lnPosition = AT(THIS.rcUniqueIdentifier,;
                      EVALUATE(THIS.rcDbcAlias+".User"))
      RETURN IIF(lnPosition==0, "",;
                 SUBSTR(EVALUATE(THIS.rcDbcAlias+".User"),;
                        lnPosition + LEN(THIS.rcUniqueIdentifier),;
                        LEN(SYS(cnVF_SYS_UNIQUEID))))
   ENDFUNC && cGetUniqueID *************************************


   PROTECTED FUNCTION cSetUniqueID()
   * Action: Set a unique EDC object ID to a DBC object.
   * Return: Existing ID if there is one, or the new ID set.
   *       :    Returns an empty string if the set fails.
   * Update: Version 1.0
   *  Notes: Expects to be on the correct DBC record.
   *       : Never changes an ID that already exists.

      LOCAL lcReturn
      lcReturn = THIS.cGetUniqueID()

      IF EMPTY(lcReturn)
         lcReturn = SYS(cnVF_SYS_UNIQUEID)
         THIS.aObjectError[cnVF_AERR_NUMBER] = 0
         IF LOCK(THIS.rcDbcAlias)
            REPLACE User;
               WITH User + ccCRLF +;
                    THIS.rcUniqueIdentifier + lcReturn + ccCRLF;
                 IN THIS.rcDbcAlias
            UNLOCK RECORD RECNO(THIS.rcDbcAlias) IN THIS.rcDbcAlias
            IF NOT THIS.aObjectError[cnVF_AERR_NUMBER] == 0
               lcReturn = ""
            ENDIF
         ELSE
            lcReturn = ""
         ENDIF
      ENDIF
      RETURN lcReturn
   ENDFUNC && cSetUniqueID *************************************


   PROTECTED FUNCTION lSearchDbc(tcObjectName, tcObjectType)
   * Action: Search the DBC for an object.
   * Return: True if found, otherwise false.
   * Update: Version 1.0
   *  Notes: Positions DBC record pointer to the found record.
   *       : Does not change the record pointer if not found.

      LOCAL lcObjectName1,;
            lcObjectName2,;
            lcObjectType,;
            lnRecno,;
            llReturn
      lnRecno = IIF(EOF(THIS.rcDbcAlias),;
                    .NULL., RECNO(THIS.rcDbcAlias))

      * Format parameters.
      lcObjectType = PADR(PROPER(LTRIM(tcObjectType)),;
                          FSIZE("ObjectType", THIS.rcDbcAlias))
      IF "." $ tcObjectName
         lcObjectName1 = PADR(LOWER(LTRIM(LEFT(tcObjectName,;
                                               RAT(".",tcObjectName)-1))),;
                              FSIZE("ObjectName", THIS.rcDbcAlias))
         lcObjectName2 = PADR(LOWER(LTRIM(SUBSTR(tcObjectName,;
                                               RAT(".",tcObjectName)+1))),;
                              FSIZE("ObjectName", THIS.rcDbcAlias))
      ELSE
         lcObjectName1 = PADR(LOWER(LTRIM(tcObjectName)),;
                              FSIZE("ObjectName", THIS.rcDbcAlias))
         lcObjectName2 = ""
      ENDIF

      * Locate correct record by object type and name.
      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE  && of object types
         CASE lcObjectType == ccVF_OBJ_DATABASE OR;
              lcObjectType == ccVF_OBJ_TABLE OR;
              lcObjectType == ccVF_OBJ_VIEW OR;
              lcObjectType == ccVF_OBJ_CONNECTION
            * The database, tables, views, and connections
            * all have the database as a parent.
            llReturn = SEEK(STR(1) + lcObjectType + lcObjectName1,;
                            THIS.rcDbcAlias, "ObjectName")

         CASE lcObjectType == ccVF_OBJ_INDEX OR;
              lcObjectType == ccVF_OBJ_RELATION
            * Indexes and relations have only a table as a parent.
            llReturn = SEEK(STR(1) + ccVF_OBJ_TABLE + lcObjectName1,;
                            THIS.rcDbcAlias, "ObjectName") AND;
                       SEEK(STR(EVALUATE(THIS.rcDbcAlias+".ObjectID"))+;
                            lcObjectType + lcObjectName2,;
                            THIS.rcDbcAlias, "ObjectName")

         CASE lcObjectType == ccVF_OBJ_FIELD
            * Fields can have either a table or view as a parent.
            llReturn = (SEEK(STR(1) + ccVF_OBJ_TABLE + lcObjectName1,;
                             THIS.rcDbcAlias, "ObjectName") OR;
                        SEEK(STR(1) + ccVF_OBJ_VIEW + lcObjectName1,;
                             THIS.rcDbcAlias, "ObjectName")) AND;
                       SEEK(STR(EVALUATE(THIS.rcDbcAlias+".ObjectID"))+;
                            lcObjectType + lcObjectName2,;
                            THIS.rcDbcAlias, "ObjectName")

         OTHERWISE  && unknown object type
            ERROR cnVF_ERR_DB_OBJNOTFOUND,;
                  THIS.rcTypeName +" "+ ALLTRIM(tcObjectType)
      ENDCASE  && of object types

      IF NOT llReturn
         IF NOT ISNULL(lnRecno)
            GO lnRecno IN THIS.rcDbcAlias
         ENDIF
         IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
            ERROR cnVF_ERR_DB_OBJNOTFOUND, ALLTRIM(tcObjectName)
         ENDIF
      ENDIF

      RETURN llReturn
   ENDFUNC && lSearchDbc ***************************************


   PROTECTED PROCEDURE SetRegistryDefault()
   * Action: Set registry default properties.
   * Update: Version 1.0
   *  Notes: Registry default properties are set with the
   *       : cnHEAD_REMOVELOCK switch turned on.
      LOCAL laRegistry[cnEDC_REG_DEFAULT, 3]

      * Field creation date.
      laRegistry[ 1, 1] = ccEDC_REG_CREATE
      laRegistry[ 1, 2] = DATETIME()

      * Relative path back to DBC.
      laRegistry[ 2, 1] = ccEDC_REG_DBC
      laRegistry[ 2, 2] = IIF(ISNULL(THIS.rcDbcAlias),;
                              "",;
                              SYS(cnVF_SYS_RELATIVEPATH,;
                                  THIS.rcDbcFullPath,;
                                  THIS.rcEdcFullPath))

      * EDC Version.
      laRegistry[ 3, 1] = ccEDC_REG_VERSION
      laRegistry[ 3, 2] = ccEDC_VERSION

      * Alternate EDC file.
      laRegistry[ 4, 1] = ccEDC_REG_ALTERNATE
      laRegistry[ 4, 2] = ""

      * Remove lock disables lRemoveField().
      laRegistry[ 5, 1] = ccEDC_REG_REMOVELOCK
      laRegistry[ 5, 2] = .T.

      * Extension and vendor names.
      laRegistry[ 6, 1] = ccEDC_REG_EXTENSIONNAME
      laRegistry[ 6, 2] = ""
      laRegistry[ 7, 1] = ccEDC_REG_VENDORNAME
      laRegistry[ 7, 2] = ""

      * Foreign methods to use instead of EDC's.
      laRegistry[ 8, 1] = ccEDC_REG_METHODLIB
      laRegistry[ 8, 2] = ""
      laRegistry[ 9, 1] = ccEDC_REG_METHODCLASS
      laRegistry[ 9, 2] = ""
      laRegistry[10, 1] = ccEDC_REG_METHODINIT
      laRegistry[10, 2] = ""
      laRegistry[11, 1] = ccEDC_REG_METHODOPEN
      laRegistry[11, 2] = ""
      laRegistry[12, 1] = ccEDC_REG_METHODGET
      laRegistry[12, 2] = ""
      laRegistry[13, 1] = ccEDC_REG_METHODSET
      laRegistry[13, 2] = ""

      * Lock the remove flag, and set all.
      THIS.rcPropHead = STUFF(REPLICATE(ccHEAD_OFF, cnHEAD_SWITCHSIZE),;
                              cnHEAD_REMOVELOCK, 1, ccHEAD_ON)
      =THIS.uSetProp(ccEDC_OBJ_REGISTRY, ccEDC_OBJ_UNIQUETYPE,;
                     ccALL, @laRegistry)
   ENDPROC && SetRegistryDefault *******************************


   PROTECTED FUNCTION cSetArg(tcMethod,        tcObjectName,;
                              tcObjectType,    tcPropertyName,;
                              tcPropertyValue, tcDbcUniqueId)
      LOCAL lcMethod,;
            lcPropertyType,;
            lcString

      lcMethod = tcMethod  && return string with substituted arguments

      IF ATC(ccARG_DBC, lcMethod) > 0
         * Passed database name takes priority.
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_DBC, lcMethod),;
                          LEN(ccARG_DBC),;
                          IIF("!" $ tcObjectName,;
                              '"'+LEFT(tcObjectName,;
                                       AT("!", tcObjectName)-1)+'"',;
                              IIF(ISNULL(THIS.rcDbcFullPath),;
                                  '""', '"'+THIS.rcDbcFullPath+'"')))
      ENDIF
      IF ATC(ccARG_DBCID, lcMethod) > 0
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_DBCID, lcMethod),;
                          LEN(ccARG_DBCID),;
                          IIF(EMPTY(tcDbcUniqueId),;
                              '""', '"'+tcDbcUniqueId+'"'))
      ENDIF
      IF ATC(ccARG_EDC, lcMethod) > 0
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_EDC, lcMethod),;
                          LEN(ccARG_EDC),;
                          IIF(ISNULL(THIS.rcEdcFullPath),;
                              '""', '"'+THIS.rcEdcFullPath+'"'))
      ENDIF
      IF ATC(ccARG_REGISTRY, lcMethod) > 0
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_REGISTRY, lcMethod),;
                          LEN(ccARG_REGISTRY),;
                          IIF(ISNULL(THIS.rcRegFullPath),;
                              '""', '"'+THIS.rcRegFullPath+'"'))
      ENDIF
      IF ATC(ccARG_OBJTYPE, lcMethod) > 0
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_OBJTYPE, lcMethod),;
                          LEN(ccARG_OBJTYPE),;
                          '"'+tcObjectType+'"')
      ENDIF
      IF ATC(ccARG_OBJNAME, lcMethod) > 0
         * Remove passed database name if any.
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_OBJNAME, lcMethod),;
                          LEN(ccARG_OBJNAME),;
                          IIF("!" $ tcObjectName,;
                              '"'+SUBSTR(tcObjectName,;
                                         AT("!", tcObjectName)+1)+'"',;
                              '"'+tcObjectName+'"'))
      ENDIF
      IF ATC(ccARG_PROPNAME, lcMethod) > 0
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_PROPNAME, lcMethod),;
                          LEN(ccARG_PROPNAME),;
                          '"'+tcPropertyName+'"')
      ENDIF
      IF ATC(ccARG_PROPVALUE, lcMethod) > 0
         lcPropertyType = TYPE("tuPropertyValue")
         lcString = THIS.cValueToString(@tcPropertyName,;
                                        @tcPropertyValue,;
                                        @lcPropertyType)
         IF lcPropertyType == "C"
            lcString = '"'+lcString+'"'
         ENDIF
         lcMethod = STUFF(lcMethod,;
                          ATC(ccARG_PROPVALUE, lcMethod),;
                          LEN(ccARG_PROPVALUE),;
                          lcString)
      ENDIF
      RETURN lcMethod
   ENDFUNC && cSetArg ******************************************


   PROTECTED FUNCTION lOpenEdc(tcEdcField)
   * Action: Open or create the EDC table.
   * Return: True if successful, otherwise false.
   * Update: Version 1.0
   *  Notes: Prompts to create the EDC if it doesn't exist.
   *       : Prompts to add the extended field to the EDC
   *       :    if it doesn't exist.
   *       : Called from the exposed function lOpen().
   *       : Uses THIS.rcEdcFullPath.
   *       : Sets THIS.rcEdcAlias and THIS.rcEdcField.

      LOCAL lnCounter,;
            lcEdcField,;
            lcOldAlias,;
            lcOldField,;
            llReturn,;
            lnSelect

      lnSelect   = SELECT()
      lcEdcField = UPPER(ALLTRIM(tcEdcField))

      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      THIS.rcEdcAlias = SYS(cnVF_SYS_UNIQUEID)

      IF NOT FILE(THIS.rcEdcFullPath)
         IF THIS.Message.nShow(IDYES,;
                               STRTRAN(THIS.rcMsgCreateEdc,;
                                       ccMSG_INSERT1,;
                                       SYS(cnVF_SYS_CROSSPATH,;
                                           THIS.rcEdcFullPath)),;
                               MB_YESNO+MB_ICONQUESTION,;
                               THIS.rcMsgBoxTitle) == IDYES
            SELECT 0
            CREATE TABLE (THIS.rcEdcFullPath) FREE;
               (cxEDC_ID     C(10) UNIQUE,;
                cxEDC_OBJ    M,;
                &lcEdcField. M)  && macro alert

            * Add registry row.
            IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
               INSERT INTO (ALIAS()) (cxEDC_ID);
                    VALUES (ccEDC_OBJ_REGISTRY)
            ENDIF

            * Add tag for user defined objects.
            IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
               lcOldField = STR(THIS.rnObjectTypeSize + THIS.rnObjectNameSize)
               INDEX ON PADR(LOWER(cxEDC_OBJ), &lcOldField);
                     FOR NOT EMPTY(cxEDC_OBJ);
                     CANDIDATE TAG cxEDC_OBJ   && macro alert
            ENDIF

            * Set default system and extension registry properties.
            IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
               IF ISNULL(THIS.rcRegAlias)
                  * This main EDC is also the EDC registry.
                  THIS.rcRegFullPath = THIS.rcEdcFullPath
                  THIS.rcRegAlias    = THIS.rcEdcAlias
               ENDIF
               lcOldAlias = THIS.rcEdcAlias
               lcOldField = THIS.rcEdcField
               THIS.rcEdcAlias = ALIAS()
               THIS.rcEdcField = ccEDC_OBJ
               =THIS.SetRegistryDefault()  && system
               THIS.rcEdcField = lcEdcField
               =THIS.SetRegistryDefault()  && extension
               THIS.rcEdcField = lcOldField
               THIS.rcEdcAlias = lcOldAlias
               USE  && so will open shared with THIS.rcEdcAlias below
            ENDIF
         ELSE  && message reply don't create
            STORE .NULL. TO THIS.rcEdcAlias, THIS.rcEdcField
            RETURN llReturn  && early exit
         ENDIF  && message
      ENDIF  && new file
      IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0 AND;
            NOT USED(THIS.rcEdcAlias)
         USE (THIS.rcEdcFullPath) AGAIN IN SELECT(1);
             ALIAS (THIS.rcEdcAlias)
      ENDIF
      IF NOT (THIS.aObjectError[cnVF_AERR_NUMBER] == 0 AND;
              USED(THIS.rcEdcAlias))
         STORE .NULL. TO THIS.rcEdcAlias, THIS.rcEdcField
         RETURN llReturn  && early exit
      ENDIF

      * Make sure we've got a real EDC table.
      IF NOT (FIELD(1, THIS.rcEdcAlias) == UPPER(ccEDC_ID)  AND;
              FIELD(2, THIS.rcEdcAlias) == UPPER(ccEDC_OBJ) AND;
              SEEK(ccEDC_OBJ_REGISTRY, THIS.rcEdcAlias, ccEDC_ID))
         ERROR STRTRAN(THIS.rcErrorEdcInvalid,;
                       ccMSG_INSERT1, SYS(cnVF_SYS_CROSSPATH,;
                                          THIS.rcEdcFullPath))
         STORE .NULL. TO THIS.rcEdcAlias, THIS.rcEdcField
         RETURN llReturn  && early exit
      ENDIF

      * Check for extended field and create if it doesn't exist.
      SELECT (THIS.rcEdcAlias)  && no more early exits
      FOR lnCounter = cnEDC_FIXEDFIELDS+1 TO FCOUNT()
         IF FIELD(lnCounter) == lcEdcField
            llReturn = .T.
            EXIT
         ENDIF
      ENDFOR
      DO CASE  && of extended field options
         CASE llReturn
            THIS.rcEdcField = lcEdcField
         CASE FCOUNT() == cnVF_FIELD_MAXCOUNT
            ERROR THIS.rcErrorFieldMax
         CASE THIS.Message.nShow(IDYES,;
                         STRTRAN(STRTRAN(THIS.rcMsgAddField,;
                                         ccMSG_INSERT1,;
                                         SYS(cnVF_SYS_CROSSPATH,;
                                             THIS.rcEdcFullPath)),;
                                 ccMSG_INSERT2, lcEdcField),;
                         MB_YESNO+MB_ICONQUESTION,;
                         THIS.rcMsgBoxTitle) == IDYES
            IF NOT ISEXCLUSIVE()
               USE (THIS.rcEdcFullPath) EXCLUSIVE ALIAS (THIS.rcEdcAlias)
            ENDIF
            IF ISEXCLUSIVE()
               ALTER TABLE (THIS.rcEdcFullPath);
                  ADD COLUMN &lcEdcField M  && macro alert
               IF SET("EXCLUSIVE")=="OFF"
                  USE (THIS.rcEdcFullPath) AGAIN ALIAS (THIS.rcEdcAlias)
               ENDIF
               llReturn = THIS.aObjectError[cnVF_AERR_NUMBER] == 0 AND;
                          USED(THIS.rcEdcAlias)
               IF llReturn
                  * Set field and default extension registry properties.
                  THIS.rcEdcField = lcEdcField
                  IF ISNULL(THIS.rcRegAlias)
                     * This main EDC is also the EDC registry.
                     THIS.rcRegFullPath = THIS.rcEdcFullPath
                     THIS.rcRegAlias    = THIS.rcEdcAlias
                  ENDIF
                  =THIS.SetRegistryDefault()
               ENDIF
            ELSE
               ERROR cnVF_ERR_EXCLUSIVE
            ENDIF
      ENDCASE  && of extended field options

      IF NOT llReturn
         STORE .NULL. TO THIS.rcEdcAlias, THIS.rcEdcField
      ENDIF
      SELECT (lnSelect)
      RETURN llReturn
   ENDFUNC && lOpenEdc *****************************************


   PROTECTED FUNCTION cOpenDbc(tcDbc)
   * Returns full path spec.
      LOCAL lcFullPath,;
            llFullPath
      THIS.aObjectError[cnVF_AERR_NUMBER] = 0
      DO CASE
         CASE PARAMETERS()==1
            * If FreeEdc the changes stick, if not they don't.
            OPEN DATABASE (tcDbc)
         CASE EMPTY(DBC())
            IF THIS.rlShowMessages
               lcFullPath = GETFILE("dbc")
            ENDIF
            IF EMPTY(lcFullPath)
               ERROR cnVF_ERR_DB_NOTOPEN
            ELSE
               OPEN DATABASE (lcFullPath)
            ENDIF
      ENDCASE
      IF THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         llFullPath = SET("FULLPATH")=="ON"
         SET FULLPATH ON
         THIS.rcDbcAlias = SYS(cnVF_SYS_UNIQUEID)
         USE DBC() AGAIN IN SELECT(1) ALIAS (THIS.rcDbcAlias)
         *///need to protect in quotes at time of use for Macintosh.
         STORE DBC() TO lcFullPath, THIS.rcDbcFullPath
         IF NOT llFullPath
            SET FULLPATH OFF
         ENDIF
      ELSE
         lcFullPath = ""
      ENDIF
      RETURN lcFullPath
   ENDFUNC && cOpenDbc *****************************************            


   PROTECTED FUNCTION cGetOneDbcProp(tcPropertyType)
   * Expects DBC row already found by caller.
      LOCAL lcProperty,;
            lcReturn,;
            lnSize,;
            lnStart
      lcProperty = EVALUATE(THIS.rcDbcAlias + ".Property")
      lcReturn   = ""
      lnStart    = 1
      DO WHILE lnStart < LEN(lcProperty)
         * Read the property size.
         lnSize = ASC(SUBSTR(lcProperty, lnStart,   1))+;
                 (ASC(SUBSTR(lcProperty, lnStart+1, 1))*256)+;
                 (ASC(SUBSTR(lcProperty, lnStart+2, 1))*256^2)+;
                 (ASC(SUBSTR(lcProperty, lnStart+3, 1))*256^3)

         * Read the property value if property type matches.
         IF SUBSTR(lcProperty,;
                   lnStart +5+ (ASC(SUBSTR(lcProperty,lnStart+4,1)) % 2),;
                   ASC(SUBSTR(lcProperty, lnStart+4, 1))) == tcPropertyType
            lcReturn = SUBSTR(lcProperty, lnStart+7, MAX(1, lnSize-8))
            EXIT  && once we've got the property
         ENDIF

         lnStart = lnStart + lnSize  && next property
      ENDDO WHILE lnStart < LEN(lcProperty)
      RETURN lcReturn
   ENDFUNC && cGetOneDbcProp ***********************************


   PROTECTED FUNCTION lSetOneDbcProp(tcPropertyType, tcPropertyValue)
   * Expects DBC row already found by caller.
      LOCAL lcProperty,;
            llReturn,;
            lnSize,;
            lnStart,;
            lcString
      lcProperty = EVALUATE(THIS.rcDbcAlias + ".Property")

      lnStart    = 1
      DO WHILE lnStart < LEN(lcProperty)
         * Read the property size.
         lnSize = ASC(SUBSTR(lcProperty, lnStart,   1))+;
                 (ASC(SUBSTR(lcProperty, lnStart+1, 1))*256)+;
                 (ASC(SUBSTR(lcProperty, lnStart+2, 1))*256^2)+;
                 (ASC(SUBSTR(lcProperty, lnStart+3, 1))*256^3)

         * Write the property value if property type matches.
         IF SUBSTR(lcProperty,;
                   lnStart +5+ (ASC(SUBSTR(lcProperty,lnStart+4,1)) % 2),;
                   ASC(SUBSTR(lcProperty, lnStart+4, 1))) == tcPropertyType
            llReturn = .T.
            EXIT  && once we've found the property
         ENDIF

         lnStart = lnStart + lnSize  && next property
      ENDDO WHILE lnStart < LEN(lcProperty)

      IF llReturn
         * Format the new property string if necessary.
         * ///Case sensitivity is still under investigation.
         DO CASE  && of formatting properties
            CASE tcPropertyType == ccVF_TAB_FILEPATH
               LOCAL llFullPath
               llFullPath = SET("FULLPATH")=="ON"
               SET FULLPATH ON
               * Format relative path to DBC.
               lcString = LOWER(SYS(cnVF_SYS_RELATIVEPATH,;
                                    ALLTRIM(tcPropertyValue),;
                                    THIS.rcDbcFullPath))
               IF NOT llFullPath
                  SET FULLPATH OFF
               ENDIF

            CASE INLIST(tcPropertyType, ccVF_VIE_COMMAND)
               * No formatting.
               lcString = ALLTRIM(tcPropertyValue)

            OTHERWISE
               * Format lowercase.
               lcString = LOWER(ALLTRIM(tcPropertyValue))
         ENDCASE  && of formatting properties

         * Set new size and wrap the string in property code.
         lnNewSize = LEN(lcString) + IIF(lnSize == 8, 7, 8)
         lcString  = CHR(lnNewSize%256)+;
                     CHR(lnNewSize/256)+;
                     CHR(lnNewSize/256^2)+;
                     CHR(lnNewSize/256^3)+;
                     SUBSTR(lcProperty, lnStart+4, 3)+;
                     lcString+;
                     IIF(lnSize == 8, "",;
                         SUBSTR(lcProperty, lnStart+lnSize-1, 1))

         IF LOCK(THIS.rcDbcAlias)  && write the property
            THIS.aObjectError[cnVF_AERR_NUMBER] = 0
            REPLACE Property;
               WITH LEFT(lcProperty, lnStart-1)+;
                    lcString+;
                    IIF(lnStart+lnSize < LEN(lcProperty),;
                        SUBSTR(lcProperty, lnStart+lnSize), "");
                 IN THIS.rcDbcAlias
            UNLOCK RECORD RECNO(THIS.rcDbcAlias) IN THIS.rcDbcAlias
            llReturn = THIS.aObjectError[cnVF_AERR_NUMBER] == 0
         ELSE
            llReturn = .F.
         ENDIF
      ENDIF  && llReturn
      RETURN llReturn
   ENDFUNC && lSetOneDbcProp ***********************************


   PROTECTED PROCEDURE SetSameName(tcObjectName,   tcObjectType,;
                                   tcPropertyName, tuPropertyValue,;
                                   tnAction,       tnParameters,;
                                   tcSearchString, tcSearchOrder,;
                                   tcDbcUniqueId)
   * Action: Set one extended property in all EDC fields in current row.
   *  Notes: Called by uSetProp().
   *       : Expects the row to be explicitly locked.
   *       : tnParameters is the number of parameters passed to uSetProp().
   *       : Sets property header by THIS.rcPropHead if not empty.

      LOCAL lnCounter,;
            lcEdcAlias,;
            lcEdcField,;
            lnPosition,;
            lcProperty,;
            lcString
      lcEdcAlias = THIS.rcEdcAlias
      lcEdcField = THIS.rcEdcField

      FOR lnCounter = cnEDC_FIXEDFIELDS+1 TO FCOUNT(THIS.rcRegAlias)
         THIS.rcEdcField = FIELD(lnCounter, THIS.rcRegAlias)
         IF THIS.rcEdcField == lcEdcField
            LOOP
         ENDIF

         * If an alternate method is present, translate the arguments,
         * call the method, and loop.
         lnPosition = ASCAN(THIS.raObject,;
                            ccMSG_INSERT1 + THIS.rcEdcField +;
                            ccMSG_INSERT1) 
         IF lnPosition > 0
            lnPosition = ASUBSCRIPT(THIS.raObject, lnPosition, 1)
            lcString = THIS.cSetArg(THIS.raObject[lnPosition,;
                                                  cnOBJ_SETMETHOD],;
                                    @tcObjectName,    @tcObjectType,;
                                    @tcPropertyName,  @tuPropertyValue,;
                                    @tcDbcUniqueId)
            * Execute the alternate method instead of ours.
            =THIS.raObject[lnPosition,;
                           cnOBJ_OBJECT].&lcString  && macro alert
            LOOP
         ENDIF

         * Is it an alternate EDC?
         lnPosition = ASCAN(THIS.raAlternate,;
                            PADR(THIS.rcEdcField, cnVF_FIELD_MAXNAMELEN))
         IF lnPosition == 0  && not an alternate EDC
            THIS.rcEdcAlias = lcEdcAlias
         ELSE
            * Change alias to alternate EDC.
            THIS.rcEdcAlias =;
                 THIS.raAlternate[ASUBSCRIPT(THIS.raAlternate,;
                                             lnPosition, 1),;
                                  cnALT_ALIAS]
            * Search for the object in the alternate EDC.
            IF NOT SEEK(tcSearchString,;
                        THIS.rcEdcAlias,;
                        tcSearchOrder)
               LOOP
            ENDIF
         ENDIF

         * Check if the property exists.
         lcProperty = EVALUATE(THIS.rcEdcAlias +"."+ THIS.rcEdcField)
         lnPosition = ATC(THIS.rcLineMark+;
                             ALLTRIM(tcPropertyName)+;
                             THIS.rcPropMark,;
                          lcProperty)
         IF lnPosition > 0
            * Get full property string without leading line mark.
            lcString =;
               SUBSTR(lcProperty,;
                      lnPosition+LEN(THIS.rcLineMark),;
                      AT(THIS.rcLineMark,;
                         SUBSTR(lcProperty,;
                                lnPosition+LEN(THIS.rcLineMark),;
                                THIS.rnMaxPropLen+;
                                   THIS.rnMaxStrLen+;
                                   LEN(THIS.rcPropMark)))-1)
            * Check property header for allowing update.
            IF SUBSTR(lcString,;
                      LEN(THIS.rcPropMark)+;
                         LEN(ALLTRIM(tcPropertyName))+;
                         cnHEAD_UPDATE,;
                      1) == ccHEAD_ON AND;
               SUBSTR(lcString,;
                      LEN(THIS.rcPropMark)+;
                         LEN(ALLTRIM(tcPropertyName))+;
                         cnHEAD_WRITELOCK,;
                      1) == ccHEAD_OFF
               * Pass lcProperty to avoid another fetch.
               =THIS.lEdcSetProp(@tcPropertyName,;
                                 @tuPropertyValue,;
                                 @tnAction,;
                                 @tnParameters,;
                                 @lcProperty)
            ENDIF  && can update
         ENDIF  && same name exists
      ENDFOR  && all fields
      THIS.rcEdcAlias = lcEdcAlias
      THIS.rcEdcField = lcEdcField
   ENDPROC && SetSameName **************************************


   PROTECTED FUNCTION lEdcSetProp(tcPropertyName, tuPropertyValue,;
                                  tnAction, tnParameters, tcProperty)
   * Action: Set one extended property.
   * Return: True if successful, otherwise false.
   *  Notes: Called by uSetProp().
   *       : Expects the row to be explicitly locked.
   *       : tnParameters is the number of parameters passed to uSetProp().
   *       : tcProperty is optional.

      LOCAL lnCounter,;
            llFullPath,;
            lnPosition,;
            lcProperty,;
            lcPropertyType,;
            llReturn,;
            lcString,;
            lcValueString

      * Get entire property field into memory if not passed.
      lcProperty = IIF(EMPTY(tcProperty),;
                       EVALUATE(THIS.rcEdcAlias + "." + THIS.rcEdcField),;
                       tcProperty)

      * Get position of property header.
      lnPosition = ATC(THIS.rcLineMark + ALLTRIM(tcPropertyName)+;
                       THIS.rcPropMark, lcProperty)
      IF lnPosition == 0
         lcString = ""
         THIS.cPropHead = REPLICATE(ccHEAD_OFF, cnHEAD_SWITCHSIZE)
      ELSE
         * lcString is whole property line.
         lcString = SUBSTR(lcProperty,;
                           lnPosition+LEN(THIS.rcLineMark),;
                           AT(THIS.rcLineMark,;
                              SUBSTR(lcProperty,;
                                     lnPosition+LEN(THIS.rcLineMark),;
                                     THIS.rnMaxPropLen+;
                                        THIS.rnMaxStrLen+;
                                        LEN(THIS.rcPropMark)))-1)
         THIS.cPropHead = SUBSTR(lcString,;
                                 LEN(ALLTRIM(tcPropertyName))+;
                                     LEN(THIS.rcPropMark) + 1,;
                                 cnHEAD_SWITCHSIZE)
      ENDIF

      * Create/set header only, or remove property.
      IF tnParameters == 5
         IF tnAction == cnPROP_REMOVE  && remove property
            IF SUBSTR(THIS.cPropHead, cnHEAD_REMOVELOCK, 1) == ccHEAD_ON
               ERROR cnVF_ERR_PROP_READONLY, ALLTRIM(tcPropertyName)
               lcValueString = .NULL.
            ELSE
               lcValueString = IIF(lnPosition==0, .NULL., "")
            ENDIF
         ELSE  && set header
            * Create new header or update existing one.
            * New property setting header has logical value.
            THIS.cPropHead =;
               IIF(lnPosition == 0,;
                   "L" + ccHEAD_ON+;
                      SUBSTR(THIS.cPropHead, cnHEAD_READLOCK),;
                   LEFT(THIS.cPropHead, tnAction-1)+;
                      tuPropertyValue+;
                      SUBSTR(THIS.cPropHead, tnAction+1))+;
               PADR(DATETIME(), cnHEAD_TIMESIZE)
            lcValueString =;
               RIGHT(lcString, LEN(lcString)-;
                               (LEN(ALLTRIM(tcPropertyName))+;
                                LEN(THIS.rcPropMark)+;
                                cnHEAD_SIZE))
         ENDIF  && remove property or set header
      ELSE  && parameters < 5, so create or set property
         lcPropertyType = TYPE("tuPropertyValue")

         * Preset property header.
         IF NOT EMPTY(THIS.rcPropHead)
            FOR lnCounter = cnHEAD_READLOCK TO cnHEAD_SWITCHSIZE
               IF NOT EMPTY(SUBSTR(THIS.rcPropHead, lnCounter, 1))
                  THIS.cPropHead =;
                     STUFF(THIS.cPropHead, lnCounter, 1,;
                           SUBSTR(THIS.rcPropHead, lnCounter, 1))
               ENDIF
            ENDFOR
         ENDIF

         * Property header.
         THIS.cPropHead =;
            lcPropertyType+;
            IIF(ISNULL(tuPropertyValue), ccHEAD_ON, ccHEAD_OFF)+;
            SUBSTR(THIS.cPropHead, cnHEAD_READLOCK, cnHEAD_SWITCHSIZE-2)+;
            PADR(DATETIME(), cnHEAD_TIMESIZE)

         * Convert property value to string by data type.
         DO CASE  && of adding property value to string
            CASE SUBSTR(THIS.cPropHead,cnHEAD_WRITELOCK,1)==ccHEAD_ON
               ERROR cnVF_ERR_PROP_READONLY, ALLTRIM(tcPropertyName)
               lcValueString = .NULL.
            CASE ISNULL(tuPropertyValue)
               * Store nothing beyond header.
               lcValueString = ""
            OTHERWISE  && convert value to string
               lcValueString = THIS.cValueToString(@tcPropertyName,;
                                                   @tuPropertyValue,;
                                                   @lcPropertyType)
         ENDCASE
      ENDIF  && header or property

      * Reset rcPropHead unless flagged not to.
      IF NOT (EMPTY(THIS.rcPropHead) OR;
              SUBSTR(THIS.rcPropHead, cnHEAD_TYPE, 1) == ccHEAD_ON)
         THIS.rcPropHead  = ""
      ENDIF

      * Write new string.
      IF NOT ISNULL(lcValueString)  && error or remove non-exist
         * Make registry file paths relative to the DBC or registry EDC.
         IF ATC(ALLTRIM(tcPropertyName), ccEDC_REG_LISTFILES) > 0 ;
              AND NOT EMPTY(lcValueString)
            llFullPath = SET("FULLPATH")=="ON"
            SET FULLPATH ON
            lcValueString = LOWER(SYS(cnVF_SYS_RELATIVEPATH,;
                                      FULLPATH(lcValueString),;
                                      NVL(THIS.rcDbcFullPath,;
                                          THIS.rcRegFullPath)))
            IF NOT llFullPath
               SET FULLPATH OFF
            ENDIF
         ENDIF

         * Add property header and marks to start of property value.
         lcValueString = THIS.rcLineMark+;
                         ALLTRIM(tcPropertyName)+;
                         THIS.rcPropMark+;
                         THIS.cPropHead+;
                         lcValueString

         THIS.aObjectError[cnVF_AERR_NUMBER] = 0
         IF lnPosition == 0  && add new property to end
            REPLACE (THIS.rcEdcField);
               WITH IIF(RIGHT(lcProperty,;
                              LEN(THIS.rcLineMark))==THIS.rcLineMark,;
                        SUBSTR(lcValueString, LEN(THIS.rcLineMark)+1),;
                        lcValueString)+;
                    THIS.rcLineMark;
               ADDITIVE;
               IN THIS.rcEdcAlias
         ELSE                && update existing property
            REPLACE (THIS.rcEdcField);
               WITH LEFT(lcProperty, lnPosition-1)+;
;
                    lcValueString +;
;
                    RIGHT(lcProperty,;
                          LEN(lcProperty)-;
                          ((lnPosition-2)+;
                           LEN(THIS.rcLineMark)+;
                           AT(THIS.rcLineMark,;
                              SUBSTR(lcProperty,;
                                     lnPosition+;
                                        LEN(THIS.rcLineMark),;
                                     THIS.rnMaxPropLen+;
                                        THIS.rnMaxStrLen+;
                                        LEN(THIS.rcPropMark)))));
                 IN THIS.rcEdcAlias
         ENDIF  && new or update property
         llReturn = THIS.aObjectError[cnVF_AERR_NUMBER] == 0
      ENDIF  && write new string
      RETURN llReturn
   ENDFUNC && lEdcSetProp **************************************


   PROTECTED FUNCTION cValueToString(tcPropertyName, tuPropertyValue,;
                                     tcPropertyType)  && type is optional
      LOCAL lnCounter,;
            lcPropertyType,;
            lcValueString  && return string
      lcPropertyType = IIF(EMPTY(tcPropertyType),;
                           TYPE("tuPropertyValue"), tcPropertyType)

      * Convert property value to string by data type.
      DO CASE  && of adding property value to string
         CASE ISNULL(tuPropertyValue)
            * The call from uGetProp() is skipped on a null value.
            * This is here for stuffing into foreign set methods.
            lcValueString = ".NULL."
         CASE lcPropertyType == "C"    && character
            DO CASE  && of property string errors and fix ups
               CASE LEN(tuPropertyValue) > THIS.rnMaxStrLen
                  ERROR cnVF_ERR_STR_TOOLONG
                  lcValueString = .NULL.
               CASE THIS.rcLineMark $ tuPropertyValue
                  ERROR THIS.rcErrorValueLineMark
                  lcValueString = .NULL.
               CASE ATC(ALLTRIM(tcPropertyName),;
                        ccEDC_REG_LISTDBF) > 0 AND;
                    NOT EMPTY(tuPropertyValue)
                  lcValueString = ALLTRIM(tuPropertyValue)
                  IF NOT ("." $ lcValueString AND;
                          LEN(lcValueString) -;
                          RAT(".", lcValueString) < 4)  && max extension size 3
                     lcValueString = lcValueString + ".DBF"
                  ENDIF
               CASE ATC(ALLTRIM(tcPropertyName),;
                        ccEDC_REG_LISTVCX) > 0 AND;
                    NOT EMPTY(tuPropertyValue)
                  lcValueString = ALLTRIM(tuPropertyValue)
                  IF NOT ("." $ lcValueString AND;
                          LEN(lcValueString) -;
                          RAT(".", lcValueString) < 4)  && max extension size 3
                     lcValueString = lcValueString + ".VCX"
                  ENDIF
               OTHERWISE
                  lcValueString = tuPropertyValue
            ENDCASE  && of property string errors and fix ups
         CASE lcPropertyType == "D"    && date
            lcValueString = DTOC(tuPropertyValue)
         CASE lcPropertyType == "T"    && datetime
            lcValueString = PADR(tuPropertyValue, cnHEAD_TIMESIZE)
         CASE lcPropertyType == "L"    && logical
            lcValueString = IIF(tuPropertyValue, ".T.", ".F.")
         CASE lcPropertyType == "Y"    && currency
            *///beta 2a bug??? currency ignores SET DECIMALS
            *///recheck in beta 3; might want to get rid of decimals
            lcValueString = LTRIM(STR(tuPropertyValue, 32, 4))
         CASE lcPropertyType == "N"    && numeric
            * Double, Integer, and Float have distinction in tables only.
            * Internally VFP treats them as simply numeric.
            IF tuPropertyValue == INT(tuPropertyValue)
               lcValueString = LTRIM(STR(tuPropertyValue))
            ELSE  && not an integer
               lcValueString = LTRIM(STR(tuPropertyValue,;
                                         cnVF_NUM_MAXPRECISION * 2,;
                                         cnVF_NUM_MAXPRECISION))
               * Eliminate trailing decimal zeros.
               FOR lnCounter = LEN(lcValueString) TO 1 STEP -1
                  IF NOT SUBSTR(lcValueString, lnCounter, 1) == "0"
                     EXIT
                  ENDIF
               ENDFOR
               lcValueString = LEFT(lcValueString, lnCounter)
            ENDIF
         OTHERWISE  && unknown or invalid data type
            ERROR cnVF_ERR_PROP_DATATYPE
            lcValueString = .NULL.
      ENDCASE  && of adding property value to string
      RETURN lcValueString
   ENDFUNC && cValueToString ***********************************

ENDDEFINE && CLASS cxCLASS_EDC *********************************


DEFINE CLASS cxCLASS_MSG AS Custom
* Separate class so it can be subclassed or substituted.
* Contains no properties and only one method, nShow(), exposed.

   FUNCTION nShow(tnReturn, tcMessage, tnDialogType, tcTitleText)
   * Action: Show message.
   * Return: Result of MESSAGEBOX(), or tnReturn if
   *       :    rlShowMessages is false.
   * Update: Version 1.0
   *  Notes: Pass tnReturn the value you want returned if the
   *       :    parent method lGetShowMessages() returns false.
   *       : Last three parameters are the same as MESSAGEBOX().
   *       : Last two parameters are optional.
   *       : Requires parent object have the method lGetShowMessages().
      LOCAL lnReturn
      lnReturn = PARAMETERS()
      DO CASE  && of showing message
         CASE NOT THIS.PARENT.lGetShowMessages()
            lnReturn = tnReturn  && no type checking
         CASE lnReturn == 4
            lnReturn = MESSAGEBOX(tcMessage, tnDialogType, tcTitleText)
         CASE lnReturn == 3
            lnReturn = MESSAGEBOX(tcMessage, tnDialogType)
         CASE lnReturn == 2
            lnReturn = MESSAGEBOX(tcMessage)
         OTHERWISE
            ERROR cnVF_ERR_PARAM_TOOFEW
            lnReturn = .NULL.
      ENDCASE  && of showing message
      RETURN lnReturn
   ENDFUNC && nShow ********************************************

ENDDEFINE && CLASS cxCLASS_MSG *********************************

*** EdcLib.prg **********************************************
