* IT.PRG

*
* "talk" status is a special case
*
if set("talk") == "ON"
 set talk off
 m.glTalkIsOn = .T.
else
 m.glTalkIsOn = .F.
endif

m.gnTimeBegin  = seco()

*
* save current environment
*
m.gcOldCent = set("century")
m.gcOldClas = set("classlib")
m.gcOldDele = set("delete")
m.gcOldEsca = set("escape")
m.gcOldExac = set("exact")
m.gcOldExcl = set("exclusive")
m.gcOldMult = set("multilocks")
m.gcOldProc = set("procedure")
m.gcOldRepr = set("reprocess")
m.gcOldSafe = set("safety")
m.gcOldStat = set("status bar")
m.gcOldHelp = set("help",1)
m.gcOldReso = sys(2005)
m.gcOldOnEr = on("error")

*
* clean out everything
*
release all except g*
close all
clear menu
clear popu
clear wind
clear

*
* initialize various system attributes
*
* eventually we will have routines for 
* - reading system attributes from an "INI" file
* - accessing multiple data sets
m.gcNameSystem = "The Borg"
m.gcDefDataLoc = curdir()

*
* set up outside resources
*
*\\\set classlib to 
*\\\set help to 
*\\\set procedure to
*\\\set resource to

*
* do environment and configuration check
*
*\\\ enough RAM?
*\\\ enough disk space
*\\\ # of files in config.sys 
*\\\ high enough value of MVCOUNT in config.fpw
*\\\ existence of specific startup files


*
* - accepting user logins with the appropriate security
*
m.gcNameUser   = "Herman"
m.gcPermLevel  = "AAAAA"
m.gcExitMethod = ""

*
* set up "ON" conditions
*
if m.gcPermLevel = "AAAAA"
*\\\ on error
else
*\\\ on error
endif
if m.gcPermLevel = "AAAAA"
 set escape on
else
 set escape off
 on escape *
endi


*
* set up regular and user-defined help files
*
*\\\set help to <help file>
*\\\on key labe F1 HELP
*\\\on key labe F2 do <user-defined help>

*
* key assignments
*
on key labe F3
on key labe F4
on key labe F5
on key labe F6
on key labe F7
on key labe F8
on key labe F9
on key labe F10
on key labe F11
on key labe F12

*
* define environment
*
set century on
set clock status
set deleted on
set exact off
set exclusive off
set multilocks on
set reprocess to 5
set safety off

*
* set up screen, menu, and event handler
*
modify window screen font "FoxFont", 7 noclose title m.gcNameSystem + " (" + allt(m.gcDefDataLoc) + " Data)"
push menu _msysmenu
m.cexp = ["" + Font 'Courier']

do IT.MPR
wait wind nowait "Welcome to " + m.gcNameSystem + ", " + m.gcNameUser + ". You are attached to the " + allt(m.gcDefDataLoc) + " data set. Elapsed time was " + allt(str(seco() - m.gnTimeBegin,5,3)) + " seconds" 
read events
pop menu _msysmenu to master
set sysmenu to default
modify window screen font "Foxfont",9 noclose title "Microsoft Visual FoxPro"

*
* return the environment to the way it was
*
set century &gcOldCent
set classlib to &gcOldClas
set deleted &gcOldDele
set escape &gcOldEsca
set exact &gcOldExac
set exclusive &gcOldExcl
set multilocks &gcOldMult
set procedure to &gcOldProc
set reprocess to (gcOldRepr)
set safety &gcOldSafe
set status bar &gcOldStat
if !empty(m.gcOldHelp)
 set help to &gcOldHelp
endif
if !empty(m.gcOldReso) 
 set resource to &gcOldReso
endif
if !empty(m.gcOldOnEr)
 on error (gcOldOnEr)
endif

*
* clean out rest of app
*

clos all
clea menu
clea popu
clea prog
clea wind
clea

if m.glTalkIsOn
 set talk on
endif

do case
case m.gcExitMethod = "VFP"
 wait wind nowa "See you next time"
 clea memo
 return
case m.gcExitMethod = "OS"
 @2,0 say "See you next time"
 clea memo
 quit
endcase

* <EOF>
