* bldclass.prg
*
* when the user drags a field from the DE, VFP's base classes are used
*
* this builder will allow the user to drag a field from the DE but
* then will perform the following operations on the newly created control
* - autosize
* - autoname
* - change the baseclass from VFP to one in BASECTRL.VCX
*
* this builder will
* - automatically run if builder lock is on
* - or run when you select the Builder menu option
*
* toObject is a reference to the selected object 
* when the builder was called
*
* tcHowCalled =
*  "TOOLBOX" if the builder was called as a result of the
*    builder lock being on
*  "RTMOUSE" if the builder was called by selecting the
*    'Builder' menu option from the control's shortcut menu
*

lparameter toObject, tcHowCalled

local lcWAOri, lcFontName, lnFontSize, lcStyle
local lcControlSource, lcNaTable, lcNaField, lnWidth
local lcObjectName, lcNaField
local lcName, lcCaption, lnTop, lnLeft, lnHeight


*
* autosize if it's a textbox, checkbox or label
*
* if a textbox 
*  - there must be a ControlSource 
*  - the ControlSource must have a period in it (there's
*    a table in the ControlSource property)
*  - the size will be the length of the ControlSource
*
* if a checkbox
*  - there must be a ControlSource 
*  - the ControlSource must have a period in it (there's
*    a table in the ControlSource property)
*  - the length will be the caption
*
* if a label
*  - the length will be the caption
*
* otherwise
*  - bag it
*  
*
lcFontName = toObject.FontName
lnFontSize = toObject.FontSize
lcStyle = ;
   iif ( toObject.FontStrikethru, "-", "" ) ;
 + iif ( toObject.FontBold, "B", "" ) ;
 + iif ( toObject.FontItalic, "I", "" ) ;
 + iif ( toObject.FontOutline, "O-", "" ) ;
 + iif ( toObject.FontShadow, "S", "" ) ;
 + iif ( toObject.FontUnderline, "U", "" ) 
if empty(lcStyle)
 lcStyle = "N"
endif

do case
case upper( toObject.baseclass ) = "TEXTBOX" or upper( toObject.baseclass ) = "CHECKBOX" 

 lcControlSource = toObject.ControlSource
 lcNaTable = left( lcControlSource, at(".", lcControlSource) - 1)
 lcNaField = subs( lcControlSource, at(".", lcControlSource) + 1 )

 if empty( toObject.ControlSource ) or !( "." $ lcControlSource )
  wait window "Autosize not avaiable - this control has no ControlSource property"
 else

  m.lcWAOri = alias()

  select 0
  use &lcNaTable alias xGETSIZE again
 
  if upper( toObject.baseclass ) = "TEXTBOX"
   lnWidth = fsize( lcNaField ) + 2

  else
   * 4 is fudge factor for the checkbox itself
   lnWidth = len(allt(toObject.Caption)) + 4
  endif

  toObject.Width = fontmetric( ;
   6, ;
   lcFontName, ;
   lnFontSize, ;
   lcStyle) ;
   * lnWidth
 endif

 if used("xGETSIZE")
  use in xGETSIZE
 endif

 if !empty( lcWAOri )
  select &lcWAOri
 endif


case upper( toObject.baseclass ) = "LABEL"
 lcName = toObject.Caption
 lnWidth = len(allt(toObject.Caption))

  toObject.Width = fontmetric( ;
   6, ;
   lcFontName, ;
   lnFontSize, ;
   lcStyle) ;
   * lnWidth

endcase


*
* create a name based on the VFP baseclass and the field or caption
* 

*
* initialize the prefix
*
lcNaPrefix = ""

*
* create a prefix
*
do case
case upper( toObject.baseclass ) = "TEXTBOX"
 lcNaPrefix = "txt" 
case upper( toObject.baseclass ) = "EDITBOX"
 lcNaPrefix = "edt" 
case upper( toObject.baseclass ) = "CHECKBOX"
 lcNaPrefix = "chk" 
case upper( toObject.baseclass ) = "COMMANDBUTTON"
 lcNaPrefix = "cmd" 
case upper( toObject.baseclass ) = "LISTBOX"
 lcNaPrefix = "lst" 
case upper( toObject.baseclass ) = "COMBOBOX"
 lcNaPrefix = "cbo" 
case upper( toObject.baseclass ) = "COLUMN"
 lcNaPrefix = "col" 
case upper( toObject.baseclass ) = "SPINNER"
 lcNaPrefix = "spn" 
case upper( toObject.baseclass ) = "LABEL"
 lcNaPrefix = "lbl" 
case upper( toObject.baseclass ) = "TIMER"
 lcNaPrefix = "tmr" 
case upper( toObject.baseclass ) = "SHAPE"
 lcNaPrefix = "shp" 
endcase

*
* concatenate the prefix with the original name
* note that if the control was not found above,
* the prefix is simply empty
*
lcName = lcNaPrefix + lcNaField
toObject.Name = lcName

*
* change the class
*
* --> assumes BASECTRL.VCX is available
*

set classlib to BASECTRL.VCX

*
* save the properties of the original control
*
oForm = toObject.parent
lcName = toObject.Name
*
* some controls don't have a caption property 
* and others just may not have one
*
if type("toObject.caption") = "U"
 lcCaption = .NULL.
else
 lcCaption = toObject.Caption
endif

lnTop = toObject.Top
lnLeft = toObject.Left
lnHeight = toObject.Height

*
* there are only three types controls created
* when we drag from the DE
*
* however, we might have called the builder via shortcut
*
do case
case upper( toObject.BaseClass ) = "TEXTBOX"
 lcClass = "txtbase"
case upper( toObject.BaseClass ) = "EDITBOX"
 lcClass = "edtbase"
case upper( toObject.BaseClass ) = "CHECKBOX"
 lcClass = "chkbase"
case upper( toObject.BaseClass ) = "LABEL"
 lcClass = "lblbase"
case upper( toObject.baseclass ) = "COMMANDBUTTON"
 lcClass = "cmdbase"
case upper( toObject.baseclass ) = "LISTBOX"
 lcClass = "lstbase"
case upper( toObject.baseclass ) = "COMBOBOX"
 lcClass = "cbobase"
case upper( toObject.baseclass ) = "SPINNER"
 lcClass = "spnbase"
case upper( toObject.baseclass ) = "TIMER"
 lcClass = "tmrbase"
case upper( toObject.baseclass ) = "SHAPE"
 lcClass = "shpbase"
otherwise
 wait wind "This type of control doesn't have a mapping in the builder!"
endcase

*
* get rid of the original control
*
oForm.RemoveObject(lcName)

*
* add a new control based on our custom class
*
oForm.AddObject(lcName, lcClass)

*
* using the properties of the original control,
* set up this new control
*
toObject = oForm.&lcName
if !isnull( lcCaption )
 toObject.Caption = lcCaption
endif

if !empty(lcControlSource)
  toObject.ControlSource = lcControlSource
endif

toObject.Top = lnTop
toObject.Left = lnLeft
toObject.Height = lnHeight
toOBject.Width = lnWidth
toObject.Visible = .T.
oForm.Refresh()

