VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CWindow"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CWindow
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 1, 1995
' Opis:         Genericka klasa prozora koja
'               obavlja osnovne operacije sa
'               obrascima i kontrolama
'
' Izmene:
'
Option Explicit

Const lERR_CLEAR = vbObjectError + 515
Const lERR_SELECT = vbObjectError + 516
Const lERR_GET = vbObjectError + 517


' PUBLIC: *****************************************
' Javni clanovi

' Kada se ovo svojstvo postavi prozor se postavlja
' na vrh
Public Property Let OnTop(frmTop As Form, bSetOnTop As Boolean)
    If bSetOnTop = True Then
      ' Postavi prozor na vrh
      Call SetWindowPos(frmTop.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)
    Else
      ' Nemoj ga postaviti na vrh
      Call SetWindowPos(frmTop.hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)
    End If
End Property

' PRIVATE: *****************************************
' Privatni clanovi

' Centrira obrazac.
' Ako je u pitanju mdi obrazac, cetrira ga u mdi
' roditelju.
' Inace, centrira ga na ekranu
' Parametri:
'  frmCenter      Obrazac koji se centrira
Public Sub Center(frm As Form)
Dim lHeight, lWidth, lOffset, tOffset
   If frm.MDIChild = True Then
      lHeight = frm.Parent.ScaleHeight
      lWidth = frm.Parent.ScaleWidth
   Else
      lHeight = Screen.Height
      lWidth = Screen.Width
   End If

   ' Levi pomeraj
   lOffset = ((lWidth - frm.Width) / 2)
   
   ' Gornji pomeraj
   tOffset = ((lHeight - frm.Height) / 2)

   ' Centriraj obrazac
   frm.Move lOffset, tOffset
End Sub

' Standardna procedura Copy
' Moze se prosiriti da podrzi vise tipova
' clipboard-a
Public Sub EditCopy()
    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Obrisi clipboard
    Clipboard.Clear
    If Err.Number Then
        Err.Raise lERR_CLEAR, "CApplication", "Greska u brisanju clipboarda."
    Else
        ' Stavi izabran tekst na clipboard
        Clipboard.SetText Screen.ActiveControl.SelText
        If Err.Number Then
            Err.Raise lERR_SELECT, "CApplication", "Greska u postavljanju teksta u clipboard."
        End If
    End If
End Sub




' Standardna procedura Cut
' Moze se prosiriti da podrzi razlicite
' tipove clipboard-a
Public Sub EditCut()
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Ocisti clipboard
    Clipboard.Clear
    If Err.Number Then
        Err.Raise lERR_CLEAR, "CApplication", "Greska kod ciscenja clipboard-a."
    Else
        ' Odabrani tekst se smesta u clipboard
        Clipboard.SetText Screen.ActiveControl.SelText
        Screen.ActiveControl.SelText = ""
        If Err.Number Then
            MsgBox Err.Description
            Err.Raise lERR_SELECT, "CApplication", "Greska prilikom smestanja teksta u clipboard."
        End If
    End If

End Sub

' Standardna procedura Paste
' Moze se poboljsati da podrzi vise
' tipova clipboard-a
Public Sub EditPaste()
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Stavi tekst sa clipboarda u
    ' odabranu kontrolu
    Screen.ActiveControl.SelText = Clipboard.GetText()
    If Err.Number Then
        Err.Raise lERR_GET, "CApplication", "Could not set text from clipboard to active control."
    End If
 
End Sub

