VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CSalesPerson"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CSalesPerson
' Autor:        Deborah Kurata
' Datum:        June 1, 1995
' Opis:         Klasa prodavca. Ovo je najvisa
'               klasa aplikacije

Option Explicit

' PUBLIC: ******************************************
' Javni clanovi podaci

' PRIVATE: *****************************************
' Privatni clanovi podaci

' Sifra prodavca
Private m_lUserID As Long

' Ime baze
Private m_sDatabaseName As String

' Objekat baze podataka
Private m_db As Database

' Skup zapisa o osobama
Private m_Persons As CPersons

' Skup zapisa o kontaktima
Private m_Contacts As CContactEntries

' Idikator ispravnosti sifre
Private m_bIsValid As Boolean

' Greske
Const lERR_DBOPEN = vbObjectError + 1
Const lERR_RSOPEN = vbObjectError + 2

' PUBLIC: ******************************************
' Javni potprogrami svojstva

' Ime baze
Property Get DatabaseName() As String
    DatabaseName = m_sDatabaseName
End Property

' Objekat baze podataka
Property Get db() As Database
    Set db = m_db
End Property

' Skup zapisa o osobama
Property Get Persons() As CPersons
    Set Persons = m_Persons
End Property

' Skup zapisa o kontaktima
Property Get Contacts() As CContactEntries
    Set Contacts = m_Contacts
End Property

' Sifra prodavca
Property Let UserID(lUserID As Long)
    m_lUserID = lUserID
End Property
Property Get UserID() As Long
    UserID = m_lUserID
End Property

Property Get Valid() As Boolean
    Valid = m_bIsValid
End Property

' PRIVATE: *****************************************
' Privatni dogadjaji

Private Sub Class_Initialize()
Dim thisWorkspace As Workspace
Dim App As New CApplication
Dim bIsValid As Boolean

    On Error Resume Next
    
    ' Postavi ime baze
    m_sDatabaseName = App.Path & "cms.mdb"
    
    ' Koristi podrazumevani radni prostor
    Set thisWorkspace = Workspaces(0)

    ' Otvori bazu
    Set m_db = thisWorkspace.OpenDatabase(m_sDatabaseName)
    If Err.Number Then
        Err.Raise lERR_DBOPEN, "CSalesPerson:Init", Err.Description
    Else
        Validate
        If Valid Then
            ' Napravi nize objekte
            Set m_Persons = New CPersons
            m_Persons.Init m_db, UserID
            Set m_Contacts = New CContactEntries
        End If
    End If

End Sub


Private Sub Class_Terminate()
    ' Prvo zatvori skupove zapisa
    Set m_Persons = Nothing
    Set m_Contacts = Nothing
    
    ' Zatvori bazu
    If Not (m_db Is Nothing) Then
        m_db.Close
    End If

    ' Ocisti reference
    Set m_db = Nothing

End Sub

' Provera prodavcevog korisnickog imena
' i lozinke
Private Sub Validate()
Dim App As New CApplication
Dim rs As Recordset
Dim sSQL As String
Dim bDoExit As Boolean

    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Pretpostavi da nije u redu
    m_bIsValid = False
    
    ' Otvori skup zapisa
    sSQL = "SELECT * FROM SalesPerson"
    Set rs = m_db.OpenRecordset(sSQL, dbOpenDynaset)
    If Err.Number Then
        App.ErrorDisplay "Error in accessing database", Err.Description, Err.Number
        bDoExit = True
    End If
    
    ' Proveri korisnicko ime
    Do Until bDoExit Or m_bIsValid
        ' Prikazi uvodni ekran
        frmLogin.Display

        ' Proveri njegov status
        If frmLogin.Canceled Then
            bDoExit = True
        Else

            ' Nema greske, treba naci zapis
            rs.FindFirst "UserName='" & UCase$(frmLogin.UserName) & "'"
            If Err.Number Then
                App.ErrorDisplay "Greska u pristupu bazi", Err.Description, Err.Number
                bDoExit = True
            Else
                If rs.NoMatch Then
                    MsgBox "Uneto ime i lozinka nisu nadjeni. Pokusajte CMS i bilo koju lozinku"
                Else
                    ' Prociraj sifru
                    Me.UserID = rs.Fields("salesPersonID")
                    m_bIsValid = True
                End If
            End If
        End If
    Loop
End Sub


