VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPersons"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CPersons
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        4/25/95
' Opis:         Interfejs za skup svih osoba
' Izmene:
'
Option Explicit

' PRIVATE: *****************************************
' Privatni clanovi podaci

' Skup zapisa
Private m_rs As Recordset

' Referenca na objekat Person
Private m_Person As CPerson

' Podaci su menjani?
Private m_bIsDirty As Boolean

' Greske
Const lERR_RSOPEN = 2 + vbObjectError + 512

' PUBLIC: ******************************************
' Javni potprogrami svojstva

Public Property Get CurrentObject() As CPerson
    Set CurrentObject = m_Person
End Property

Public Property Get Dirty() As Boolean
    Dirty = m_bIsDirty
End Property
Public Property Let Dirty(bIsDirty As Boolean)
    m_bIsDirty = bIsDirty
End Property

' Brise trenutni zapis
Public Sub Delete()
    m_rs.Delete
End Sub

Public Sub Init(db As Database, lUserID As Long)
Dim sSQL As String
    ' Aktiviranje obrade gresaka
    On Error Resume Next

    ' Otvaranje skupa zapisa
    sSQL = "select * from Person " & _
                "where SalesPersonID = " & lUserID & _
                " order by LastName,FirstName"

    Set m_rs = db.OpenRecordset(sSQL, dbOpenDynaset)
    If Err.Number <> 0 Then
        Err.Raise lERR_RSOPEN, "CPersons:Init", Err.Description
    End If

End Sub

' PRIVATE: *****************************************
' Privatni dogadjaji

Private Sub Class_Initialize()
    ' Referenca na objekat Person
    Set m_Person = New CPerson

End Sub

Private Sub Class_Terminate()
    ' Zatvaranje baze
    If Not (m_rs Is Nothing) Then
        m_rs.Close
    End If

    ' Brisanje referenci
    Set m_rs = Nothing
    Set m_Person = Nothing

End Sub

' PUBLIC: *****************************************
' Javni metodi

' Popunjavanje liste sa podacima o osobama
Public Sub FillPersonList(lst As Control)
    FillList lst, "personID", "FirstName", "LastName"
End Sub

' Pozicioniranje na novi zapis o osobi
' Parametri:
'   lID         sifra zeljenog zapisa
Public Sub Reposition(lID As Long)
    ' Ako su trenutni podaci menjani,
    ' treba ih snimiti
    If m_bIsDirty Then
        UpdateRecord
    End If
    
    ' Nadji zeljenu osobu
    m_rs.FindFirst "personID = " & lID
    If m_rs.NoMatch = True Then
        ' Sada smo sigurni da je inicijalizovana
        ' referenca
        Set m_Person = New CPerson
    Else
        UpdateObject
    End If

    ' Indikator se iskljucuje
    m_bIsDirty = False
End Sub

' Popunjavanje liste sa skupom zapisa
' Parametri:
'   cbo         kontrola za listanje koja se popunjava
'   sIDColumn   Ime kolone koja sadrzi sifru zapisa
'   sColumns    Imena kolona koje treba prikazati
Private Sub FillList(cbo As Control, sIDColumn As String, ParamArray sColumns() As Variant)
Dim sData As String
Dim i As Integer
Dim bmCurrentPos As Variant

    ' Snimi trenutnu poziciju
    bmCurrentPos = m_rs.Bookmark

    ' Pomeri se na prvi zapis
    m_rs.MoveFirst

    ' I za svaki zapis do kraja datoteke
    Do Until m_rs.EOF
        ' Spoj svaku zeljenu kolonu
        sData = ""
        For i = 0 To UBound(sColumns)
            sData = sData & " " & m_rs(sColumns(i))
        Next i

        ' Dodaj podatak
        cbo.AddItem sData
        cbo.ItemData(cbo.NewIndex) = m_rs(sIDColumn)
        
        ' Pomeri se na sledeci red
        m_rs.MoveNext
    Loop
    
    ' Vrati staru poziciju
    m_rs.Bookmark = bmCurrentPos
End Sub
' Kopira podatke u objekat Person
Private Sub UpdateObject()
    m_Person.LastName = m_rs!LastName & ""
    m_Person.FirstName = m_rs!FirstName & ""
    m_Person.Address = m_rs!Address & ""
    m_Person.City = m_rs!City & ""
    m_Person.State = m_rs!State & ""
    m_Person.ZipCode = m_rs!ZipCode & ""
    m_Person.Company = m_rs!Company & ""
    m_Person.Title = m_rs!Title & ""
    m_Person.Department = m_rs!Department & ""
    m_Person.Phone = m_rs!Phone & ""
    m_Person.FAX = m_rs!FAX & ""
    m_Person.EMail = m_rs!EMail & ""
    m_Person.Notes = m_rs!Notes & ""
    m_Person.ID = m_rs!PersonID
End Sub

' Upisuje podatke iz objekta u bazu
Private Sub UpdateRecord()
    ' Ako je sifra 0, podaci su novi
    If m_Person.ID = 0 Then
        m_rs.AddNew
    Else
        m_rs.Edit
    End If

    ' Kopiraj polja
    m_rs!LastName = m_Person.LastName
    m_rs!FirstName = m_Person.FirstName
    m_rs!Address = m_Person.Address
    m_rs!City = m_Person.City
    m_rs!State = m_Person.State
    m_rs!ZipCode = m_Person.ZipCode
    m_rs!Company = m_Person.Company
    m_rs!Title = m_Person.Title
    m_rs!Department = m_Person.Department
    m_rs!Phone = m_Person.Phone
    m_rs!FAX = m_Person.FAX
    m_rs!EMail = m_Person.EMail
    m_rs!Notes = m_Person.Notes
    
    ' Izmeni zapis
    m_rs.Update
    m_rs.Bookmark = m_rs.LastModified
    
    ' Procitaj (novu) sifru
    m_Person.ID = m_rs!PersonID
End Sub


