VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CContactEntries"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CContactEntries
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        7/25/95
' Opis:         Rad sa skupom zapisa
' Izmene:
'
Option Explicit

' PUBLIC: ******************************************
' Javni clanovi podaci

' PRIVATE: *****************************************
' Privatni clanovi podaci
Private m_lUserID As Long
Private m_lPersonId As Long

' PUBLIC: ******************************************
' Javni metodi
Public Sub Init(dat As Data, lUserID As Long)
    ' Sifra korisnika
    m_lUserID = lUserID
    
    ' Postavljanje pocetnog skupa zapisa
    Me.Reposition dat, -1
    
End Sub

' Obavlja operaciju New
' Parametri:
'   dat     Kontrola
Public Sub NewContact(dat As Data)
    ' Menja se polozaj, cime se snima
    ' trenutni zapis
    If Not dat.Recordset.EOF Then
        dat.Recordset.MoveLast
    End If
    ' Novi zapis
    dat.Recordset.AddNew
    dat.Recordset("SalesPersonID") = m_lUserID
    dat.Recordset("PersonID") = m_lPersonId
 
End Sub

' Menjanje polozaja u skupu zapisa
Public Sub Reposition(dat As Data, lPersonID As Long)
    ' Skup zapisa se zatvara da bi se
    ' podaci snimili
    If Not (dat.Recordset Is Nothing) Then
        dat.Recordset.Close
    End If
    
    ' Pamti se sifra osobe
    m_lPersonId = lPersonID
    
    ' Izvor za skup zapisa
    If lPersonID > 0 Then
        dat.RecordSource = "select contactEntries.*,contactTypes.contactTypeDescription " & _
            "from contactEntries left join contactTypes " & _
            "on contactEntries.contactType = contactTypes.contactTypeID " & _
            "where contactEntries.SalesPersonID = " & m_lUserID & " " & _
            "and contactEntries.PersonID = " & lPersonID & " " & _
            "order by contactDate DESC"
    Else
        dat.RecordSource = "select contactEntries.*,contactTypes.contactTypeDescription " & _
            "from contactEntries left join contactTypes " & _
            "on contactEntries.contactType = contactTypes.contactTypeID " & _
            "where contactEntries.SalesPersonID = " & m_lUserID & " " & _
            "order by contactDate DESC"
    End If
    dat.Refresh
End Sub

