VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CApplication"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:   CApplication
' Autor:       Deborah Kurata, InStep Technologies
' Datum:         June 1, 1995
' Opis:         Obezbedjuje dodatne mogucnosti
'               koje objekat App ne omogucava.
'
' Izmene:
'
Option Explicit

' PUBLIC: *****************************************
' Javni clanovi podaci

' PRIVATE: *****************************************
' Privatni clanovi podaci

' Omotac za poruku o autorskim pravima
Public Property Get Copyright() As String
    Copyright = App.LegalCopyright
End Property

' Omotac za datoteku za pomoc
Public Property Get HelpFile() As String
    HelpFile = Path & App.HelpFile
End Property

' Omotac za putanju
' Obezbedjuje da putanja ima "\" na kraju
Public Property Get Path() As String
    If Right(App.Path, 1) = "\" Then
        Path = App.Path
    Else
        Path = App.Path & "\"
    End If
End Property

' Omotac za naslov aplikacije
Public Property Get Title() As String
    Title = App.Title
End Property

' Omotac za verziju aplikacije
Public Property Get Version() As String
    Version = "Verzija: " & App.Major & "." & App.Minor & "." & App.Revision
End Property


' Standardne rutine za obradu gresaka
' Koriste se za sve sistemske poruke o greskama
' Svaka greska kod koje treba upisati poruku u
' datoteku za pracenje rada treba da zove ovu rutinu.
' Parametri:
'  sUserMsg       poruka za korisnika
'  sInternalMsg   opis greske
'  lInternalCode  kod greske, 0 ako ga nema
Public Sub ErrorDisplay(sUserMsg As String, sInternalMsg As String, lInternalCode As Long)
Dim iFileNum
Dim sPrintMsg

   ' Opis greske se stampa u datoteku
   iFileNum = FreeFile
   Open "ERROR.LOG" For Append As iFileNum

   ' Datum i poruka se prikazuju korisniku.
   sPrintMsg = Now & vbCrLf & sUserMsg
   sPrintMsg = sPrintMsg & vbCrLf & "  Greska: [" & lInternalCode & "]: " & sInternalMsg & vbCrLf
   Print #iFileNum, sPrintMsg
   Close #iFileNum

   ' Opis greske se stampa u prozor za pracenje rada
   Debug.Print sPrintMsg

    ' Prikazuje se okvir sa porukom o gresci
    MsgBox sUserMsg, vbOKOnly + vbExclamation, Me.Title

End Sub

