VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPersons"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CPersons
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        4/25/95
' Opis:         Interfejs za rad sa svim osobama
' Izmene:
'
Option Explicit

' PRIVATE: *****************************************
' Privatni clanovi

' Baza podataka
Private m_DB As Database

' Skup zapisa
Private m_rs As Recordset

' Referenca na klasu CPerson
Private m_Person As CPerson

' Indikator izmena
Private m_bIsDirty As Boolean

' Greske
Const lERR_DBOPEN = 1 + vbObjectError + 512
Const lERR_RSOPEN = 2 + vbObjectError + 512

' PUBLIC: *****************************************
' Javne procedure svojstva

Public Property Get CurrentObject() As CPerson
    Set CurrentObject = m_Person
End Property

Public Property Get Dirty() As Boolean
    Dirty = m_bIsDirty
End Property
Public Property Let Dirty(bIsDirty As Boolean)
    m_bIsDirty = bIsDirty
End Property

' Obrisi trenutni zapis
Public Sub Delete()
    m_rs.Delete
End Sub

' Popuni listu sa osobama
Public Sub FillPersonList(lst As Control)
    FillList lst, "personID", "FirstName", "LastName"
End Sub

' Promena trenutnog zapisa o osoi
' Parametri:
'   lID         Sifra zapisa
Public Sub Reposition(lID As Long)

    ' Ako je bilo izmena, snimi
    If m_bIsDirty Then
        UpdateRecord
    End If
    
    ' Nadji osobu
    m_rs.FindFirst "personID = " & lID
    If m_rs.NoMatch = True Then
        ' Obezbedi inicijalizaciju
        Set m_Person = New CPerson
    Else
        UpdateObject
    End If

    ' Iskljuci indikator
    m_bIsDirty = False
End Sub

' PRIVATE: *****************************************
' Privatne procedure

Private Sub Class_Initialize()
Dim App As New CApplication
Dim thisWorkspace As Workspace
Dim iRetVal As Integer
Dim sSQL As String

    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Standardni radni prostor
    Set thisWorkspace = Workspaces(0)

    ' Otvori bazu
    Set m_DB = thisWorkspace.OpenDatabase(App.Path & "person.MDB")
    If Err.Number <> 0 Then
        Err.Raise lERR_DBOPEN, "CPersons:Init", Err.Description
        GoTo EXIT_Initialize
    End If

    ' SQL naredba
    sSQL = "select * from Person"

    ' Otvori skup zapisa
    Set m_rs = m_DB.OpenRecordset(sSQL, dbOpenDynaset)
    If Err.Number <> 0 Then
        Err.Raise lERR_RSOPEN, "CPersons:Init", Err.Description
        GoTo EXIT_Initialize
    End If
    
    ' Referenca na objekat Person
    Set m_Person = New CPerson

EXIT_Initialize:
End Sub

Private Sub Class_Terminate()
    ' Zatvori skup zapisa i bazu
    If Not (m_rs Is Nothing) Then
        m_rs.Close
    End If
    If Not (m_DB Is Nothing) Then
        m_DB.Close
    End If

    ' Ocisti reference
    Set m_DB = Nothing
    Set m_rs = Nothing
    Set m_Person = Nothing

End Sub

' Popunjavanje liste sa podacima o osobama
' Parametri:
'   cbo         kontrola koja se popunjava
'   sIDColumn   ime polja koje sadrzi sifru zapisa
'   sColumns    imena kolona koje se prikazuju
Private Sub FillList(cbo As Control, sIDColumn As String, ParamArray sColumns() As Variant)
Dim sData As String
Dim i As Integer
Dim bmCurrentPos As Variant

    ' Snimi trenutnu poziciju
    bmCurrentPos = m_rs.Bookmark

    ' Ocisti listu
    cbo.Clear

    ' Pomeri se na prvi zapis
    m_rs.MoveFirst

    ' Dodaj svaki zapis do kraja baze
    Do Until m_rs.EOF
        ' Spoj svaku zeljenu kolonu
        sData = ""
        For i = 0 To UBound(sColumns)
            sData = sData & " " & m_rs(sColumns(i))
        Next i

        ' Dodaj podatke listi
        cbo.AddItem sData
        cbo.ItemData(cbo.NewIndex) = m_rs(sIDColumn)
        
        ' Predji na sledeci red
        m_rs.MoveNext
    Loop
    
    ' Vrati se na pocetnu poziciju
    m_rs.Bookmark = bmCurrentPos
End Sub

' Kopiraj podatke u objekat Person
Private Sub UpdateObject()
    m_Person.LastName = m_rs!LastName & ""
    m_Person.FirstName = m_rs!FirstName & ""
    m_Person.Address = m_rs!Address & ""
    m_Person.City = m_rs!City & ""
    m_Person.State = m_rs!State & ""
    m_Person.ZipCode = m_rs!ZipCode & ""
    m_Person.Company = m_rs!Company & ""
    m_Person.Title = m_rs!Title & ""
    m_Person.Department = m_rs!Department & ""
    m_Person.Phone = m_rs!Phone & ""
    m_Person.FAX = m_rs!FAX & ""
    m_Person.EMail = m_rs!EMail & ""
    m_Person.Notes = m_rs!Notes & ""
    m_Person.ID = m_rs!PersonID
End Sub

' Upisi podatke iz objekta Person u zapis
Private Sub UpdateRecord()
    ' Ako je sifra 0, nov je
    If m_Person.ID = 0 Then
        m_rs.AddNew
    Else
        m_rs.Edit
    End If

    ' Kpiraj polja
    m_rs!LastName = m_Person.LastName
    m_rs!FirstName = m_Person.FirstName
    m_rs!Address = m_Person.Address
    m_rs!City = m_Person.City
    m_rs!State = m_Person.State
    m_rs!ZipCode = m_Person.ZipCode
    m_rs!Company = m_Person.Company
    m_rs!Title = m_Person.Title
    m_rs!Department = m_Person.Department
    m_rs!Phone = m_Person.Phone
    m_rs!FAX = m_Person.FAX
    m_rs!EMail = m_Person.EMail
    m_rs!Notes = m_Person.Notes
    
    ' Upisi
    m_rs.Update
    m_rs.Bookmark = m_rs.LastModified
    
    ' Procitaj (novu) sifru
    m_Person.ID = m_rs!PersonID
End Sub

