Attribute VB_Name = "MMain"
' Ime modula:   MMain
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        July 13, 1995
' Opis:         Glavni modul koji dodaje dodatak
'               u datoteku VB.INI.
'
' Izmene:
'
Option Explicit

' PUBLIC: *****************************************
' Javni clanovi
' Putanja do kostura
Public sAppFrmPath As String

' PRIVATE: *****************************************
' Privatni clanovi

#If Win16 Then
    Declare Function WritePrivateProfileString% Lib "KERNEL" (ByVal AppName$, _
        ByVal KeyName$, ByVal keydefault$, ByVal FileName$)
    Declare Function GetPrivateProfileString% Lib "KERNEL" (ByVal AppName$, _
        ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, _
        ByVal NumBytes As Integer, ByVal FileName$)
#Else
    Declare Function WritePrivateProfileString% Lib "Kernel32" _
        Alias "WritePrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, _
        ByVal keydefault$, ByVal FileName$)
    Declare Function GetPrivateProfileString% Lib "Kernel32" _
        Alias "GetPrivateProfileStringA" (ByVal AppName$, _
        ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, _
        ByVal NumBytes As Integer, ByVal FileName$)
#End If

Sub Main()
Dim sReturnString As String * 64
Dim sSection As String
Dim iRetVal

  'Proveri da li je dodatak u datoteci VB.INI.
  'Ako nije, dodaj ga
  #If Win16 Then
    sSection = "Add-Ins16"
  #Else
    sSection = "Add-Ins32"
  #End If
  
  iRetVal = GetPrivateProfileString(sSection, _
            "AppWizard.CConnect", "NotFound", _
            sReturnString, Len(sReturnString), "VB.INI")
  If Left(sReturnString, iRetVal) = "NotFound" Then
    iRetVal = WritePrivateProfileString(sSection, _
            "AppWizard.CConnect", "1", _
            "VB.INI")
  End If

  ' Mesto kostura
  iRetVal = GetPrivateProfileString("InStepAppWizard", _
            "Path", "", _
            sReturnString, Len(sReturnString), App.Path & "\APPWIZ.INI")
  sAppFrmPath = Left(sReturnString, iRetVal)
End Sub

