VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CAppWizard"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CAppWizard
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        July 13, 1995
' Opis:         Uspostvlja vezu sa VBIDE
'
' Imene:
'
Option Explicit

' PUBLIC: *****************************************
' Javni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

' objekat VB applicije
Private m_VBAppObject As VBIDE.Application

' Postavi objekat aplikacije
Public Property Set VBAppObject(AppObject As VBIDE.Application)
    Set m_VBAppObject = AppObject
End Property
Public Property Get VBAppObject() As VBIDE.Application
    Set VBAppObject = m_VBAppObject
End Property

' Ovo je metod koji se izvrsava kada korisnik
' odabere opciju Add-In iz VB menija
Public Sub AfterClick()
  
    'Ucitaj i prikazi obrazac
    frmAppWizard.Display
    
    ' Ako nije ponisten, dodaj datoteke
    If Not frmAppWizard.Cancelled Then
        addFiles
    End If
End Sub

' Dodaje datoteke
Private Sub addFiles()
Dim sPath As String
On Error Resume Next

    ' Putanja projekta
    sPath = StripPath(m_VBAppObject.ActiveProject.FileName)
    
    ' Kopiraj datoteke
    FileCopy sAppFrmPath & "main.bas", sPath & "main.bas"
    FileCopy sAppFrmPath & "main.frm", sPath & "main.frm"
    FileCopy sAppFrmPath & "about.frm", sPath & "about.frm"
    FileCopy sAppFrmPath & "about.frx", sPath & "about.frx"
    FileCopy sAppFrmPath & "splash.frm", sPath & "splash.frm"
    FileCopy sAppFrmPath & "splash.frx", sPath & "splash.frx"
    FileCopy sAppFrmPath & "Win.cls", sPath & "Win.cls"
    FileCopy sAppFrmPath & "App.cls", sPath & "App.cls"
    
    ' Dodaj datoteke projektu
    With m_VBAppObject.ActiveProject
        .AddFile sPath & "main.bas"
        .AddFile sPath & "main.frm"
        .AddFile sPath & "about.frm"
        .AddFile sPath & "splash.frm"
        .AddFile sPath & "Win.cls"
        .AddFile sPath & "App.cls"
    End With
    
End Sub

' Vraca putanju iz punog imena datoteke
Private Function StripPath(sFileName As String) As String
Dim iSlash As Integer
Dim iFoundIt As Integer

    iFoundIt = 0
    Do
        iSlash = iFoundIt
        iFoundIt = InStr(iSlash + 1, sFileName, "\")
    Loop Until iFoundIt = 0

    If iSlash > 0 Then
        StripPath = Left(sFileName, iSlash)
    Else
        StripPath = ""
    End If
End Function

