VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CWindow"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CWindow
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 1, 1995
' Opis:         Genericka klasa za rad sa prozorima
'
' Izmene:
'
Option Explicit

' Konstante gresaka
Const iCB_CLEAR_ERR = 3 + vbObjectError + 512
Const iCB_SET_ERR = 4 + vbObjectError + 512
Const iCB_PASTE_ERR = 5 + vbObjectError + 512

' PUBLIC: *****************************************
' Javni clanovi

' Kad se ovo svojstvo postavi, prozor ide na vrh
Public Property Let OnTop(frmTop As Form, bSetOnTop As Boolean)
    If bSetOnTop = True Then
      ' Postavi prozor na vrh
      Call SetWindowPos(frmTop.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)
    Else
      ' Ne ide na vrh
      Call SetWindowPos(frmTop.hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)
    End If
End Property

' PRIVATE: *****************************************
' Privatni clanovi

' Centerira obrazac
' Ako je to mdi obrazac, cetrira ga u mdi roditelju.
' Inace, centrira ga na ekranu.
' Parametri:
'  frmCenter      Obrazac koji se centrira
Public Sub Center(frm As Form)
Dim lHeight, lWidth, lOffset, tOffset
   If frm.MDIChild = True Then
      lHeight = frm.Parent.ScaleHeight
      lWidth = frm.Parent.ScaleWidth
   Else
      lHeight = Screen.Height
      lWidth = Screen.Width
   End If

   ' Levi razmak
   lOffset = ((lWidth - frm.Width) / 2)
   
   ' Gornji razmak
   tOffset = ((lHeight - frm.Height) / 2)

   ' Centriraj obrazac
   frm.Move lOffset, tOffset
End Sub

' Operacija Copy
' Moze se prosiriti da podrzi razlicite tipove
' clipboarda
Public Sub EditCopy()
    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Ocisti clipboard
    Clipboard.Clear
    If Err.Number Then
        Err.Raise iCB_CLEAR_ERR, "CApplication", "Greska prilikom ciscenja clipboarda."
    Else
        ' Stavi tekst na clipboard
        Clipboard.SetText Screen.ActiveControl.SelText
        If Err.Number Then
            Err.Raise iCB_SET_ERR, "CApplication", "Greska prilikom stavljanja na clipboard."
        End If
    End If
End Sub

' Operacija Cut
' Moze se prosiriti da podrzi razlicite tipove
' clipboarda

Public Sub EditCut()
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Ocisti clipboard
    Clipboard.Clear
    If Err.Number Then
        Err.Raise iCB_CLEAR_ERR, "CApplication", "Greska prilikom ciscenja clipboarda."
    Else
        ' Stavi izbrani tekst na clipboard
        Clipboard.SetText Screen.ActiveControl.SelText
        Screen.ActiveControl.SelText = ""
        If Err.Number Then
            Err.Raise iCB_SET_ERR, "CApplication", "Greska kod stavljanja na clipboard ."
        End If
    End If

End Sub

' Procedura Paste
' Moze se prosiriti da podrzi razlicite tipove
' clipboarda
Public Sub EditPaste()
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Kopiraj tekst iz clipboarda
    Screen.ActiveControl.SelText = Clipboard.GetText()
    If Err.Number Then
        Err.Raise iCB_PASTE_ERR, "CApplication", "Greska kod stavljanja teksta iz clipboarda."
    End If
 
End Sub

