VERSION 4.00
Begin VB.Form frmMain 
   Caption         =   "Kostur"
   ClientHeight    =   5790
   ClientLeft      =   1035
   ClientTop       =   1665
   ClientWidth     =   6825
   Height          =   6480
   Left            =   975
   LinkTopic       =   "Form1"
   ScaleHeight     =   5790
   ScaleWidth      =   6825
   Top             =   1035
   Width           =   6945
   Begin MSComDlg.CommonDialog cDlg 
      Left            =   2160
      Top             =   180
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      CancelError     =   -1  'True
   End
   Begin VB.Menu mnuFileMenu 
      Caption         =   "&Datoteke"
      Begin VB.Menu mnuFile 
         Caption         =   "&Nova"
         Index           =   0
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Otvori..."
         Index           =   1
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Snimi"
         Index           =   2
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFile 
         Caption         =   "Snimi &kao..."
         Index           =   3
      End
      Begin VB.Menu mnuFile 
         Caption         =   "-"
         Index           =   4
      End
      Begin VB.Menu mnuFile 
         Caption         =   "Sta&mpanje..."
         Index           =   5
         Shortcut        =   ^P
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Pregled"
         Index           =   6
      End
      Begin VB.Menu mnuFile 
         Caption         =   "-"
         Index           =   7
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Izlaz"
         Index           =   8
      End
   End
   Begin VB.Menu mnuEditMenu 
      Caption         =   "&Izmene"
      Begin VB.Menu mnuEdit 
         Caption         =   "Ise&ci"
         Index           =   0
         Shortcut        =   ^X
      End
      Begin VB.Menu mnuEdit 
         Caption         =   "&Kopiraj"
         Index           =   1
         Shortcut        =   ^C
      End
      Begin VB.Menu mnuEdit 
         Caption         =   "&Prenesi"
         Index           =   2
         Shortcut        =   ^V
      End
   End
   Begin VB.Menu mnuHelpMenu 
      Caption         =   "&Pomoc"
      Begin VB.Menu mnuHelp 
         Caption         =   "&Teme"
         Index           =   0
      End
      Begin VB.Menu mnuHelp 
         Caption         =   "-"
         Index           =   1
      End
      Begin VB.Menu mnuHelp 
         Caption         =   "&Informacije ..."
         Index           =   2
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime obrasca:  frmMain
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 1, 1995
' Opis:         Sablon za glavni ekran.
'
' Izmene:
'
Option Explicit

' PUBLIC: *****************************************
' JAvni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

' Konstante menija.
' Koriste se umesto "magicnih brojeva"

' Opcije menija Datoteke
Private Const iFILE_NEW = 0
Private Const iFILE_OPEN = 1
Private Const iFILE_SAVE = 2
Private Const iFILE_SAVEAS = 3
Private Const iFILE_PRINT = 5
Private Const iFILE_PRINTPREVIEW = 6
Private Const iFILE_EXIT = 8

' Opcije menija Izmene
Private Const iEDIT_CUT = 0
Private Const iEDIT_COPY = 1
Private Const iEDIT_PASTE = 2

' *** Ovde dolaze ostale opcije ***

' Opcije menija Pomoc
Private Const iHELP_TOPICS = 0
Private Const iHELP_ABOUT = 2

' Prikazuje obrazac
Public Sub Display()
    ' Prikazi obrazac
    Me.Show

End Sub

Private Sub Form_Load()
Dim Win As New CWindow
Dim App As New CApplication

    ' Postavi ispravan naslov
    Me.Caption = App.Title
    
    ' Centriraj obrazac
    Win.Center Me

End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Ocisti reference
    Set frmMain = Nothing
    End
End Sub

Private Sub mnuEdit_Click(index As Integer)
Dim Win As New CWindow

    Select Case index
        Case iEDIT_CUT
            Win.EditCut

        Case iEDIT_COPY
            Win.EditCopy

        Case iEDIT_PASTE
            Win.EditPaste
    End Select

End Sub

' Omogucije/onemogucuje odgovarajuce opcije
' menija Izmene (Edit)
Private Sub mnuEditMenu_Click()
    ' Onemoguci sve tri
    Me.mnuEdit(iEDIT_CUT).Enabled = False
    Me.mnuEdit(iEDIT_COPY).Enabled = False
    Me.mnuEdit(iEDIT_PASTE).Enabled = False
    
    ' Obezbedi da postoji aktivna kontrola
    If Not (Screen.ActiveControl Is Nothing) Then
        ' Ako je aktivna kontrola okvir za tekst
        ' ili kombinovani okvir
        If TypeOf Screen.ActiveControl Is TextBox _
           Or TypeOf Screen.ActiveControl Is ComboBox Then
            ' Ako je nesto selektovano omoguci
            ' isecanje i kopiranje
            If Screen.ActiveControl.SelLength > 0 Then
                Me.mnuEdit(iEDIT_CUT).Enabled = True
                Me.mnuEdit(iEDIT_COPY).Enabled = True
            End If
            
            ' Ako ima nesto u clipboardu omoguci
            ' prenosenje
            If Clipboard.GetFormat(vbCFText) Then
                Me.mnuEdit(iEDIT_PASTE) = True
            End If
        End If
    End If

End Sub

Private Sub mnuFile_Click(index As Integer)
Dim sFileName As String
Dim iNumCopies As Integer

    Select Case index
    
        Case iFILE_NEW
            ' Napravi novu datoteku
            ' *** Ovde dolazi kod za pravljenje
            MsgBox "Ova opcija bi pravila novu datoteku"
            
        Case iFILE_OPEN
            ' Pozovi dijalog za ime datoteke
            FileOpenDB cdlg, sFileName
            
            ' Ako ovir nije ponisten otvori datoteku
            ' *** Ovde dolazi kod za otvaranje
            If Len(sFileName) <> 0 Then
                MsgBox "Ovo bi otvorilo datoteku: " & sFileName
            End If
            
        Case iFILE_SAVE
            ' Snimi podatke
            ' *** Ovde dolazi kod koji snima podatke
            MsgBox "Ovo bi snimilo podatke."
            
        Case iFILE_SAVEAS
            ' Pozovi okvir za novo ime
            FileSaveAsDB cdlg, sFileName

            ' *** Ovde dolazi kod koji snima podatke
            
        Case iFILE_PRINT
            ' Pozovi okvir za informacije o stampanju
            FilePrintDB cdlg, iNumCopies
            
            ' *** Ovde dolazi kod za stampanje
            
        Case iFILE_PRINTPREVIEW
            ' *** Ovde dolazi kod za pregled pre stampe
            MsgBox "Ovo bi prikazalo pregled pre stampe."
            
        Case iFILE_EXIT
            ' Zatvori prozor
            Unload Me
    End Select
End Sub

' Opcije menija Pomoc (Help)
Private Sub mnuHelp_Click(index As Integer)
Dim App As New CApplication
   
   Select Case index
   
      Case iHELP_TOPICS
        ' Zadaj datoteku za pomoc
        If Len(App.HelpFile) <> 0 Then
            cdlg.HelpFile = App.HelpFile
            cdlg.HelpCommand = cdlHelpContents
            cdlg.ShowHelp
        Else
            MsgBox "Ovo bi prikazalo sistem za pomoc"
        End If

      Case iHELP_ABOUT     ' Informacije
        ' Prikazi okvir za informacije
        frmAbout.Display
        
   End Select

End Sub

' Dijalog za otvaranje datoteke
' Parametri:
'   cDlg        Kontrola za dijalog
'   sFileName   Ime odabrane datoteke (Vraca se)
Private Sub FileOpenDB(cdlg As Control, sFileName As String)
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Koristi kontrolu za dijalog
    cdlg.CancelError = True
    cdlg.DialogTitle = "Otvaranje datoteke"
    cdlg.Filter = "Sve (*.*)|*.*|" _
         & "Tekst (*.txt)|*.txt|" _
         & "Log (*.log)|*.log"
    cdlg.ShowOpen

     ' Uhvati gresku ako je korisnik ponistio okvir
     If Err.Number = cdlCancel Then
        ' Vrati prazno ime
        sFileName = ""
     Else
         ' Vrati ime
         sFileName = cdlg.filename
     End If

End Sub

' Okvir za stampanje
' Parametri
'   cDlg        kontrola za dijalog
'   iNumCopies  broj kopija
Private Sub FilePrintDB(cdlg As Control, iNumCopies As Integer)
    ' Aktiviraj obradu gresaka
    On Error Resume Next

     ' Koristi kontrolu za dijalog
    cdlg.CancelError = True
    cdlg.DialogTitle = "Print"
    cdlg.Flags = cdlPDHelpButton Or cdlPDUseDevModeCopies
    cdlg.ShowPrinter

     ' Uhvati gresku ako je ponisteno
     If Err.Number = cdlCancel Then
        iNumCopies = 0
     Else
        iNumCopies = cdlg.Copies
     End If
End Sub

' Dijalog za snimanje pod drugim imenom
' Parametri:
'   cDlg        Kontrola za dijalog
'   sFileName   Ime koje je odabrao korisnik (Vraca se)
Private Sub FileSaveAsDB(cdlg As Control, sFileName As String)
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Koristi kontrolu za dijalog
    cdlg.CancelError = True
    cdlg.DialogTitle = "Novo ime"
    cdlg.Filter = "Sve (*.*)|*.*|" _
         & "Tekst (*.txt)|*.txt|" _
         & "Log (*.log)|*.log"
    cdlg.ShowSave

     ' Uhvati gresku ako je ponisteno
     If Err.Number = cdlCancel Then
        ' Vrati prazno ime
        sFileName = ""
     Else
         ' Vrati ime
         sFileName = cdlg.filename
     End If
End Sub

