VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CApplication"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CApplication
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 1, 1995
' Opis:         Obezbedjuje dodatna svojstva i
'               metode koje nema objekat App.
'
' Izmene:
'
Option Explicit

' PUBLIC: *****************************************
' Javni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

' Omotac za poruku o autorskim pravima
Public Property Get Copyright() As String
    Copyright = App.LegalCopyright
End Property

' Omotac za datoteku za pomoc
Public Property Get HelpFile() As String
    #If debugMode Then
        ' Zbog testiranja koristimo pomoc VB-a
        HelpFile = "vb.hlp"
    #Else
        HelpFile = Path & App.HelpFile
    #End If
End Property

' Omotac za putanju
' Obezbedjuje da postoji "\" na kraju
Public Property Get Path() As String
    If Right(App.Path, 1) = "\" Then
        Path = App.Path
    Else
        Path = App.Path & "\"
    End If
End Property

' Omotac za naslov
Public Property Get Title() As String
    Title = App.Title
End Property

' Omotac za verziju
Public Property Get Version() As String
    Version = "Verzija: " & App.Major & "." & App.Minor & "." & App.Revision
End Property


' Standardna obrada gresaka
' Koristi se za obradu svih sistemskih gresaka
' Treba da je pozove svaka greska koja zahteva
' upisivanje u datoteku za pracenje rada.
' Parametri:
'  sUserMsg       poruka za korisnika
'  sInternalMsg   interni opis greske
'  iInternalCode  interni kod greske , 0 ako ga nema
Public Sub ErrorDisplay(sUserMsg As String, sInternalMsg As String, iInternalCode As Integer)
Dim iFileNum
Dim sPrintMsg

   ' Detaljni interni opis greske ide u datoteku
   iFileNum = FreeFile
   Open "ERROR.LOG" For Append As iFileNum

   'Datum i poruka za korisnika.
   sPrintMsg = Now & vbCrLf & sUserMsg
   sPrintMsg = sPrintMsg & vbCrLf & "  Greska: [" & iInternalCode & "]: " & sInternalMsg & vbCrLf
   Print #iFileNum, sPrintMsg
   Close #iFileNum

   ' Output detailed string to the debug window
   Debug.Print sPrintMsg

    ' Prikazi poruku za korisnika
    MsgBox sUserMsg, vbOKOnly + vbExclamation, Me.Title

End Sub
