VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTasks"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
' Class Name:   CTasks
' Author:       Deborah Kurata
' Date:         June 10, 1995
' Description:  Maintains the collection of CTask objects.
'

Option Explicit

' PUBLIC: ******************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

' Define the collection of tasks
Private m_colTasks As New Collection

' Define the reference to the file processing class
Dim m_File As CFile

' Provide the count of the number in the collection
Public Property Get Count() As Long
    Count = m_colTasks.Count
End Property

' Initialize event
Private Sub Class_Initialize()
    ' Read any existing data from the file
    Set m_File = New CFile
    m_File.FileName = App.Path & "\task.bin"
    m_File.ReadFile Me
End Sub

' Terminate event
Private Sub Class_Terminate()
    ' Save the data
    m_File.WriteFile Me

    ' Clear the reference
    Set m_File = Nothing
End Sub

' Add a task to the collection
' Parameters:
'   sDescription    string description of the task
'   iPriority       priority of the task
' Returns:
'   Task            task object
Public Function Add(iPriority As Integer, sDescription As String) As CTask
Dim Task As CTask

    ' Create the instance
    Set Task = New CTask

    With Task
        ' Set a unique ID
        .ID = NextID

        ' Set the properties
        .Priority = iPriority
        .Description = sDescription
        
        ' Add the member to the collection
        m_colTasks.Add Task, .ID
    End With

    ' Return the one that was added
    Set Add = Task
End Function

' Clear the collection
Public Sub Clear()
    Set m_colTasks = Nothing
End Sub

' Displays the defined member
' Parameters:
'   vkey         key or index of member to get
Public Function Item(vKey As Variant) As Object
    Set Item = m_colTasks.Item(vKey)
End Function

' Read the data from the file
Public Sub ReadFileData()
Dim Task As CTask

    ' Read in the object
    Set Task = New CTask
    Task.ReadFileData m_File
    If Err.Number = 0 Then
        
        ' Set a unique ID
        Task.ID = NextID
    
        ' Add the member to the collection
        m_colTasks.Add Task, Task.ID
    End If
End Sub

' Remove the member from the collection.
' Parameters:
'   vkey         key or index of member to delete
Public Sub Remove(vKey As Variant)
    ' Remove the member from the collection
    m_colTasks.Remove vKey
End Sub

' Write the data to a file
Public Sub WriteFileData()
Dim Task As CTask

    ' Write the properties
    For Each Task In m_colTasks
        Task.WriteFileData m_File
    Next
End Sub

' Provides the next available ID
' Returns:
'   NextID      Next unique Task ID
Private Function NextID() As String
Static iID As Integer

    iID = iID + 1
    NextID = "T" & Format$(iID, "00000")

End Function

