VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTask"
Attribute VB_Creatable = False
Attribute VB_Exposed = True
' Ime klase:    CTask
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 9, 1995
' Opis:         Objekat zadatak sa opisom i
'               prioritetom
' Izmene:

Option Explicit

' PUBLIC: ******************************************
' Javni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

Private m_sDescription As String
Private m_iPriority As Integer

Private m_sID As String

Private m_dtCreated As Date


' PUBLIC: *****************************************
' Javni potprogrami svojstva

' Opis zadatka
Public Property Let Description(sDescription As String)
Attribute Description.VB_Description = "Returns/sets the description of a task."
    m_sDescription = sDescription
End Property
Public Property Get Description() As String
    Description = m_sDescription
End Property

' Prioritet
Public Property Let Priority(iPriority As Integer)
    m_iPriority = iPriority
End Property
Public Property Get Priority() As Integer
    Priority = m_iPriority
End Property

' Sifra za kolekciju
' NAPOMENA: mora biti jedinstveni string koji
' se samo jedanput postavlja
Public Property Let ID(sID As String)
Static bAlreadySet As Boolean

    If Not bAlreadySet Then
        m_sID = sID
        bAlreadySet = True
    End If
End Property
Public Property Get ID() As String
    ID = m_sID
End Property

' Datum kreiranja, samo za citanje
Public Property Get Created() As Date
    Created = m_dtCreated
End Property

' Inicijalizacioni dogadjaj
Private Sub Class_Initialize()
    ' Postavi datum kreiranja
    m_dtCreated = Now
End Sub

' Zavrsni dogadjaj
Private Sub Class_Terminate()
End Sub

' PUBLIC: *****************************************
' JAvni metodi

' PRIVATE: *****************************************
' Privatni metodi
Public Sub ReadFileData(File As CFile)
Dim iInt As Integer
Dim str As String

    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Procitaj prioritet
    File.ReadInt iInt
    If Err.Number Then
        Err.Raise Err.Number, "CTask::ReadFileData", Err.Description
    Else
        Priority = iInt
    
        ' Procitaj opis
        File.ReadStr str
        If Err.Number Then
            Err.Raise Err.Number, "CTask::ReadFileData", Err.Description
        Else
            Description = str
        End If
    End If
    
End Sub

' Upisuje podatke u datoteku
Public Sub WriteFileData(File As CFile)

    File.WriteInt Priority
    File.WriteStr Description
End Sub



