VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CFile"
Attribute VB_Creatable = False
Attribute VB_Exposed = True
' Ime klase:    CFile
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 12, 1995
' Opis:         Genericka klasa za rad sa
'               datotekama.
' Izmene:

Option Explicit

' PUBLIC: *****************************************
' Javni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

' Putanja i ime datoteke
Private m_sFileName As String

' Broj datoteke
Private m_iFileNumber As Integer

' Greske
Const iOPEN_ERR = 1 + vbObjectError + 512
Const iEOF_ERR = 2 + vbObjectError + 512
Const iREAD_ERR = 3 + vbObjectError + 512
Const iWRITE_ERR = 4 + vbObjectError + 512

Property Get FileName() As String
    FileName = m_sFileName
End Property
Property Let FileName(sFileName As String)
    ' Ovde treba proveriti putanju i ime
    m_sFileName = sFileName
End Property

' Cita sve objekte iz datoteke u dati objekat
' Parametri:
'   obj         Objekat u koji se cita
Public Sub ReadFile(obj As Object)

    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Broj datoteke
    m_iFileNumber = FreeFile
    
    ' Otvori datoteku i uhvati eventualne greske
    Open m_sFileName For Binary Access Read As #m_iFileNumber
    Select Case Err.Number
        Case 0  ' Nema greske
            ' Procitaj podatke
            Do Until EOF(m_iFileNumber)
                obj.ReadFileData
            Loop
        
        Case 53    ' Datoteka nije nadjena
            ' Ne radi nista
            
        Case Else
            ' Prosledi gresku
            Err.Raise iOPEN_ERR, "CFile::ReadFile", "Greska u otvaranju datoteke."
            
    End Select

    ' Zatvori datoteku
    Close #m_iFileNumber
End Sub

' Cita integer iz datoteke
' Parametri:
'   iInt         integer koji se cita
Public Sub ReadInt(iInt As Integer)
    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    Get #m_iFileNumber, , iInt
    If EOF(m_iFileNumber) Then
        ' Prosledi gresku
        Err.Raise iEOF_ERR, "CFile::ReadInt", "EOF"
    End If
End Sub

' Cita string iz datoteke
' Parametri:
'   str         cita string iz datoteke
Public Sub ReadStr(sStr As String)
Dim iLen As Integer
    ' Aktivira obradu gresaka
    On Error Resume Next

    ' Procitaj duzinu stringa
    Get #m_iFileNumber, , iLen
    If Not EOF(m_iFileNumber) Then
        sStr = String(iLen, " ")

        ' A onda i string
        Get #m_iFileNumber, , sStr
        If EOF(m_iFileNumber) Then
            Err.Raise iEOF_ERR, "CFile::ReadStr", "EOF"
        End If
    Else
        Err.Raise iEOF_ERR, "CFile::ReadStr", "EOF"
    End If
End Sub

' Upisuje sve objekte u datoteku
' Parametri:
'   obj         Objekat
Public Sub WriteFile(obj As Object)

    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Obrisi postojecu datoteku
    Kill m_sFileName

    ' Broj datoteke
    m_iFileNumber = FreeFile

    ' Otvori datoteku i uhvati eventualne greske
    Open m_sFileName For Binary As #m_iFileNumber
    Select Case Err.Number
        Case 0  ' Nema greske
            ' Upisi podatke
            obj.WriteFileData

        Case Else
            ' Prosledi gresku
            Err.Raise iOPEN_ERR, "CFile::WriteFile", "Greska prilikom otvaranja datoteke: " & Err.Description

    End Select

    ' Zatvori datoteku
    Close #m_iFileNumber
End Sub

' Upisi integer u datoteku
' Parametri:
'   iInt         integer koji se upisuje
Public Sub WriteInt(iInt As Integer)
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    Put #m_iFileNumber, , iInt
    If Err.Number Then
        Err.Raise iWRITE_ERR, "CFile::WriteInt", "Greska prilikom upisivanja: " & Err.Descpription
    End If
End Sub

' Upisuje string u datoteku
' Parametri
'   str         string koji se upisuje
Public Sub WriteStr(str As String)
Dim iLen As Integer

    ' Aktivira obradu gresaka
    On Error Resume Next

    ' Prvo se mora upisati duzina
    iLen = Len(str)
    Put #m_iFileNumber, , iLen
    If Err.Number Then
        Err.Raise iWRITE_ERR, "CFile::WriteStr", "Greska prilikom upisivanja: " & Err.Description
    Else
    
        ' a zatim sam string
        Put #m_iFileNumber, , str
        If Err.Number Then
            Err.Raise iWRITE_ERR, "CFile::WriteStr", "Greska prilikom upisivanja: " & Err.Description
        End If
    End If
End Sub


