VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTasks"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CTasks
' Autor:        Deborah Kurata
' Datum:        June 10, 1995
' Opis:         Radi sa kolekcijom CTask objekata.
'

Option Explicit

' PUBLIC: ******************************************
' Javni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

' Kolekcija zadataka
Private m_colTasks As New Collection

' Referenca na klasu za rad sa datotekama
Private File As CFile

' Broj clanova u kolekciji
Public Property Get Count() As Long
    Count = m_colTasks.Count
End Property

' Inicijalizacioni dogadjaj
Private Sub Class_Initialize()
    ' Procitaj podatke iz datoteke ako postoje
    Set File = New CFile
    File.FileName = App.Path & "\task.bin"
    File.ReadFile Me
End Sub

' Zavrsni dogadjaj
Private Sub Class_Terminate()
    ' Snimi podatke
    File.WriteFile Me

    ' Obrisi reference
    Set File = Nothing
End Sub

' Dodaje zadatak u kolekciju
' Parametri:
'   iPriority       prioritet zadatka
'   sDescription    string opis zadatka
' Vraca:
'   Task            objekat task
Public Function Add(iPriority As Integer, sDescription As String) As CTask
Dim Task As CTask

    ' Napravi primerak
    Set Task = New CTask

    With Task
        ' Postavi jedinstvenu sifru
        .ID = NextID

        ' Postavi prioritet i opis
        .Priority = iPriority
        .Description = sDescription
        
        ' Dodaj ga u kolekciju
        m_colTasks.Add Task, .ID
    End With

    ' Vrati zadatak koji je dodat
    Set Add = Task
End Function

' Ocisti kolekciju
Public Sub Clear()
    Set m_colTasks = Nothing
End Sub

' Clan kolekcije
' Parametri:
'   vkey         kljuc ili indeks clana
Public Function Item(vKey As Variant) As Object
    Set Item = m_colTasks.Item(vKey)
End Function

' Procitaj podatke iz datoteke
Public Sub ReadFileData()
Dim Task As CTask

    ' Ucitaj podatke u objekat
    Set Task = New CTask
    Task.ReadFileData File
    If Err.Number = 0 Then
        
        ' Postavi jedinstvenu sifru
        Task.ID = NextID
    
        ' Dodaj clana kolekciji
        m_colTasks.Add Task, Task.ID
    End If
End Sub

' Obrisi clana iz kolekcije
' Parametri:
'   vkey         kljuc ili indeks clana
Public Sub Remove(vKey As Variant)
    ' Obrisi clana
    m_colTasks.Remove vKey
End Sub

' Upisi podatke u datoteku
Public Sub WriteFileData()
Dim Task As CTask

    ' Upisi svaki clan
    For Each Task In m_colTasks
        Task.WriteFileData File
    Next
End Sub

' Sledeca slobodna sifra
' Vraca:
'   NextID      Sledeca slobodna sifra
Private Function NextID() As String
Static iID As Integer

    iID = iID + 1
    NextID = "T" & Format$(iID, "00000")

End Function


