VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTask"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CTask
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 9, 1995
' Opis:         Objekti zadaci sa opisima i
'               prioritetima.
' Izmene:

Option Explicit

' PUBLIC: ******************************************
' JAvni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

Private m_sDescription As String
Private m_iPriority As Integer

Private m_sID As String

Private m_dtCreated As Date

' PUBLIC: *****************************************
' JAvni potprogrami svojstva

' Opis zadatka
Public Property Let Description(sDescription As String)
Attribute Description.VB_Description = "Returns/sets the description of a task."
    m_sDescription = sDescription
End Property
Public Property Get Description() As String
    Description = m_sDescription
End Property

' Prioritet zadatka
Public Property Let Priority(iPriority As Integer)
    m_iPriority = iPriority
End Property
Public Property Get Priority() As Integer
    Priority = m_iPriority
End Property

' Sifra u kolekciji
' NAPOMENA: to mora biti jedinstven string koji se
' samo jedanput postavlja
Public Property Let ID(sID As String)
Static bAlreadySet As Boolean

    If Not bAlreadySet Then
        m_sID = sID
        bAlreadySet = True
    End If
End Property
Public Property Get ID() As String
    ID = m_sID
End Property

' Datum pravljenja, samo za citanje
Public Property Get Created() As Date
    Created = m_dtCreated
End Property

' Inicijalizacioni dogadjaj
Private Sub Class_Initialize()
    ' Postavi datum pravljenja
    m_dtCreated = Now
    
    ' Prikazi poruku
    MsgBox "Zadatak napravljen: " & Created
End Sub

' Zavrsni dogadjaj
Private Sub Class_Terminate()
    
    ' Prikazi poruku
    MsgBox "Zadatak: " & Created & " je obrisan."
End Sub

' PUBLIC: *****************************************
' Javni metodi

' PRIVATE: *****************************************
' Privatni metodi
' Cita podatke iz datoteke
Public Sub ReadFileData(File As CFile)
Dim iInt As Integer
Dim str As String

    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Procitaj prioritet
    File.ReadInt iInt
    If Err.Number Then
        Err.Raise Err.Number, "CTask::ReadFileData", Err.Description
    Else
        Priority = iInt
    
        ' Procitaj opis
        File.ReadStr str
        If Err.Number Then
            Err.Raise Err.Number, "CTask::ReadFileData", Err.Description
        Else
            Description = str
        End If
    End If
    
End Sub

' Upisuje podatke u datoteku
Public Sub WriteFileData(File As CFile)

    File.WriteInt Priority
    File.WriteStr Description
End Sub


