VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTask"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:            CTask
' Autor:                Deborah Kurata, InStep Technologies
' Datum:                June 9, 1995
' Opis:                 Zadaci sa opisom i
'                       prioritetom
' Revisions:

Option Explicit

' PRIVATE: *****************************************
' Privatni clanovi

Private m_sDescription As String
Private m_iPriority As Integer

Private m_dtCreated As Date

' Referenca na klasu za rad sa datotekama
Private File As CFile

' PUBLIC: *****************************************
' Javni potprogrami svojstva

' Opis zadatka
Public Property Let Description(sDescription As String)
    m_sDescription = sDescription
End Property
Public Property Get Description() As String
    Description = m_sDescription
End Property

' Prioritet zadatka
Public Property Let Priority(iPriority As Integer)
    ' Negativne vrednosti nisu dozvoljene
    If iPriority < 0 Then
        iPriority = 0
    End If

    m_iPriority = iPriority
End Property
Public Property Get Priority() As Integer
    Priority = m_iPriority
End Property

' Datum pravljenja, samo za citanje
Public Property Get Created() As Date
    Created = m_dtCreated
End Property

' Inicijalizacioni dogadjaj
Private Sub Class_Initialize()

    ' Postavi datum pravljenja
    m_dtCreated = Now
    
    ' Procitaj podatke iz datoteke, ako ih ima
    Set File = New CFile
    File.FileName = App.Path & "\task.bin"
    File.ReadFile Me
    
    ' Prikazi poruku
    MsgBox "Zadatak napravljen: " & Created
End Sub

' Zavrsni dogadjaj
Private Sub Class_Terminate()
    ' Snimi podatke
    File.WriteFile Me
    
    ' Ocisti reference
    Set File = Nothing
    
    ' Prikazi poruku
    MsgBox "Zadatak: " & Created & " je obrisan."
End Sub

' PUBLIC: *****************************************
' Javni metodi

' Povecaj/smanji prioritet
' Parametri:
'   iAmount         Promena prioriteta
Public Sub ChangePriority(iAmount As Integer)
    Priority = Priority + iAmount
End Sub

' Cita podatke iz datoteke
Public Sub ReadFileData()
Dim iInt As Integer
Dim str As String

    ' Procitaj prioritet
    File.ReadInt iInt
    If Err.Number = 0 Then
        Priority = iInt
    End If

    ' Procitaj opis
    File.ReadStr str
    If Err.Number = 0 Then
        Description = str
    End If
    
End Sub

' Upisuje podatke u datoteku
Public Sub WriteFileData()

    File.WriteInt Priority
    File.WriteStr Description
End Sub

