VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CFile"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CFile
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 12, 1995
' Opis:         Genericka klasa za rad sa
'               datotekama.
' Izmene:

Option Explicit

' PUBLIC: *****************************************
' Javni clanovi

' PRIVATE: *****************************************
' Privatni clanovi

' Putanja i ime datoteke
Private m_sFileName As String

' Broj otvorene datoteke
Private m_iFileNumber As Integer

' Greske
Const iOPEN_ERR = 1 + vbObjectError + 512
Const iEOF_ERR = 2 + vbObjectError + 512

Property Get FileName() As String
    FileName = m_sFileName
End Property
Property Let FileName(sFileName As String)
    ' Ovde bi trebalo proveriti putanju i ime
    m_sFileName = sFileName
End Property

' Cita podatke iz datoteke u objekat
' Parametri:
'   obj         Objekat koji se popunjava
Public Sub ReadFile(obj As Object)

    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    ' Broj datoteke
    m_iFileNumber = FreeFile
    
    ' Otvori datoteku i uhvati eventualnu gresku
    Open m_sFileName For Binary Access Read As #m_iFileNumber
    Select Case Err.Number
        Case 0  ' Nema greske
            ' Procitaj podatke
            Do Until EOF(m_iFileNumber)
                obj.ReadFileData
            Loop
        
        Case 53    ' Nema datoteke
            ' Ne radi nista
            
        Case Else
            ' Prijavi gresku
            Err.Raise iOPEN_ERR, "CFile::ReadFile", "Greska pri otvaranju datoteke."
            
    End Select

    ' Zatvori datoteku
    Close #m_iFileNumber
End Sub

' Cita integer vrednost iz datoteke
' Parametri:
'   iInt         integer procitan iz datoteke
Public Sub ReadInt(iInt As Integer)
    ' Aktiviraj obradu gresaka
    On Error Resume Next
    
    Get #m_iFileNumber, , iInt
    If EOF(m_iFileNumber) Then
        ' Prijavi gresku
        Err.Raise iEOF_ERR, "CFile::ReadInt", "Kraj datoteke."
    End If
End Sub

' Cita string iz datoteke
' Parametri:
'   str         string procitan iz datoteke
Public Sub ReadStr(sStr As String)
Dim iLen As Integer
    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Procitaj duzinu stringa
    Get #m_iFileNumber, , iLen
    If Not EOF(m_iFileNumber) Then
        sStr = String(iLen, " ")

        ' Ucitaj sam string
        Get #m_iFileNumber, , sStr
        If EOF(m_iFileNumber) Then
            ' Prijavi gresku
            Err.Raise iEOF_ERR, "CFile::ReadStr", "Kraj datoteke."
        End If
    Else
        ' Prijavi gresku
        Err.Raise iEOF_ERR, "CFile::ReadStr", "Kraj datoteke."
    End If
End Sub

' Upisuje objekte u datoteku.
' Parametri:
'   obj         Objekat
Public Sub WriteFile(obj As Object)

    ' Aktiviraj obradu gresaka
    On Error Resume Next

    ' Obrisi postojecu datoteku
    Kill m_sFileName
    ' Ako se desila greska, samo nastavi

    ' Broj datoteke
    m_iFileNumber = FreeFile

    ' Otvori datoteku i uhvati eventualne greske
    Open m_sFileName For Binary As #m_iFileNumber
    Select Case Err.Number
        Case 0  ' Nema greske
            ' Upisi podatke
            obj.WriteFileData

        Case Else
            ' Prijavi gresku
            Err.Raise iOPEN_ERR, "CFile::WriteFile", "Greska prilikom otvaranja datoteke."

    End Select

    ' Zatvori datoteku
    Close #m_iFileNumber
End Sub

' Upisuje integer u datoteku
' Parametri:
'   iInt         integer koji se upisuje
Public Sub WriteInt(iInt As Integer)
    Put #m_iFileNumber, , iInt
End Sub

' Upisuje string u datoteku
' Parametri
'   str         string koji se upisuje
Public Sub WriteStr(str As String)
Dim iLen As Integer

    ' Prvo treba upisati duzinu
    iLen = Len(str)
    Put #m_iFileNumber, , iLen
    
    ' A onda sam string
    Put #m_iFileNumber, , str
End Sub

