VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTask"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Ime klase:    CTask
' Autor:        Deborah Kurata, InStep Technologies
' Datum:        June 9, 1995
' Opis:         Objekti zadaci koji imaju opis i
'               prioritet.
' Izmene:

Option Explicit

' PUBLIC: ******************************************
' Javni clanovi podaci

' PRIVATE: *****************************************
' Privatni clanovi podaci

Private m_sDescription As String
Private m_iPriority As Integer

Private m_dtCreated As Date


' PUBLIC: *****************************************
' Javni potprogrami svojstva

' Opis zadatka
Public Property Let Description(sDescription As String)
Attribute Description.VB_Description = "Returns/sets the description of a task."
    m_sDescription = sDescription
End Property
Public Property Get Description() As String
    Description = m_sDescription
End Property

' Prioritet zadatka
Public Property Let Priority(iPriority As Integer)
    ' Negativne vrednosti nisu dozvoljene
    If iPriority < 0 Then
        iPriority = 0
    End If

    m_iPriority = iPriority
End Property
Public Property Get Priority() As Integer
    Priority = m_iPriority
End Property

' Datum pravljenja, samo za citanje
Public Property Get Created() As Date
    Created = m_dtCreated
End Property

' Inicijalizacioni dogadjaj
Private Sub Class_Initialize()
    ' Postavi datum kreiranja
    m_dtCreated = Now

    ' Prikazi poruku u okviru
    MsgBox "Zadatak kreiran: " & Created
End Sub

' Zavrsni dogadjaj
Private Sub Class_Terminate()
    ' Prikazi poruku u okviru
    MsgBox "Zadatak je bio: " & Me.Description _
           & "  Prioritet: " & Me.Priority
    MsgBox "Zadatak: " & Created & " je obrisan"
End Sub

' PUBLIC: *****************************************
' Javni metodi

' Povecaj/smanji prioritet prioritet
' Parametri:
'   iAmount         Promena prioriteta
Public Sub ChangePriority(iAmount As Integer)
Attribute ChangePriority.VB_Description = "Menja prioritet zadatka. Ako se preda negativna vrednost, prioritet se smanjuje."
    Priority = Priority + iAmount
End Sub
