import { connect } from "react-redux";
import Counter from "./Counter";

// Uparivanje Reduxovog stanja sa  svojstvima komponente
function mapStateToProps(state) {
  return {
    countValue: state.count
  };
}

// Akcija
var increaseAction = { type: "increase" };
var decreaseAction = { type: "decrease" };

// Uparivanje Reduxovih akcija sa svojstvima komponente
function mapDispatchToProps(dispatch) {
  return {
    increaseCount: function() {
      return dispatch(increaseAction);
    },
    decreaseCount: function() {
      return dispatch(decreaseAction);
    }
  };
}

// Komponenta viöeg reda
var connectedComponent = connect(
  mapStateToProps,
  mapDispatchToProps
)(Counter);

export default connectedComponent;
