import React, { Component } from "react";
import MenuButton from "./MenuButton";
import Menu from "./Menu";

class MenuContainer extends Component {

  constructor(props) {
    super(props);

    this.state = {
      visible: false
    };

    this.handleMouseDown = this.handleMouseDown.bind(this);
    this.toggleMenu = this.toggleMenu.bind(this);
  }

  handleMouseDown(e) {
   this.toggleMenu();

   console.log("clicked");
   e.stopPropagation();
  }


  toggleMenu() {
    this.setState({
      visible: !this.state.visible
    });
  }


  render() {
    return (
      <div>
        <MenuButton handleMouseDown={this.handleMouseDown} />
        <Menu handleMouseDown={this.handleMouseDown}
              menuVisibility={this.state.visible} />
        <div>
          <p>Kojoj stavci nije mesto u spisku?</p>
          <ul>
            <li>Jabuka</li>
            <li>Kruška</li>
            <li>Kajsija</li>
            <li>Šljiva</li>
            <li>Ananas</li>
            <li>Lubenica</li>
            <li>Urma</li>
          </ul>
        </div>
      </div>
    );
  }
}

export default MenuContainer;
