def make_crazy_lib(filename):
    try:
        file = open(filename, 'r')
        text = ''
        for line in file:
            text = text + process_line(line)
            file.close()
        return text

    except FileNotFoundError:
        print("Žalim, nije pronađeno", filename + '.')
    except IsADirectoryError:
        print("Žalim", filename, 'je direktorijum.')
    except:
        print("Žalim, ne mogu da pročitam", filename)

placeholders = ['NOUN', 'ADJECTIVE', 'VERB_ING', 'VERB']

def process_line(line):
    global placeholders
    processed_line = ''

    words = line.split()

    for word in words:
        stripped = word.strip('.,;?!')
        if stripped in placeholders:
            answer = input('Unesite ' + stripped + ":") processed_line = processed_line + answer
            if word[-1] in '.,;?!':
                processed_line = processed_line + word[-1] + ' ' else:processed_line = processed_line + ' '
            else:
                processed_line = processed_line + word + ' ' return processed_line + '\n'

def save_crazy_lib(filename, text):
    try:file = open(filename, 'w')
    file.write(text)
    file.close()
except:
    print("Žalim, ne mogu da upišem datoteku.", filename)

def main():
    filename = 'lib.txt'
    lib = make_crazy_lib(filename)

    if (lib != None):
        save_crazy_lib('crazy_' + filename, lib)

if __name__ == '__main__':
    main()
