unit Sort_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Menus, Sort_m;

type
  TobrSort = class(TForm)
    mngGlavni: TMainMenu;
    mnsMetoda: TMenuItem;
    mnsMetodaIzbor: TMenuItem;
    mnsMetodaUmetanje: TMenuItem;
    mnsDuzina: TMenuItem;
    mnsDuzina10: TMenuItem;
    mnsDuzina20: TMenuItem;
    mnsDuzina50: TMenuItem;
    mnsDuzina100: TMenuItem;
    mnsDuzina200: TMenuItem;
    mnsDuzina500: TMenuItem;
    mnsDuzina1000: TMenuItem;
    mnsDuzina2000: TMenuItem;
    mnsDuzina5000: TMenuItem;
    mnsDuzina10000: TMenuItem;
    mnsRadi: TMenuItem;
    mnsRadiPravi: TMenuItem;
    mnsRadiUredi: TMenuItem;
    ploStatus: TPanel;
    rezMetoda: TLabel;
    rezDuzina: TLabel;
    dgpPravi: TSpeedButton;
    dgpUredi: TSpeedButton;
    rezTrajanje: TLabel;
    lstNiz: TListBox;
    procedure mnsMetodaClick(Sender: TObject);
    procedure mnsDuzinaClick(Sender: TObject);
    procedure mnsRadiPraviClick(Sender: TObject);
    procedure mnsRadiUrediClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    procedure Prikazi;
  public
    { Public declarations }
  end;

var
  obrSort: TobrSort;

implementation

{$R *.DFM}

const
  MAX = 10000;
  Klica: Cardinal = 13;
  Metoda: TMetoda = MetodaIzbora;
  Duzina: Integer = 10;

var
  Niz: array [1..MAX] of Word;

procedure TobrSort.mnsMetodaClick(Sender: TObject);
var
  Stavka: TMenuItem;
begin
  Stavka := Sender as TMenuItem;
  Stavka.Checked := True;
  rezMetoda.Caption := Stavka.Caption;
  Metoda := Metode[mnsMetoda.IndexOf (Stavka)]
end;

procedure TobrSort.mnsDuzinaClick(Sender: TObject);
var
  Stavka: TmenuItem;
begin
  Stavka := Sender as TMenuItem;
  Stavka.Checked := True;
  rezDuzina.Caption := Stavka.Caption;
  Duzina := StrToInt (Stavka.Caption)
end;

procedure TobrSort.mnsRadiPraviClick(Sender:TObject);
var
  I: Integer;
begin
  for I := 1 to Duzina do
  begin
    Klica  := Klica * 314159261 + 907633385;
    Niz[I] := Klica;
  end;
  rezTrajanje.Caption := '';
  Prikazi;
end;

procedure TobrSort.mnsRadiUrediClick(Sender:TObject);
var
  T1, T2, T: Real;
begin
  T1 := Now;
  Metoda (Niz, Duzina);
  T2 := Now;
  T  := (T2 - T1) * 86400;
  rezTrajanje.Caption := Format ('%.4f s', [T]);
  Prikazi
end;

procedure TobrSort.Prikazi;
var
  I: Integer;
begin
  lstNiz.Clear;
  for I := 1 to Duzina do
    lstNiz.Items.Add (IntToStr (Niz[I]))
end;

procedure TobrSort.FormResize(Sender: TObject);
begin
  lstNiz.Columns := lstNiz.Width div 40
end;

end.
