unit Slike_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtDlgs, Menus, Buttons, ExtCtrls;

type
  TobrSlike = class(TForm)
    mngSlike: TMainMenu;
    mnsDatoteka: TMenuItem;
    mnsDatOtvori: TMenuItem;
    mnsDatSnimi: TMenuItem;
    mnsDatZatvori: TMenuItem;
    mnsDat_1: TMenuItem;
    mnsDatKraj: TMenuItem;
    mnsVelicina: TMenuItem;
    mnsVelJedan: TMenuItem;
    mnsVel_1: TMenuItem;
    mnsVelPovecaj: TMenuItem;
    mnsVelSmanji: TMenuItem;
    mnsProzori: TMenuItem;
    mnsProVodoravno: TMenuItem;
    mnsProUspravno: TMenuItem;
    mnsProPreklopljeno: TMenuItem;
    mnsPro_1: TMenuItem;
    mnsProSrediSlicice: TMenuItem;
    dlgOtvori: TOpenPictureDialog;
    dlgSnimi: TSavePictureDialog;
    ploKomande: TPanel;
    dgsDatSnimi: TSpeedButton;
    dgsDatOtvori: TSpeedButton;
    dgsDatZatvori: TSpeedButton;
    dgsVelSmanji: TSpeedButton;
    dgsVelJedan: TSpeedButton;
    dgsVelPovecaj: TSpeedButton;
    staSlike: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure mnsDatOtvoriClick(Sender: TObject);
    procedure mnsDatSnimiClick(Sender: TObject);
    procedure mnsDatZatvoriClick(Sender: TObject);
    procedure mnsDatKrajClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mnsVelJedanClick(Sender: TObject);
    procedure mnsVelPovecajClick(Sender: TObject);
    procedure mnsVelSmanjiClick(Sender: TObject);
    procedure mnsProVodoravnoClick(Sender: TObject);
    procedure mnsProUspravnoClick(Sender: TObject);
    procedure mnsProPreklopljenoClick(Sender: TObject);
    procedure mnsProSrediSliciceClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure PrikaziBroj (Broj: Integer);
    procedure OmoguciKomande (Stanje: Boolean);
  end;

var
  obrSlike: TobrSlike;

implementation

{$R *.DFM}

uses
  Slika_o;

procedure TobrSlike.PrikaziBroj (Broj: Integer);
begin
  if Broj = 1
    then staSlike.Panels[1].Text := Format('%d prozor', [Broj])
    else staSlike.Panels[1].Text := Format('%d prozora',[Broj])
end;

procedure TobrSlike.OmoguciKomande (Stanje: Boolean);
begin
  mnsDatSnimi.Enabled   := Stanje;
  mnsDatZatvori.Enabled := Stanje;
  mnsVelicina.Enabled   := Stanje;
  dgsDatSnimi.Enabled   := Stanje;
  dgsDatZatvori.Enabled := Stanje;
  dgsVelSmanji.Enabled  := Stanje;
  dgsVelJedan.Enabled   := Stanje;
  dgsVelPovecaj.Enabled := Stanje;
end;

procedure TobrSlike.FormCreate(Sender: TObject);
begin
  OmoguciKomande (False)
end;

procedure TobrSlike.FormResize(Sender: TObject);
begin
  staSlike.Panels[0].Width := staSlike.Width - 100;
end;

procedure TobrSlike.mnsDatOtvoriClick(Sender: TObject);
var
  Nova: TobrSlika;
begin
  if dlgOtvori.Execute then
  begin
    Nova                  := TobrSlika.Create (Self);
    Nova.Caption          := dlgOtvori.FileName;
    Nova.sliSlika.Picture.LoadFromFile (Nova.Caption);
    Nova.ClientWidth      := Nova.sliSlika.Picture.Width;
    Nova.ClientHeight     := Nova.sliSlika.Picture.Height;
    OmoguciKomande (True);
    PrikaziBroj (MDIChildCount)
  end
end;

procedure TobrSlike.mnsDatSnimiClick(Sender: TObject);
var
  Slika: TobrSlika;
begin
  Slika := ActiveMDIChild as TobrSlika;
  dlgSnimi.FileName       := Slika.Caption;
  if dlgSnimi.Execute then
  begin
    Slika.Caption         := dlgSnimi.FileName;
    Slika.sliSlika.Picture.SaveToFile (Slika.Caption)
  end
end;

procedure TobrSlike.mnsDatZatvoriClick(Sender: TObject);
begin
  (ActiveMDIChild as TobrSlika).Close
end;

procedure TobrSlike.mnsDatKrajClick(Sender: TObject);
begin
  Close
end;

procedure TobrSlike.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if MessageDlg ('Zavriti sa radom?', mtConfirmation,
                 [mbYes, mbNo], 0) = mrYes
  then Action := caFree
  else Action := caNone
end;

procedure TobrSlike.mnsVelJedanClick(Sender: TObject);
var
  Slika: TobrSlika;
begin
  Slika              := ActiveMDIChild as TobrSlika;
  Slika.ClientWidth  := Slika.sliSlika.Picture.Width;
  Slika.ClientHeight := Slika.sliSlika.Picture.Height
end;

procedure TobrSlike.mnsVelPovecajClick(Sender: TObject);
var
  Slika: TobrSlika;
  Faktor: string;
  F: Integer;
begin
  Faktor := '2';
  if InputQuery ('Promena veliine',
                 'Faktor poveanja:', Faktor) then
  begin
    F                 := StrToInt (Faktor);
    Slika             := ActiveMDIChild as TobrSlika;
    Slika.ClientWidth :=Slika.sliSlika.Picture.Width  * F;
    Slika.ClientHeight:=Slika.sliSlika.Picture.Height * F
  end
end;

procedure TobrSlike.mnsVelSmanjiClick(Sender: TObject);
var
  Slika: TobrSlika;
  Faktor: string;
  F: Integer;
begin
  Faktor := '2';
  if InputQuery ('Promena veliine',
                 'Faktor smanjenja:', Faktor) then
  begin
    F                 := StrToInt (Faktor);
    Slika             := ActiveMDIChild as TobrSlika;
    Slika.ClientWidth :=Slika.sliSlika.Picture.Width  div F;
    Slika.ClientHeight:=Slika.sliSlika.Picture.Height div F
  end
end;

procedure TobrSlike.mnsProVodoravnoClick(Sender: TObject);
begin
  TileMode := tbHorizontal; Tile
end;

procedure TobrSlike.mnsProUspravnoClick(Sender: TObject);
begin
  TileMode := tbVertical; Tile
end;

procedure TobrSlike.mnsProPreklopljenoClick(Sender: TObject);
begin
  Cascade
end;

procedure TobrSlike.mnsProSrediSliciceClick(Sender: TObject);
begin
  ArrangeIcons
end;

end.
