unit Pascal_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Binko_m;

type
  TobrPascal = class(TForm)
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrPascal: TobrPascal;

implementation

{$R *.DFM}

procedure TobrPascal.FormKeyPress(Sender: TObject; var Key: Char);
var
  I, Nmax, N, K, Sirina, Levo, Gore: Integer;
  Oznaka: TLabel;
begin
  { Da li je pritisnut taster neke cifre? }
  if (Key >= '0') and (Key <= '9') then
  begin
    { Brisanje oznaka iz prethodnog kruga. }
    for I := ComponentCount-1 downto 0 do
      if Components[I] is TLabel then
        (Components[I] as TLabel).Free;
    { Podeavanje veliine prozora. }
    Nmax := StrToInt (Key);
    Sirina := (Nmax + 1) * 30;
    if Sirina < 114 then Sirina := 114;
    ClientWidth  := Sirina;
    ClientHeight := (Nmax + 1) * 16;
    { Sastavljanje Pascal-ovog trougla. }
    Gore := 0;
    for N := 0 to Nmax do
    begin
      Levo := Sirina div 2 -  N * 15 - 4;
      for K := 0 to N do
      begin
        { Formiranje oznake za sledei koeficijent. }
        Oznaka := TLabel.Create (Self);
        with Oznaka do
        begin
          Parent  := Self;
          Caption := IntToStr (BinKo (N, K));
          SetBounds (Levo, Gore, Width, Height);
        end;
        Levo := Levo + 30;
      end;
      Gore := Gore + 16
    end
  end
end;

end.
