unit Ocene_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids;

type
  TobrOcene = class(TForm)
    mreOcene: TStringGrid;
    vltVrste: TMemo;
    vltKolone: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure mreOceneSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure mreOceneSetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: string);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrOcene: TobrOcene;

implementation

{$R *.DFM}

procedure TobrOcene.FormCreate(Sender: TObject);
begin
  with mreOcene do
  begin
    ColCount := vltKolone.Lines.Count;
    RowCount := vltVrste.Lines.Count;
    Rows[0]  := vltKolone.Lines;
    Cols[0]  := vltVrste.Lines;
    ColWidths[0]          := vltVrste.Width;
    ColWidths[ColCount-1] := vltKolone.Width;
    Height   := RowCount * (DefaultRowHeight + 1) + 3;
    Width    := ColWidths[0] + ColWidths[ColCount-1] +
              (ColCount - 2) * (DefaultColWidth + 1) + 5;
    obrOcene.ClientWidth  := Width;
    obrOcene.ClientHeight := Height;
  end
end;

procedure TobrOcene.mreOceneSelectCell(Sender: TObject;
  ACol, ARow: Integer; var CanSelect: Boolean);
begin
  CanSelect := ACol <> mreOcene.ColCount - 1
end;

procedure TobrOcene.mreOceneSetEditText(Sender: TObject;
  ACol, ARow: Integer; const Value: string);
var
  Oc, Br, ZbBr, ZbOcBr: Integer;
begin
  ZbBr   := 0;
  ZbOcBr := 0;
  with mreOcene do
  begin
    for Oc := 1 to ColCount-2 do
      if Cells[Oc,ARow] <> '' then
      begin
        Br     := StrToInt (Cells[Oc,ARow]);
        ZbBr   := ZbBr + Br;
        ZbOcBr := ZbOcBr + Oc * Br;
      end;
    if ZbBr <> 0 then
      Cells[ColCount-1,ARow]:=Format('%5.2f',[ZbOcBr/ZbBr])
    else
      Cells[ColCount-1,ARow]:=''
  end
end;

end.
