unit Lissaj_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TobrLissajous = class(TForm)
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrLissajous: TobrLissajous;

implementation

{$R *.DFM}

procedure TobrLissajous.FormPaint(Sender: TObject);
const
  N = 500; A = 5; B = 7;
var
  Rx, Ry, X, Y, I: Integer;
  Fi, DFi: Real;
begin
  DFi := 2 * Pi / N;
  Rx  := ClientWidth  div 2;
  Ry  := ClientHeight div 2;
  Canvas.Pen.Width := 2;
  Canvas.MoveTo (2*Rx, 0);
  for I := 1 to N do
  begin
    Fi := I * Dfi;
    X  := Round (Rx + Rx * Cos (A * Fi));
    Y  := Round (Ry + Ry * Sin (B * Fi));
    Canvas.LineTo (X, Y);
  end;
end;

procedure TobrLissajous.FormResize(Sender: TObject);
begin
  Invalidate
end;

end.
