unit Koshit_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls;

type
  TobrKosiHitac = class(TForm)
    grpBrzina: TGroupBox;
    oznBrzina: TLabel;
    oznBrzJedinica: TLabel;
    regBrzina: TTrackBar;
    rdgMetSek: TRadioButton;
    rdgKmSat: TRadioButton;
    grpUgao: TGroupBox;
    oznUgao: TLabel;
    oznUgJedinica: TLabel;
    regUgao: TTrackBar;
    rdgRadijani: TRadioButton;
    rdgStepeni: TRadioButton;
    oznVreme: TLabel;
    oznDaljina: TLabel;
    oznVisina: TLabel;
    rezVreme: TLabel;
    rezDaljina: TLabel;
    rezVisina: TLabel;
    procedure regBrzinaChange(Sender: TObject);
    procedure regUgaoChange(Sender: TObject);
    procedure rdgMetSekClick(Sender: TObject);
    procedure rdgKmSatClick(Sender: TObject);
    procedure rdgRadijaniClick(Sender: TObject);
    procedure rdgStepeniClick(Sender: TObject);
  private
    { Private declarations }
    procedure Racunaj;
  public
    { Public declarations }
  end;

var
  obrKosiHitac: TobrKosiHitac;

implementation

{$R *.DFM}

procedure TobrKosiHitac.regBrzinaChange(Sender: TObject);
begin
  oznBrzina.Caption := IntToStr(regBrzina.Position);
  Racunaj
end;

procedure TobrKosiHitac.regUgaoChange(Sender: TObject);
begin
  if rdgRadijani.Checked then
    oznUgao.Caption := FloatToStr(regUgao.Position/100000)
  else
    oznUgao.Caption := IntToStr(regUgao.Position);
  Racunaj
end;

procedure TobrKosiHitac.Racunaj;
const G = 9.8062;
var   V, Fi, T: Real;
begin
  V := regBrzina.Position;
  if rdgKmSat.Checked then V := V / 3.6;
  if rdgRadijani.Checked then
    Fi := regUgao.Position / 100000.
  else
    Fi := regUgao.Position * Pi / 180;
  T := 2 * V / G * Sin (Fi);
  rezVreme.Caption   := FloatToStr (T) + ' s';
  rezDaljina.Caption := FloatToStr (T*V*Cos(Fi))   + ' m';
  rezVisina.Caption  := FloatToStr (T*V/4*Sin(Fi)) + ' m'
end;

procedure TobrKosiHitac.rdgMetSekClick(Sender: TObject);
var P: Integer;
begin
  if oznBrzJedinica.Caption = 'km/h' then
  begin
    oznBrzJedinica.Caption := 'm/s';
    P := Round (regBrzina.Position / 3.6);
    regBrzina.Max       := 100;
    regBrzina.Frequency := 10;
    regBrzina.Position  := P;
    regBrzinaChange (Sender)
  end
end;

procedure TobrKosiHitac.rdgKmSatClick(Sender: TObject);
var P: Integer;
begin
  if oznBrzJedinica.Caption = 'm/s' then
  begin
    oznBrzJedinica.Caption := 'km/h';
    P := Round (regBrzina.Position * 3.6);
    regBrzina.Max       := 360;
    regBrzina.Frequency := 50;
    regBrzina.Position  := P;
    regBrzinaChange (Sender)
  end
end;

procedure TobrKosiHitac.rdgRadijaniClick(Sender: TObject);
var P: Integer;
begin
  if oznUgJedinica.Caption = 'step' then
  begin
    oznUgJedinica.Caption := 'rad';
    P := Round (regUgao.Position * Pi / 0.00180);
    regUgao.Max       := 157079;
    regUgao.Frequency := 10000;
    regUgao.PageSize  := 10000;
    regUgao.LineSize  := 1000;
    regUgao.Position  := P;
    regUgaoChange (Sender)
  end
end;

procedure TobrKosiHitac.rdgStepeniClick(Sender: TObject);
var P: Integer;
begin
  if oznUgJedinica.Caption = 'rad' then
  begin
    oznUgJedinica.Caption := 'step';
    P := Round (regUgao.Position / Pi * 0.00180);
    regUgao.Max       := 90;
    regUgao.Frequency := 10;
    regUgao.PageSize  := 5;
    regUgao.LineSize  := 1;
    regUgao.Position  := P;
    regUgaoChange (Sender)
  end
end;

end.
