unit Kompon_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TobrKomponente = class(TForm)
    ploKomp: TPanel;
    dgm: TButton;
    tks: TEdit;
    pot: TCheckBox;
    rdg: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure ploKompClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrKomponente: TobrKomponente;

implementation

{$R *.DFM}

uses Clipbrd;

var CF_OBJECT: Word;

procedure TobrKomponente.FormCreate(Sender: TObject);
begin
  RegisterClasses ([TButton,TEdit,TCheckBox,TRadioButton]);
  dgm.Name  := '';
  tks.Name  := '';
  pot.Name  := '';
  rdg.Name  := '';
  CF_OBJECT := RegisterClipBoardFormat ('Delphi Component');
end;

procedure TobrKomponente.ploKompClick(Sender: TObject);
begin
  if      Sender is TCheckBox then
    (Sender as TCheckBox   ).Checked := False
  else if Sender is TRadioButton then
    (Sender as TRadioButton).Checked := False;
  Clipboard.SetComponent (Sender as TComponent);
end;

procedure TobrKomponente.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Komp: TComponent;
begin
  if Clipboard.HasFormat (CF_OBJECT) then
  begin
    Komp := ClipBoard.GetComponent (Self, Self);
    (Komp as TControl).Left := X;
    (Komp as TControl).Top  := Y;
  end
end;

end.
