unit Kompl_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Kompl_m;

type
  TobrKompleks = class(TForm)
    oznRe: TLabel;
    oznIm: TLabel;
    tksPrviRe: TEdit;
    tksPrviIm: TEdit;
    tksDrugiRe: TEdit;
    tksDrugiIm: TEdit;
    oznPrvi: TLabel;
    oznDrugi: TLabel;
    oznRezultat: TLabel;
    rezRe: TLabel;
    rezIm: TLabel;
    dgmZbir: TButton;
    dgmRazlika: TButton;
    dgmProizvod: TButton;
    dgmKolicnik: TButton;
    procedure dgmRacunajClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrKompleks: TobrKompleks;

implementation

{$R *.DFM}

procedure TobrKompleks.dgmRacunajClick(Sender: TObject);
var
  A, B, C: TKompleks;
begin
  A := TKompleks.Create;
  B := TKompleks.Create;
  C := TKompleks.Create;
  try
    A.Kompleksni (StrToFloat (tksPrviRe.Text),
                  StrToFloat (tksPrviIm.Text));
    B.Kompleksni (StrToFloat (tksDrugiRe.Text),
                  StrToFloat (tksDrugiIm.Text));
    case (Sender as TButton).Caption[1] of
      'Z': C.Zbir     (A, B);
      'R': C.Razlika  (A, B);
      'P': C.Proizvod (A, B);
      'K': C.Kolicnik (A, B)
    end;
    oznRezultat.Caption:=(Sender as TButton).Caption + ':';
    rezRe.Caption := FloatToStr (C.Realni    );
    rezIm.Caption := FloatToStr (C.Imaginarni)
  finally
    A.Free; B.Free; C.Free
  end
end;

end.
