unit Kalend_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, Grids, Calendar;

type
  TobrKalendar = class(TForm)
    kstKalendar: TPageControl;
    strKalendar: TTabSheet;
    strCasovnik: TTabSheet;
    strStoperica: TTabSheet;
    kalKalendar: TCalendar;
    Kalendar: TPanel;
    oznDan: TLabel;
    oznMes: TLabel;
    oznGod: TLabel;
    tksDan: TEdit;
    tksMes: TEdit;
    tksGod: TEdit;
    broDan: TUpDown;
    broMes: TUpDown;
    broGod: TUpDown;
    rezVreme: TLabel;
    rezDatum: TLabel;
    rezProslo: TLabel;
    dgmKreni: TButton;
    dgmStani: TButton;
    dgmNastavi: TButton;
    casVreme: TTimer;
    casStoperica: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure kstKalendarChange(Sender: TObject);
    procedure brojaciClick(Sender: TObject; Button: TUDBtnType);
    procedure kalKalendarChange(Sender: TObject);
    procedure casVremeTimer(Sender: TObject);
    procedure dgmKreniClick(Sender: TObject);
    procedure dgmStaniClick(Sender: TObject);
    procedure dgmNastaviClick(Sender: TObject);
    procedure casStopericaTimer(Sender: TObject);
  private
    { Private declarations }
    Pocetak: Real;
    procedure Danas;
  public
    { Public declarations }
  end;

var
  obrKalendar: TobrKalendar;

implementation

{$R *.DFM}

procedure TobrKalendar.Danas;
var G, M, D: Word;
begin
  DecodeDate (Now, G, M, D);
  with kalKalendar do
  begin
    Year := G; Month := M; Day := D
  end;
  broGod.Position := G;
  broMes.Position := M;
  broDan.Position := D;
end;

procedure TobrKalendar.FormCreate(Sender: TObject);
begin
  Danas;  Pocetak := Now;
end;

procedure TobrKalendar.kstKalendarChange(Sender: TObject);
begin
  casVreme.Enabled     := False;
  casStoperica.Enabled := False;
  case kstKalendar.ActivePage.PageIndex of
  0: begin Caption := 'Kalendar'; Danas end;
  1: begin Caption := 'Vreme'; casVreme.Enabled := True end;
  2:       Caption := 'Proteklo';
  end
end;

procedure TobrKalendar.brojaciClick(Sender: TObject; Button: TUDBtnType);
begin
  with kalKalendar do
  begin
    Year  := broGod.Position;
    Month := broMes.Position;
    Day   := broDan.Position
  end
end;

procedure TobrKalendar.kalKalendarChange(Sender: TObject);
begin
  if kalKalendar.Focused then broDan.Position:=kalKalendar.Day
end;

procedure TobrKalendar.casVremeTimer(Sender: TObject);
begin
  rezVreme.Caption := TimeToStr (Now);
  rezDatum.Caption := DateToStr (Now)
end;

procedure TobrKalendar.dgmKreniClick(Sender: TObject);
begin
  Pocetak := Now;
  casStoperica.Enabled := True;
end;

procedure TobrKalendar.dgmStaniClick(Sender: TObject);
begin
  casStoperica.Enabled := False;
end;

procedure TobrKalendar.dgmNastaviClick(Sender: TObject);
begin
  casStoperica.Enabled := True;
end;

procedure TobrKalendar.casStopericaTimer(Sender: TObject);
begin
  rezProslo.Caption := Format('%.1f',[(Now-Pocetak)*86400]);
end;

end.
