unit Edit_o;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TobrEditor = class(TForm)
    ploGlavna: TPanel;
    vltTekst: TMemo;
    oznDatoteka: TLabel;
    tksDatoteka: TEdit;
    dgmOtvori: TButton;
    dgmSnimi: TButton;
    dgmNova: TButton;
    oznVrsta: TLabel;
    kotVrsta: TComboBox;
    oznVelicina: TLabel;
    rezVelicina: TLabel;
    regVelicina: TTrackBar;
    grpStil: TGroupBox;
    potPolucrno: TCheckBox;
    potKurzivom: TCheckBox;
    potPodvuceno: TCheckBox;
    procedure tksDatotekaChange(Sender: TObject);
    procedure dgmOtvoriClick(Sender: TObject);
    procedure dgmSnimiClick(Sender: TObject);
    procedure dgmNovaClick(Sender: TObject);
    procedure kotVrstaChange(Sender: TObject);
    procedure regVelicinaChange(Sender: TObject);
    procedure potPolucrnoClick(Sender: TObject);
    procedure potKurzivomClick(Sender: TObject);
    procedure potPodvucenoClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrEditor: TobrEditor;

implementation

{$R *.DFM}

procedure TobrEditor.tksDatotekaChange(Sender: TObject);
begin
  if tksDatoteka.Text = '' then
    Caption := 'Editor'
  else
    Caption := 'Editor - ' + tksDatoteka.Text
end;

procedure TobrEditor.dgmOtvoriClick(Sender: TObject);
begin
  if tksDatoteka.Text = '' then
    tksDatoteka.SetFocus
  else
  begin
    vltTekst.Lines.LoadFromFile (tksDatoteka.Text);
    vltTekst.Modified := False;
    vltTekst.SetFocus
  end
end;

procedure TobrEditor.dgmSnimiClick(Sender: TObject);
begin
  if tksDatoteka.Text = '' then
    tksDatoteka.SetFocus
  else if vltTekst.Modified then
  begin
    vltTekst.Lines.SaveToFile (tksDatoteka.Text);
    vltTekst.Modified := False;
    vltTekst.SetFocus
  end
end;

procedure TobrEditor.dgmNovaClick(Sender: TObject);
begin
  tksDatoteka.Text := '';
  vltTekst.Clear;
  vltTekst.Modified := False;
  vltTekst.SetFocus
end;

procedure TobrEditor.kotVrstaChange(Sender: TObject);
begin
  vltTekst.Font.Name := kotVrsta.Text
end;

procedure TobrEditor.regVelicinaChange(Sender: TObject);
begin
  rezVelicina.Caption := IntToStr (regVelicina.Position);
  vltTekst.Font.Size  := regVelicina.Position
end;

procedure TobrEditor.potPolucrnoClick(Sender: TObject);
begin
  if potPolucrno.Checked then
    vltTekst.Font.Style := vltTekst.Font.Style + [fsBold]
  else
    vltTekst.Font.Style := vltTekst.Font.Style - [fsBold]
end;

procedure TobrEditor.potKurzivomClick(Sender: TObject);
begin
  if potKurzivom.Checked then
    vltTekst.Font.Style := vltTekst.Font.Style + [fsItalic]
  else
    vltTekst.Font.Style := vltTekst.Font.Style - [fsItalic]
end;

procedure TobrEditor.potPodvucenoClick(Sender: TObject);
begin
  if potPodvuceno.Checked then
    vltTekst.Font.Style := vltTekst.Font.Style+[fsUnderline]
  else
    vltTekst.Font.Style := vltTekst.Font.Style-[fsUnderline]
end;

end.
