unit Statis_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TobrStatist = class(TForm)
    tksSledeci: TEdit;
    dgmDodaj: TButton;
    OznSledeci: TLabel;
    oznBroj: TLabel;
    oznSrednja: TLabel;
    oznDevijacija: TLabel;
    rezBroj: TLabel;
    rezSrednja: TLabel;
    rezDevijacija: TLabel;
    dgmBrisi: TButton;
    procedure dgmDodajClick(Sender: TObject);
    procedure dgmBrisiClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrStatist: TobrStatist;

implementation

{$R *.DFM}

const
  broj:      Integer = 0;
  Zbir:      Real    = 0;
  ZbirKvadr: Real    = 0;

procedure TobrStatist.dgmDodajClick(Sender: TObject);
var
  Sledeci, Srednja, Devijacija: Real;
begin
  Sledeci    := StrToFloat (tksSledeci.Text);
  Broj       := Broj + 1;
  Zbir       := Zbir + Sledeci;
  ZbirKvadr  := ZbirKvadr + Sledeci * Sledeci;
  Srednja    := Zbir / Broj;
  Devijacija := Sqrt(ZbirKvadr/Broj - Srednja*Srednja);
  rezBroj.Caption       := IntToStr (Broj);
  rezSrednja.Caption    := FloatToStr (Srednja);
  rezDevijacija.Caption := FloatToStr (Devijacija)
end;

procedure TobrStatist.dgmBrisiClick(Sender: TObject);
begin
  Broj      := 0;
  Zbir      := 0;
  ZbirKvadr := 0;
  rezBroj.Caption       := '0';
  rezSrednja.Caption    := '0';
  rezDevijacija.Caption := '0';
  tksSledeci.Text       := '0'
end;

end.
