unit Sort_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Menus, Sort_m, Buttons, ExtCtrls;

type
  TobrSort = class(TForm)
    mngGlavni: TMainMenu;
    mnsMetoda: TMenuItem;
    mnsMetodaIzbor: TMenuItem;
    mnsMetodaUmetanje: TMenuItem;
    mnsDuzina: TMenuItem;
    mnsDuzina10: TMenuItem;
    mnsDuzina20: TMenuItem;
    mnsDuzina50: TMenuItem;
    mnsDuzina100: TMenuItem;
    mnsDuzina200: TMenuItem;
    mnsDuzina500: TMenuItem;
    mnsDuzina1000: TMenuItem;
    mnsDuzina2000: TMenuItem;
    mnsDuzina5000: TMenuItem;
    mnsRadi: TMenuItem;
    mnsRadiPravi: TMenuItem;
    mnsRadiUredi: TMenuItem;
    ploStatus: TPanel;
    rezMetoda: TLabel;
    rezDuzina: TLabel;
    dgpPravi: TSpeedButton;
    dgpUredi: TSpeedButton;
    rezTrajanje: TLabel;
    lstNiz: TListBox;
    procedure mnsMetodaClick(Sender: TObject);
    procedure mnsDuzinaClick(Sender: TObject);
    procedure mnsRadiPraviClick(Sender: TObject);
    procedure mnsRadiUrediClick(Sender: TObject);
  private
    { Private declarations }
    procedure Prikazi;
  public
    { Public declarations }
  end;

var
  obrSort: TobrSort;

implementation

{$R *.DFM}

const
  MAX = 5000;
  Klica: Word = 13;
  IndeksMetode: Integer = 0;
  Metoda: TMetoda = MetodaIzbora;
  IndeksDuzine: Integer = 0;
  Duzina: Integer = 10;

var
  Niz: array [1..MAX] of Word;

procedure TobrSort.mnsMetodaClick(Sender: TObject);
begin
  mnsMetoda.Items[IndeksMetode].Checked := False;
  (Sender as TMenuItem).Checked := True;
  rezMetoda.Caption := (Sender as TMenuItem).Caption;
  IndeksMetode := mnsMetoda.IndexOf (Sender as TMenuItem);
  Metoda := Metode[IndeksMetode]
end;

procedure TobrSort.mnsDuzinaClick(Sender: TObject);
begin
  mnsDuzina.Items[IndeksDuzine].Checked := False;
  (Sender as TMenuItem).Checked := True;
  rezDuzina.Caption := (Sender as TMenuItem).Caption;
  IndeksDuzine := mnsDuzina.IndexOf (Sender as TMenuItem);
  Duzina := StrToInt ((Sender as TMenuItem).Caption)
end;

procedure TobrSort.mnsRadiPraviClick(Sender:TObject);
var
  I: Integer;
begin
  for I := 1 to Duzina do
  begin
    Klica := Klica * 31405 + 13849;
    Niz[I] := Klica;
  end;
  rezTrajanje.Caption := '';
  Prikazi;
end;

procedure TobrSort.mnsRadiUrediClick(Sender:TObject);
var
  T1, T2, T: Real;
begin
  T1 := Now;
  Metoda (Niz, Duzina);
  T2 := Now;
  T  := (T2 - T1) * 86400;
  rezTrajanje.Caption := Format ('%.4f s', [T]);
  Prikazi
end;

procedure TobrSort.Prikazi;
var
  I: Integer;
begin
  lstNiz.Clear;
  for I := 1 to Duzina do
    lstNiz.Items.Add (IntToStr (Niz[I]))
end;

end.
