unit Slike_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Buttons, ExtCtrls;

type
  TobrSlike = class(TForm)
    mngSlike: TMainMenu;
    mnsDatoteka: TMenuItem;
    mnsDatOtvori: TMenuItem;
    mnsDatSnimi: TMenuItem;
    mnsDatZatvori: TMenuItem;
    mnsDat_1: TMenuItem;
    mnsDatKraj: TMenuItem;
    mnsVelicina: TMenuItem;
    mnsVelJedan: TMenuItem;
    mnsVel_1: TMenuItem;
    mnsVelSmanji: TMenuItem;
    mnsVelPovecaj: TMenuItem;
    mnsProzori: TMenuItem;
    mnsProVodoravno: TMenuItem;
    mnsProUspravno: TMenuItem;
    mnsProKaskadno: TMenuItem;
    mnsPro_1: TMenuItem;
    mnsProSredi: TMenuItem;
    dlgOtvori: TOpenDialog;
    dlgSnimi: TSaveDialog;
    ploKomande: TPanel;
    ploStatus: TPanel;
    ploBroj: TPanel;
    ploUputstvo: TPanel;
    dgsDatOtvori: TSpeedButton;
    dgsDatSnimi: TSpeedButton;
    dgsDatZatvori: TSpeedButton;
    dgsVelSmanji: TSpeedButton;
    dgsVelJedan: TSpeedButton;
    dgsVelPovecaj: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure mnsDatOtvoriClick(Sender: TObject);
    procedure mnsDatSnimiClick(Sender: TObject);
    procedure mnsDatZatvoriClick(Sender: TObject);
    procedure mnsDatKrajClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mnsVelJedanClick(Sender: TObject);
    procedure mnsVelPovecajClick(Sender: TObject);
    procedure mnsVelSmanjiClick(Sender: TObject);
    procedure mnsProVodoravnoClick(Sender: TObject);
    procedure mnsProUspravnoClick(Sender: TObject);
    procedure mnsProKaskadnoClick(Sender: TObject);
    procedure mnsProSrediClick(Sender: TObject);
  private
    { Private declarations }
    procedure PrikaziUputstvo (Sender: TObject);
  public
    { Public declarations }
    procedure PrikaziBroj (Broj: Integer);
    procedure OmoguciKomande (Stanje: Boolean);
  end;

var
  obrSlike: TobrSlike;

implementation

{$R *.DFM}

uses
  Slika_o;

procedure TobrSlike.PrikaziUputstvo (Sender: TObject);
begin
  ploUputstvo.Caption := Application.Hint
end;

procedure TobrSlike.PrikaziBroj (Broj: Integer);
begin
  if Broj = 1
    then ploBroj.Caption := Format('%d prozor', [broj])
    else ploBroj.Caption := Format('%d prozora',[broj])
end;

procedure TobrSlike.OmoguciKomande (Stanje: Boolean);
begin
  mnsDatSnimi.Enabled   := Stanje;
  mnsDatZatvori.Enabled := Stanje;
  mnsVelicina.Enabled   := Stanje;
  dgsDatSnimi.Enabled   := Stanje;
  dgsDatZatvori.Enabled := Stanje;
  dgsVelSmanji.Enabled  := Stanje;
  dgsVelJedan.Enabled   := Stanje;
  dgsVelPovecaj.Enabled := Stanje;
end;

procedure TobrSlike.FormCreate(Sender: TObject);
begin
  Application.OnHint := PrikaziUputstvo;
  OmoguciKomande (False)
end;

procedure TobrSlike.mnsDatOtvoriClick(Sender: TObject);
var
  Nova: TobrSlika;
begin
  if dlgOtvori.Execute then
  begin
    Nova                  := TobrSlika.Create (Self);
    Nova.Caption          := dlgOtvori.FileName;
    Nova.sliSlika.Picture.LoadFromFile (Nova.Caption);
    Nova.ClientWidth      := Nova.sliSlika.Picture.Width;
    Nova.ClientHeight     := Nova.sliSlika.Picture.Height;
    OmoguciKomande (True);
    PrikaziBroj (MDIChildCount)
  end
end;

procedure TobrSlike.mnsDatSnimiClick(Sender: TObject);
var
  Slika: TobrSlika;
begin
  Slika := ActiveMDIChild as TobrSlika;
  dlgSnimi.FileName       := Slika.Caption;
  if dlgSnimi.Execute then
  begin
    Slika.Caption         := dlgSnimi.FileName;
    Slika.sliSlika.Picture.SaveToFile (Slika.Caption)
  end
end;

procedure TobrSlike.mnsDatZatvoriClick(Sender: TObject);
begin
  (ActiveMDIChild as TobrSlika).Close
end;

procedure TobrSlike.mnsDatKrajClick(Sender: TObject);
begin
  Close
end;

procedure TobrSlike.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if MessageDlg ('Zavriti sa radom?', mtConfirmation,
                 [mbYes, mbNo], 0) = mrYes
  then Action := caFree
  else Action := caNone
end;

procedure TobrSlike.mnsVelJedanClick(Sender: TObject);
var
  Slika: TobrSlika;
begin
  Slika              := ActiveMDIChild as TobrSlika;
  Slika.ClientWidth  := Slika.sliSlika.Picture.Width;
  Slika.ClientHeight := Slika.sliSlika.Picture.Height
end;

procedure TobrSlike.mnsVelPovecajClick(Sender: TObject);
var
  Slika: TobrSlika;
  Faktor: string;
  F: Integer;
begin
  Faktor := '2';
  if InputQuery ('Promena veliine',
                 'Faktor poveanja:', Faktor) then
  begin
    F                 := StrToInt (Faktor);
    Slika             := ActiveMDIChild as TobrSlika;
    Slika.ClientWidth :=Slika.sliSlika.Picture.Width  * F;
    Slika.ClientHeight:=Slika.sliSlika.Picture.Height * F
  end
end;

procedure TobrSlike.mnsVelSmanjiClick(Sender: TObject);
var
  Slika: TobrSlika;
  Faktor: string;
  F: Integer;
begin
  Faktor := '2';
  if InputQuery ('Promena veliine',
                 'Faktor smanjenja:', Faktor) then
  begin
    F                 := StrToInt (Faktor);
    Slika             := ActiveMDIChild as TobrSlika;
    Slika.ClientWidth :=Slika.sliSlika.Picture.Width  div F;
    Slika.ClientHeight:=Slika.sliSlika.Picture.Height div F
  end
end;

procedure TobrSlike.mnsProVodoravnoClick(Sender: TObject);
begin
  TileMode := tbHorizontal; Tile
end;

procedure TobrSlike.mnsProUspravnoClick(Sender: TObject);
begin
  TileMode := tbVertical; Tile
end;

procedure TobrSlike.mnsProKaskadnoClick(Sender: TObject);
begin
  Cascade
end;

procedure TobrSlike.mnsProSrediClick(Sender: TObject);
begin
  ArrangeIcons
end;

end.
