unit Poli_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TobrPolinom = class(TForm)
    oznStepen: TLabel;
    tksStepen: TEdit;
    oznKoeficijent: TLabel;
    tksKoeficijent: TEdit;
    dgmPrihvati: TButton;
    dgmNoviPolinom: TButton;
    oznRedPolinoma: TLabel;
    rezRedPolinoma: TLabel;
    oznKoeficijenti: TLabel;
    rezKoeficijenti: TLabel;
    oznArgument: TLabel;
    tksArgument: TEdit;
    dgmRacunaj: TButton;
    oznVrednostPolinoma: TLabel;
    rezVrednostPolinoma: TLabel;
    procedure dgmNoviPolinomClick(Sender: TObject);
    procedure dgmPrihvatiClick(Sender: TObject);
    procedure dgmRacunajClick(Sender: TObject);
  private
    { Private declarations }
    Polinom: array [0..10] of Real;
    RedPolinoma: 0..10;
  public
    { Public declarations }
  end;

var
  obrPolinom: TobrPolinom;

implementation

{$R *.DFM}

procedure TobrPolinom.dgmNoviPolinomClick(Sender: TObject);
var
  I: Integer;
begin
  RedPolinoma := 0;
  for I := 0 to 10 do Polinom[I] := 0;
  rezRedPolinoma.Caption  := '0';
  rezKoeficijenti.Caption := '0';
  tksStepen.Text          := '0';
  tksKoeficijent.Text     := '0'
end;

procedure TobrPolinom.dgmPrihvatiClick(Sender: TObject);
var
  Stepen: Integer;
  Koeficijent: Real;
  Koeficijenti: string;
begin
  Stepen      := StrToInt   (tksStepen.Text);
  Koeficijent := StrToFloat (tksKoeficijent.Text);
  Polinom[Stepen] := Koeficijent;
  if Stepen > RedPolinoma then RedPolinoma := Stepen;
  rezRedPolinoma.Caption := IntToStr (RedPolinoma);
  Inc (Stepen);
  tksStepen.Text := IntToStr (Stepen);
  Koeficijenti := '';
  for Stepen := RedPolinoma downto 0 do
    Koeficijenti := Koeficijenti +
                    FloatToStr (Polinom[Stepen]) + ' ';
  rezKoeficijenti.Caption := Koeficijenti;
end;

procedure TobrPolinom.dgmRacunajClick(Sender: TObject);
var
  I: Integer;
  X, P: Real;
begin
  X := StrToFloat (tksArgument.Text);
  P := Polinom[RedPolinoma];
  for I := RedPolinoma-1 downto 0 do
    P := P * X + Polinom[I];
  rezVrednostPolinoma.Caption := FloatToStr (P)
end;

end.
