unit Odvuci_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type
  TobrOdvuci = class(TForm)
    oznJedan: TLabel;
    oznDva: TLabel;
    oznTri: TLabel;
    dgsDa: TBitBtn;
    dgsNe: TBitBtn;
    dgsOdustani: TBitBtn;
    procedure oznJedanDragOver(Sender, Source: TObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure oznJedanDragDrop(Sender, Source: TObject;
      X, Y: Integer);
    procedure dgsDaDragOver(Sender, Source: TObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure dgsDaDragDrop(Sender, Source: TObject;
      X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrOdvuci: TobrOdvuci;

implementation

{$R *.DFM}

procedure TobrOdvuci.oznJedanDragOver(Sender,Source:TObject;
  X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := Source is TLabel
end;

procedure TobrOdvuci.oznJedanDragDrop(
  Sender, Source: TObject; X, Y: Integer);
var
  A: string;
begin
  A := (Sender as TLabel).Caption;
  (Sender as TLabel).Caption := (Source as TLabel).Caption;
  (Source as TLabel).Caption := A
end;

procedure TobrOdvuci.dgsDaDragOver(Sender, Source: TObject;
  X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := Source is TBitBtn
end;

procedure TobrOdvuci.dgsDaDragDrop(Sender, Source: TObject;
  X, Y: Integer);
var
  A: Integer;
begin
  A := (Sender as TBitBtn).Left;
  (Sender as TBitBtn).Left := (Source as TBitBtn).Left;
  (Source as TBitBtn).Left := A;
  A := (Sender as TBitBtn).Top;
  (Sender as TBitBtn).Top  := (Source as TBitBtn).Top;
  (Source as TBitBtn).Top  := A
end;

end.
