unit Ocene_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, StdCtrls;

type
  TobrOcene = class(TForm)
    tabOcene: TStringGrid;
    vltVrste: TMemo;
    vltKolone: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure tabOceneSelectCell(Sender: TObject;
      Col, Row: Longint; var CanSelect: Boolean);
    procedure tabOceneSetEditText(Sender: TObject;
      ACol, ARow: Longint; const Value: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  obrOcene: TobrOcene;

implementation

{$R *.DFM}

procedure TobrOcene.FormCreate(Sender: TObject);
begin
  with tabOcene do
  begin
    ColCount := vltKolone.Lines.Count;
    RowCount := vltVrste.Lines.Count;
    Rows[0]  := vltKolone.Lines;
    Cols[0]  := vltVrste.Lines;
    ColWidths[0]          := vltVrste.Width;
    ColWidths[ColCount-1] := vltKolone.Width;
    Height   := RowCount * (DefaultRowHeight + 1) + 2;
    Width    := ColWidths[0] + ColWidths[ColCount-1] +
              (ColCount - 2) * (DefaultColWidth + 1) + 4;
    obrOcene.ClientWidth  := Width;
    obrOcene.ClientHeight := Height;
  end
end;

procedure TobrOcene.tabOceneSelectCell(Sender: TObject;
  Col, Row: Longint; var CanSelect: Boolean);
begin
  CanSelect := Col <> tabOcene.ColCount - 1
end;

procedure TobrOcene.tabOceneSetEditText(Sender: TObject;
  ACol, ARow: Longint; const Value: String);
var
  Oc, Br, ZbBr, ZbOcBr: Integer;
begin
  ZbBr   := 0;
  ZbOcBr := 0;
  with tabOcene do
  begin
    for Oc := 1 to ColCount-2 do
      if Cells[Oc,ARow] <> '' then
      begin
        Br     := StrToInt (Cells[Oc,ARow]);
        ZbBr   := ZbBr + Br;
        ZbOcBr := ZbOcBr + Oc * Br;
      end;
    if ZbBr <> 0 then
      Cells[ColCount-1,ARow]:=Format('%5.2f',[ZbOcBr/ZbBr])
    else
      Cells[ColCount-1,ARow]:=''
  end
end;

end.
