unit Koshit_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TobrKosiHitac = class(TForm)
    grpBrzina: TGroupBox;
    oznBrzina: TLabel;
    oznBrzJedinica: TLabel;
    kliBrzina: TScrollBar;
    rdgMetSek: TRadioButton;
    rdgKmSat: TRadioButton;
    grpUgao: TGroupBox;
    oznUgao: TLabel;
    oznUgJedinica: TLabel;
    kliUgao: TScrollBar;
    rdgRadijani: TRadioButton;
    rdgStepeni: TRadioButton;
    oznVreme: TLabel;
    oznDaljina: TLabel;
    oznVisina: TLabel;
    rezVreme: TLabel;
    rezDaljina: TLabel;
    rezVisina: TLabel;
    procedure kliBrzinaChange(Sender: TObject);
    procedure kliUgaoChange(Sender: TObject);
    procedure rdgMetSekClick(Sender: TObject);
    procedure rdgKmSatClick(Sender: TObject);
    procedure rdgRadijaniClick(Sender: TObject);
    procedure rdgStepeniClick(Sender: TObject);
  private
    { Private declarations }
    procedure Racunaj;
  public
    { Public declarations }
  end;

var
  obrKosiHitac: TobrKosiHitac;

implementation

{$R *.DFM}

procedure TobrKosiHitac.kliBrzinaChange(Sender: TObject);
begin
  oznBrzina.Caption := IntToStr(kliBrzina.Position);
  Racunaj
end;

procedure TobrKosiHitac.kliUgaoChange(Sender: TObject);
begin
  if rdgRadijani.Checked then
    oznUgao.Caption := FloatToStr(kliUgao.Position/10000)
  else
    oznUgao.Caption := IntToStr(kliUgao.Position);
  Racunaj
end;

procedure TobrKosiHitac.Racunaj;
const G = 9.8062;
var   V, Fi, T: Real;
begin
  V := kliBrzina.Position;
  if rdgKmSat.Checked then V := V / 3.6;
  if rdgRadijani.Checked then
    Fi := kliUgao.Position / 10000.
  else
    Fi := kliUgao.Position * Pi / 180;
  T := 2 * V / G * Sin (Fi);
  rezVreme.Caption   := FloatToStr (T) + ' s';
  rezDaljina.Caption := FloatToStr (T*V*Cos(Fi))   + ' m';
  rezVisina.Caption  := FloatToStr (T*V/4*Sin(Fi)) + ' m'
end;

procedure TobrKosiHitac.rdgMetSekClick(Sender: TObject);
begin
  if oznBrzJedinica.Caption = 'km/h' then
  begin
    oznBrzJedinica.Caption := 'm/s';
    kliBrzina.SetParams (
      Round (kliBrzina.Position / 3.6), 0, 100);
  end
end;

procedure TobrKosiHitac.rdgKmSatClick(Sender: TObject);
begin
  if oznBrzJedinica.Caption = 'm/s' then
  begin
    oznBrzJedinica.Caption := 'km/h';
    kliBrzina.SetParams (
      Round (kliBrzina.Position * 3.6), 0, 360);
  end
end;

procedure TobrKosiHitac.rdgRadijaniClick(Sender: TObject);
begin
  if oznUgJedinica.Caption = 'step' then
  begin
    oznUgJedinica.Caption := 'rad';
    kliUgao.SetParams (
      Round (kliUgao.Position * Pi / 0.0180), 0, 15707);
    kliUgao.LargeChange := 1000;
    kliUgao.SmallChange := 100
  end
end;

procedure TobrKosiHitac.rdgStepeniClick(Sender: TObject);
begin
  if oznUgJedinica.Caption = 'rad' then
  begin
    oznUgJedinica.Caption := 'step';
    kliUgao.SetParams (
      Round (kliUgao.Position / Pi * 0.0180), 0, 90);
    kliUgao.LargeChange := 5;
    kliUgao.SmallChange := 1
  end
end;

end.
