unit Kompl_m;

interface
  type
    TKompleks = class
    public
      procedure Kompleksni (R, I: Real);
      function  Realni    : Real;
      function  Imaginarni: Real;
      procedure Zbir     (A, B: TKompleks);
      procedure Razlika  (A, B: TKompleks);
      procedure Proizvod (A, B: TKompleks);
      procedure Kolicnik (A, B: TKompleks);
    private
      Re, Im: Real;
    end;

implementation

procedure TKompleks.Kompleksni (R, I: Real);
begin
  Re := R; Im := I
end;

function TKompleks.Realni: Real;
begin
  Result := Re
end;

function TKompleks.Imaginarni: Real;
begin
  Result := Im
end;

procedure TKompleks.Zbir (A, B: TKompleks);
begin
  Re := A.Re + B.Re;
  Im := A.Im + B.Im
end;

procedure TKompleks.Razlika (A, B: TKompleks);
begin
  Re := A.Re - B.Re;
  Im := A.Im - B.Im
end;

procedure TKompleks.Proizvod (A, B: TKompleks);
begin
  Re := A.Re * B.Re - A.Im * B.Im;
  Im := A.Im * B.Re + A.Re * B.Im
end;

procedure TKompleks.Kolicnik (A, B: TKompleks);
var
  D: Real;
begin
  D  :=  B.Re * B.Re + B.Im * B.Im;
  Re := (A.Re * B.Re + A.Im * B.Im) / D;
  Im := (A.Im * B.Re - A.Re * B.Im) / D
end;

end.
