unit Kalend_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, ExtCtrls, Grids, Calendar, Tabs;

type
  TobrKalendar = class(TForm)
    jezKalendar: TTabSet;
    sveKalendar: TNotebook;
    kalKalendar: TCalendar;
    pnlKalendar: TPanel;
    oznDan: TLabel;
    oznMes: TLabel;
    oznGod: TLabel;
    broMes: TSpinEdit;
    broGod: TSpinEdit;
    broDan: TSpinEdit;
    rezVreme: TLabel;
    casVreme: TTimer;
    casStoperica: TTimer;
    rezDatum: TLabel;
    rezProslo: TLabel;
    dgmKreni: TButton;
    dgmStani: TButton;
    dgmNastavi: TButton;
    procedure FormCreate(Sender: TObject);
    procedure jezKalendarClick(Sender: TObject);
    procedure sveKalendarPageChanged(Sender: TObject);
    procedure brojaciChange(Sender: TObject);
    procedure kalKalendarChange(Sender: TObject);
    procedure casVremeTimer(Sender: TObject);
    procedure dgmKreniClick(Sender: TObject);
    procedure dgmStaniClick(Sender: TObject);
    procedure dgmNastaviClick(Sender: TObject);
    procedure casStopericaTimer(Sender: TObject);
  private
    { Private declarations }
    Pocetak: Real;
    procedure Danas;
  public
    { Public declarations }
  end;

var
  obrKalendar: TobrKalendar;

implementation

{$R *.DFM}

procedure TobrKalendar.Danas;
var G, M, D: Word;
begin
  DecodeDate (Now, G, M, D);
  with kalKalendar do
  begin
    Year := G; Month := M; Day := D
  end;
  broGod.Value := G; broMes.Value := M; broDan.Value := D;
end;

procedure TobrKalendar.FormCreate(Sender: TObject);
begin
  Danas;       Pocetak := Now;
  jezKalendar.Tabs     := sveKalendar.Pages;
  jezKalendar.TabIndex := sveKalendar.PageIndex
end;

procedure TobrKalendar.jezKalendarClick(Sender: TObject);
begin
  sveKalendar.PageIndex := jezKalendar.TabIndex
end;

procedure TobrKalendar.sveKalendarPageChanged(Sender: TObject);
begin
  casVreme.Enabled     := False;
  casStoperica.Enabled := False;
  case sveKalendar.PageIndex of
  0: begin Caption := 'Kalendar'; Danas end;
  1: begin Caption := 'Vreme'; casVreme.Enabled := True end;
  2:       Caption := 'Proteklo';
  end
end;

procedure TobrKalendar.brojaciChange(Sender: TObject);
begin
  with kalKalendar do
  begin
    Year  := broGod.Value;
    Month := broMes.Value;
    Day   := broDan.Value
  end
end;

procedure TobrKalendar.kalKalendarChange(Sender: TObject);
begin
  if kalKalendar.Focused then broDan.Value:=kalKalendar.Day
end;

procedure TobrKalendar.casVremeTimer(Sender: TObject);
begin
  rezVreme.Caption := TimeToStr (Now);
  rezDatum.Caption := DateToStr (Now)
end;

procedure TobrKalendar.dgmKreniClick(Sender: TObject);
begin
  Pocetak := Now;
  casStoperica.Enabled := True;
end;

procedure TobrKalendar.dgmStaniClick(Sender: TObject);
begin
  casStoperica.Enabled := False;
end;

procedure TobrKalendar.dgmNastaviClick(Sender: TObject);
begin
  casStoperica.Enabled := True;
end;

procedure TobrKalendar.casStopericaTimer(Sender: TObject);
begin
  rezProslo.Caption := Format('%.1f',[(Now-Pocetak)*86400]);
end;

end.
