unit Elipse_o;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TobrElipse = class(TForm)
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
  private
    { Private declarations }
    procedure Crtaj (Slika: TCanvas; Sirina, Visina: Integer);
  public
    { Public declarations }
  end;

var
  obrElipse: TobrElipse;

implementation

{$R *.DFM}

uses Printers;

procedure TobrElipse.Crtaj (Slika: TCanvas; Sirina, Visina: Integer);
const
  T = 'O v o   s u   e l i p s e';
var
  X, Y, Rx, Ry, I: Integer;
begin
  X := Sirina div 2;
  Y := Visina div 2;
  for I := 10 downto 0 do
  begin
    Rx := X * I div 10; Ry := Y * I div 10;
    Slika.Ellipse (X-Rx, Y-Ry, X+Rx, Y+Ry);
  end;
  with Slika do
    TextOut (X - (TextWidth (T) div 2),
             Y - (TextHeight(T) div 2), T)
end;

procedure TobrElipse.FormPaint(Sender: TObject);
begin
  Crtaj (Canvas, ClientWidth, ClientHeight);
end;

procedure TobrElipse.FormResize(Sender: TObject);
begin
  Invalidate
end;

procedure TobrElipse.FormDblClick(Sender: TObject);
begin
  if MessageDlg ('tampati sliku?', mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
  begin
    Printer.Orientation := poLandscape;
    Printer.BeginDoc;
    Printer.Canvas.Font := Font;
    Crtaj (Printer.Canvas, Printer.PageWidth, Printer.PageHeight);
    Printer.EndDoc
  end
end;

end.
