/*
 * zniztest.c
 *
 * Testiranje raznih funkcija za rad sa znakovnim nizovima.
 */

#include <stdio.h>
#include <stdlib.h>

/* prototipovi funkcija */
int ZnizDuz(char *);
char *KopZniz(char *, char *);

int
main ()
{
	/* poruke i baferi */
	static char poruka[] = {"Ovo je test!"};
	static char bafer[] = {
		"BAFER BAFER BAFER BAFER"
	};
    puts("\nTestiranje ZnizDuz() :");
	printf("Sadrzaj znakovnog niza = %s\n", poruka);
	printf("Broj znakova = %d\n",
		ZnizDuz(poruka));

    puts("\nTestiranje KopZniz() :");
    printf("Bafer pre kopiranja = %s\n", bafer);
    printf("Bafer posle kopiranja = %s\n",
		KopZniz( bafer, poruka));

	return EXIT_SUCCESS;
}

int
ZnizDuz (char *zniz)
{
    char *cp;
    /* pokazi na pocetak znakovnog niza */
    cp = zniz;
    /* pronadji zavrsni nulti znak */
    while (*cp != '\0')
        ++cp;
    /*izracunaj duzinu znakovnog niza */
    return cp - zniz;
}

char *
KopZniz (char *zniz1, char *zniz2)
{
    char *p, *q;

    /* postavi privremene pokazivace */
    p = zniz1;
    q = zniz2;

    /* kopiraj zniz2 u zniz1 */
    while (*q != '\0') {
        *p = *q;
        ++p;
        ++q;
    }

    /* zavrsi odredisni niz */
    *p = '\0';

    /* pokazi na pocetak odredisnog niza */
    return zniz1;
}
