/*
 * vp2izv.c
 *
 * Konverzija programa izdvojenog iz Ventura Publisher ili
 * Microsoft Word fajla u standardni ASCII format.
 * Program obavlja sledee:
 *  - skida zatitu simbola @, < i > tako sto umesto udvojenih
 *    upisuje jednostruke znakove
 *  - zamenjuje znak za vertikalnu tabulaciju (VT) znakom
 *	za novi red.
 */

#include <stdio.h>
#include <stdlib.h>

#define E_KOM   1
#define E_IZV   2
#define E_CIT   3
#define E_ZATV  4
#define VT      11

void fatal (char *, int);

typedef enum stanje_e {KOPIRANJE, PROVERA} STANJE;

int
main (int argc, char *argv[])
{
	int zn, upisanZnak;
	FILE *pf;
	STANJE pzStanje = KOPIRANJE;

	/* provera sintakse komandne linije */
	if (argc != 2)
		fatal ("Pravilan poziv je: vp2izv izvorni_fajl",
			E_KOM);

	/* otvaranje fajla radi citanja u tekst rezimu */
	pf = fopen(argv[1], "rt");
	if (pf == NULL)
		fatal("Greska u otvaranju izvornog fajla", E_IZV);

	/* Kopiranje izvornog fajla na standardni izlaz */
	while ((zn = fgetc(pf)) != EOF) {
		/* obavi zahtevano prevodjenje */
		switch (zn) {
		case '@':
			switch (pzStanje) {
			case KOPIRANJE:
				putchar(zn);
				upisanZnak = zn;
				pzStanje = PROVERA;
				break;
			case PROVERA:
				if (upisanZnak != '@')
					putchar(zn);
				pzStanje = KOPIRANJE;
				break;
			}
			break;
		case '<':
			switch (pzStanje) {
			case KOPIRANJE:
				putchar(zn);
				upisanZnak = zn;
				pzStanje = PROVERA;
				break;
			case PROVERA:
				if (upisanZnak != '<')
					putchar(zn);
				pzStanje = KOPIRANJE;
				break;
			}
			break;
		case '>':
			switch (pzStanje) {
			case KOPIRANJE:
				putchar(zn);
				upisanZnak = zn;
				pzStanje = PROVERA;
				break;
			case PROVERA:
				if (upisanZnak != '>')
					putchar(zn);
				pzStanje = KOPIRANJE;
				break;
			}
			break;
		case VT:
			/* znak za kraj reda */
			putchar('\n');
			break;
		default:
			putchar(zn);
			break;
		}
	}

	/* provera greke */
	if (ferror(pf))
		fatal("Greska u citanju izvornog fajla", E_CIT);

	/* zatvaranje fajla */
	if (fclose(pf) == EOF)
		fatal("Greska u zatvaranju izvornog fajla", E_ZATV);

	return EXIT_SUCCESS;
}
