/*
 * rrz.c
 *
 * Citanje sadrzaja specificiranog fajla i prikazivanje izvestaja
 * o broju redova, reci i znakova na standardni izlaz.
 */

#include <stdio.h>
#include <stdlib.h>

#if defined (MSDOS)
	#define MAXPUT 64
#else
	#define MAXPUT 128
#endif

typedef enum {NETACNO, TACNO} LOGIC;

int
main (void)
{
	LOGIC ureci;
	long red_broj, rec_broj, znak_broj;
	int zn;
    char ime[MAXPUT];
	FILE *pf;

	/* ucitaj od korisnika ime fajla */
	printf("Ime fajla: ");
	gets(ime);

	/* proveri ime i pokusaj da otvoris fajl */
	if (ime[0] == '\0') {
		fprintf(stderr, "Nije uneto ime\n");
		exit (EXIT_SUCCESS);
	}
	pf = fopen(ime, "r");
	if (pf == NULL) {
        fprintf(stderr, "Otvaranje %s nije uspelo.\n", ime);
		exit (EXIT_FAILURE);
	}

	/* analiza sadrzaja fajla */
	red_broj = rec_broj = znak_broj = 0;
	ureci = NETACNO;
	while (( zn = fgetc(pf)) != EOF) {
		++znak_broj;
        if (zn == ' ' || zn == '\t' || zn == '\n')
			ureci = NETACNO;
		else if (ureci == NETACNO) {
			++rec_broj;
			ureci = TACNO;
		}
		if (zn == '\n')
			++red_broj;
	}
	if (ferror(pf) != 0) {
		fprintf(stderr, "GRESKA PRI CITANJU: %s\n", ime);
		exit (EXIT_FAILURE);
	}

	/* prikazi rezultate analize */
	printf("%s: %ld %ld %ld\n",
		ime, red_broj, rec_broj, znak_broj);

	return (EXIT_SUCCESS);
}
